/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.google.common.geometry.S1ChordAngle;
import com.google.common.geometry.S2Error;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2Shape;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographyCollection;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.PolylineGeography;

public class Accessors {
    public static boolean S2_isEmpty(Geography geography) {
        for (int i = 0; i < geography.numShapes(); ++i) {
            S2Shape shape = geography.shape(i);
            if (shape.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean S2_isCollection(PolygonGeography polygonGeography) {
        int numOuterLoops = 0;
        for (int i = 0; i < polygonGeography.polygon.numLoops(); ++i) {
            S2Loop loop = polygonGeography.polygon.loop(i);
            if (loop.depth() != 0 || ++numOuterLoops <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean S2_isCollection(Geography geog) {
        int dim = Accessors.S2_dimension(geog);
        if (dim == -1) {
            return false;
        }
        switch (dim) {
            case 0: {
                return Accessors.S2_numPoints(geog) > 1;
            }
            case 1: {
                int chainCount = 0;
                int n = geog.numShapes();
                for (int i = 0; i < n; ++i) {
                    S2Shape shape = geog.shape(i);
                    if ((chainCount += shape.numChains()) <= 1) continue;
                    return true;
                }
                return false;
            }
        }
        if (geog instanceof PolygonGeography) {
            return Accessors.S2_isCollection((PolygonGeography)geog);
        }
        throw new IllegalArgumentException("Cannot determine collection status for geography type: " + geog.getClass().getName());
    }

    public static int S2_dimension(Geography geography) {
        int dimension = geography.dimension();
        if (dimension != -1) {
            return dimension;
        }
        for (int i = 0; i < geography.numShapes(); ++i) {
            S2Shape shape = geography.shape(i);
            if (shape.dimension() <= dimension) continue;
            dimension = shape.dimension();
        }
        return dimension;
    }

    public static int S2_numPoints(Geography geography) {
        int numPoints = 0;
        block4: for (int i = 0; i < geography.numShapes(); ++i) {
            S2Shape shape = geography.shape(i);
            switch (shape.dimension()) {
                case 0: 
                case 2: {
                    numPoints += shape.numEdges();
                    continue block4;
                }
                case 1: {
                    numPoints += shape.numEdges() + shape.numChains();
                }
            }
        }
        return numPoints;
    }

    double S2_area(Geography geog) {
        if (Accessors.S2_dimension(geog) != 2) {
            return 0.0;
        }
        switch (geog.kind) {
            case POLYGON: {
                if (geog != null) {
                    return this.S2_area((PolygonGeography)geog);
                }
            }
            case GEOGRAPHY_COLLECTION: {
                if (geog == null) break;
                return this.S2_area((GeographyCollection)geog);
            }
        }
        throw new IllegalArgumentException("Unsupported geography kind for area: " + geog.kind);
    }

    public double S2_area(GeographyCollection geographyCollection) {
        double area = 0.0;
        for (Geography geography : geographyCollection.features) {
            area += this.S2_area(geography);
        }
        return area;
    }

    double S2_area(PolygonGeography polygonGeography) {
        return polygonGeography.polygon.getArea();
    }

    public double s2_length(Geography geog) {
        double length = 0.0;
        if (Accessors.S2_dimension(geog) == 1) {
            int n = geog.numShapes();
            for (int i = 0; i < n; ++i) {
                S2Shape shape = geog.shape(i);
                int m = shape.numEdges();
                for (int j = 0; j < m; ++j) {
                    S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                    shape.getEdge(j, edge);
                    S1ChordAngle angle = new S1ChordAngle(edge.a, edge.b);
                    length += angle.radians();
                }
            }
        }
        return length;
    }

    public double s2_perimeter(Geography geog) {
        double perimeter = 0.0;
        if (Accessors.S2_dimension(geog) == 2) {
            int n = geog.numShapes();
            for (int i = 0; i < n; ++i) {
                S2Shape shape = geog.shape(i);
                int m = shape.numEdges();
                for (int j = 0; j < m; ++j) {
                    S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
                    shape.getEdge(j, edge);
                    S1ChordAngle angle = new S1ChordAngle(edge.a, edge.b);
                    perimeter += angle.radians();
                }
            }
        }
        return perimeter;
    }

    public static double s2_X(Geography geog) {
        double out = Double.NaN;
        int n = geog.numShapes();
        for (int i = 0; i < n; ++i) {
            S2Shape shape = geog.shape(i);
            if (shape.dimension() != 0 || shape.numEdges() != 1) continue;
            S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
            shape.getEdge(0, edge);
            if (Double.isNaN(out)) {
                out = S2LatLng.fromPoint((S2Point)edge.a).lng().degrees();
                continue;
            }
            return Double.NaN;
        }
        return out;
    }

    public static double s2_Y(Geography geog) {
        double out = Double.NaN;
        int n = geog.numShapes();
        for (int i = 0; i < n; ++i) {
            S2Shape shape = geog.shape(i);
            if (shape.dimension() != 0 || shape.numEdges() != 1) continue;
            S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
            shape.getEdge(0, edge);
            if (Double.isNaN(out)) {
                out = S2LatLng.fromPoint((S2Point)edge.a).lat().degrees();
                continue;
            }
            return Double.NaN;
        }
        return out;
    }

    public static boolean s2FindValidationError(PolylineGeography geog, S2Error error) {
        for (S2Polyline polyline : geog.getPolylines()) {
            if (!polyline.findValidationError(error)) continue;
            return true;
        }
        return false;
    }

    public static boolean s2FindValidationError(PolygonGeography geog, S2Error error) {
        return geog.polygon.findValidationError(error);
    }

    public static boolean s2FindValidationError(GeographyCollection geog, S2Error error) {
        for (Geography feature : geog.getFeatures()) {
            if (!Accessors.s2FindValidationError(feature, error)) continue;
            return true;
        }
        return false;
    }

    public static boolean s2FindValidationError(Geography geog, S2Error error) {
        int dim = geog.dimension();
        switch (dim) {
            case 0: {
                error.clear();
                return false;
            }
            case 1: {
                if (geog instanceof PolylineGeography) {
                    return Accessors.s2FindValidationError((PolylineGeography)geog, error);
                }
                throw new IllegalArgumentException("Expected PolylineGeography for dimension 1, but got: " + geog.getClass().getName());
            }
            case 2: {
                if (geog instanceof PolygonGeography) {
                    return Accessors.s2FindValidationError((PolygonGeography)geog, error);
                }
                throw new IllegalArgumentException("Expected PolygonGeography for dimension 2, but got: " + geog.getClass().getName());
            }
        }
        if (geog instanceof GeographyCollection) {
            return Accessors.s2FindValidationError((GeographyCollection)geog, error);
        }
        throw new IllegalArgumentException("Unsupported geography type for validation: " + geog.getClass().getName());
    }
}

