/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.nv;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.nv.PhTreeNV;
import ch.ethz.globis.phtree.util.PhMapperKey;
import ch.ethz.globis.phtree.util.PhTreeStats;
import java.util.Iterator;
import java.util.List;

public class PhTreeVProxy
extends PhTreeNV {
    public final Object VALUE_PLACEHOLDER = new Object();
    private final PhTree<Object> tree;

    public PhTreeVProxy(int dim) {
        this.tree = PhTree.create(dim);
    }

    public PhTreeVProxy(PhTree<Object> tree) {
        this.tree = tree;
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public PhTreeStats getQuality() {
        return this.tree.getStats();
    }

    @Override
    public boolean insert(long ... key) {
        return this.tree.put(key, this.VALUE_PLACEHOLDER) != null;
    }

    @Override
    public boolean contains(long ... key) {
        return this.tree.contains(key);
    }

    @Override
    public boolean delete(long ... key) {
        return this.tree.remove(key) != null;
    }

    @Override
    public String toStringPlain() {
        return this.tree.toStringPlain();
    }

    @Override
    public String toStringTree() {
        return this.tree.toStringTree();
    }

    @Override
    public Iterator<long[]> queryExtent() {
        return new IteratorProxy(this.tree.queryExtent());
    }

    @Override
    public PhTreeNV.PhIteratorNV query(long[] min2, long[] max) {
        return new IteratorProxy(this.tree.query(min2, max));
    }

    public String toString() {
        return this.tree.toString();
    }

    @Override
    public int getDIM() {
        return this.tree.getDim();
    }

    @Override
    public int getDEPTH() {
        return this.tree.getBitDepth();
    }

    @Override
    public PhTree.PhKnnQuery<long[]> nearestNeighbour(int nMin, long ... v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean update(long[] p1, long[] p2) {
        return this.tree.update(p1, p2) != null;
    }

    @Override
    public List<PhEntry<Object>> queryAll(long[] min2, long[] max) {
        return this.tree.queryAll(min2, max);
    }

    @Override
    public <R> List<R> queryAll(long[] min2, long[] max, int maxResults, PhFilter filter, PhMapperKey<R> mapper) {
        if (mapper != null) {
            return this.tree.queryAll(min2, max, maxResults, filter, (PhEntry<T> e) -> mapper.map(e.getKey()));
        }
        return this.tree.queryAll(min2, max, maxResults, null, null);
    }

    private static class IteratorProxy<T>
    implements PhTreeNV.PhIteratorNV {
        private final PhTree.PhIterator<T> iter;

        private IteratorProxy(PhTree.PhIterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public long[] next() {
            return this.iter.nextKey();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public boolean hasNextKey() {
            return this.iter.hasNext();
        }

        @Override
        public long[] nextKey() {
            return this.iter.nextKey();
        }
    }
}

