/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.DebugDevice;
import org.twak.utils.collections.DHash;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.SetCorrespondence;
import org.twak.utils.geom.Ray3d;

public class SkeletonCapUpdate {
    Skeleton skel;
    double height;
    double finalHeight;
    DHash<Corner, Corner> oBCorner = new DHash();
    LoopL<Corner> oldCorners;
    Map<Edge, EdgeInfo> edgeInfo = new HashMap<Edge, EdgeInfo>();
    DHash<Corner, Corner> nOCorner;
    SetCorrespondence<Corner, Corner> nOSegments;

    public SkeletonCapUpdate(Skeleton skel) {
        this.skel = skel;
    }

    public LoopL<Corner> getCap(double height) {
        return this.getCap(height, height);
    }

    public LoopL<Corner> getCap(double height, double finalHeight) {
        this.height = height;
        this.finalHeight = finalHeight;
        this.oldCorners = this.skel.capCopy(height);
        this.oBCorner = this.skel.cornerMap;
        for (Corner c : this.oldCorners.eIterator()) {
            c.z = 0.0;
            Corner baseC = this.skel.cornerMap.get(c);
            EdgeInfo ei = this.edgeInfo.get(baseC.nextL);
            if (ei == null) {
                ei = new EdgeInfo(baseC.nextL);
                this.edgeInfo.put(baseC.nextL, ei);
            }
            ei.addBottomSeg(c);
        }
        for (Corner c : this.oldCorners.eIterator()) {
            c.nextL.calculateLinearForm();
        }
        return this.oldCorners;
    }

    public DHash<Corner, Corner> getOldBaseLookup() {
        return this.oBCorner;
    }

    public void update(LoopL<Corner> newPlan, SetCorrespondence<Corner, Corner> nOSegments, DHash<Corner, Corner> nOCorner) {
        this.nOSegments = nOSegments;
        this.nOCorner = nOCorner;
        for (Corner corner : newPlan.eIterator()) {
            LinkedHashSet<EdgeInfo> eiToMerge = new LinkedHashSet<EdgeInfo>();
            for (Corner old : nOSegments.getSetA(corner)) {
                eiToMerge.add(this.edgeInfo.get(this.oBCorner.get((Corner)old).nextL));
            }
            if (eiToMerge.size() < 2) continue;
            Iterator eiit = eiToMerge.iterator();
            EdgeInfo toKeep = (EdgeInfo)eiit.next();
            while (eiit.hasNext()) {
                EdgeInfo togo = (EdgeInfo)eiit.next();
                toKeep.addFrom(togo);
                this.edgeInfo.remove(togo.base);
                this.skel.output.merge(toKeep.base.start, togo.base.start);
            }
        }
        for (Corner corner : this.oBCorner.ab.keySet()) {
            corner.z = this.height;
        }
        for (Corner corner : newPlan.eIterator()) {
            corner.z = this.finalHeight;
        }
        for (Corner corner : newPlan.eIterator()) {
            corner.nextL.calculateLinearForm();
            for (Corner oldSegment : nOSegments.getSetA(corner)) {
                Edge baseEdge = this.oBCorner.get((Corner)oldSegment).nextL;
                EdgeInfo ei = this.edgeInfo.get(baseEdge);
                if (ei == null) {
                    ei = new EdgeInfo(baseEdge);
                    this.edgeInfo.put(baseEdge, ei);
                }
                ei.addTopSeg(corner);
            }
        }
        HashSet<Corner> cornersToDelete = new HashSet<Corner>(this.skel.liveCorners);
        for (Corner c : newPlan.eIterator()) {
            this.collectCorners(c, cornersToDelete);
        }
        for (Corner baseC : cornersToDelete) {
            Corner old = this.oBCorner.teg(baseC);
            this.skel.output.addOutputSideTo(old, (Tuple3d)baseC, baseC.prevL, baseC.nextL);
            baseC.prevL.currentCorners.remove(baseC);
            baseC.nextL.currentCorners.remove(baseC);
        }
        this.skel.liveCorners.removeAll(cornersToDelete);
        for (Edge baseE : this.edgeInfo.keySet()) {
            EdgeInfo ei = this.edgeInfo.get(baseE);
            if (ei == null) continue;
            List<Segment> segs = ei.sort();
            Segment trailing = null;
            for (Segment s2 : segs) {
                if (nOCorner.containsA(s2.corner) || nOCorner.containsB(s2.corner)) {
                    assert (trailing == null);
                    continue;
                }
                if (!s2.top) {
                    Corner baseC = this.oBCorner.get(s2.corner);
                    this.skel.output.addOutputSideTo(s2.corner, (Tuple3d)baseC, baseC.prevL, baseC.nextL);
                    baseE.currentCorners.remove(s2.corner);
                } else {
                    this.skel.liveCorners.add(s2.corner);
                    baseE.currentCorners.add(s2.corner);
                    if (s2.start) {
                        s2.corner.nextL = baseE;
                    } else {
                        s2.corner.prevL = baseE;
                    }
                }
                if (trailing != null) {
                    this.skel.output.addOutputSideTo(true, (Tuple3d)trailing.corner, s2.corner, baseE);
                    trailing = null;
                    continue;
                }
                trailing = s2;
            }
        }
        Iterator<Edge> iterator = this.skel.liveEdges.iterator();
        while (iterator.hasNext()) {
            Edge e = iterator.next();
            if (e.currentCorners.size() != 0) continue;
            iterator.remove();
            this.skel.liveCorners.remove(e.start);
            this.skel.liveCorners.remove(e.end);
        }
        this.skel.refindAllFaceEventsLater();
        DebugDevice.dump("post cap update", this.skel);
        this.skel.validate();
    }

    private void collectCorners(Corner neu, Set<Corner> toDelete) {
        Set<Corner> oldSegments = this.nOSegments.getSetA(neu);
        Corner old = this.nOCorner.get(neu);
        Corner base = this.oBCorner.get(old);
        Edge neuEdge = neu.nextL;
        if (oldSegments.isEmpty()) {
            if (this.skel.liveEdges.add(neuEdge)) {
                this.skel.output.newEdge(neuEdge, null, neuEdge.profileFeatures);
                neuEdge.machine.addEdge(neuEdge, this.skel);
            }
            this.skel.output.newDefiningSegment(neu);
        }
        if (old != null) {
            assert (base != null);
            neu.prevC.nextC = base;
            neu.nextC.prevC = base;
            base.nextC = neu.nextC;
            base.prevC = neu.prevC;
            toDelete.remove(base);
        } else {
            this.skel.liveCorners.add(neu);
            neuEdge.currentCorners.add(neu);
            neu.prevL.currentCorners.add(neu);
        }
    }

    static class LineProjectionComparator
    implements Comparator<Segment> {
        Ray3d line;

        public LineProjectionComparator(Point3d start, Point3d end) {
            Vector3d dir = new Vector3d(end);
            dir.sub(start);
            this.line = new Ray3d(start, dir);
        }

        @Override
        public int compare(Segment o1, Segment o2) {
            return Double.compare(this.line.projectParam(o1.corner), this.line.projectParam(o2.corner));
        }
    }

    static class Segment {
        Corner corner;
        boolean top;
        boolean start;

        Segment(Corner corner, boolean top, boolean start) {
            this.corner = corner;
            this.top = top;
            this.start = start;
        }
    }

    public static class EdgeInfo {
        Edge base;
        List<Segment> segs = new ArrayList<Segment>();

        public EdgeInfo(Edge base) {
            this.base = base;
        }

        public void addTopSeg(Corner c) {
            this.segs.add(new Segment(c, true, true));
            this.segs.add(new Segment(c.nextC, true, false));
        }

        public void addBottomSeg(Corner c) {
            this.segs.add(new Segment(c, false, true));
            this.segs.add(new Segment(c.nextC, false, false));
        }

        List<Segment> sort() {
            Collections.sort(this.segs, new LineProjectionComparator(this.base.start, this.base.end));
            return this.segs;
        }

        void addFrom(EdgeInfo togo) {
            this.segs.addAll(togo.segs);
        }
    }
}

