/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.nc2.CDMNode;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.util.Indent;

public class Dimension
extends CDMNode
implements Comparable<Dimension> {
    public static final Dimension VLEN = Dimension.builder().setName("*").setIsVariableLength(true).build().setImmutable();
    private boolean isUnlimited;
    private boolean isVariableLength;
    private boolean isShared;
    private int length;

    @Deprecated
    public static String makeDimensionsString(List<Dimension> dimensions) {
        if (dimensions == null) {
            return "";
        }
        Formatter buf = new Formatter();
        for (int i = 0; i < dimensions.size(); ++i) {
            Dimension myd = dimensions.get(i);
            String dimName = myd.getShortName();
            if (i != 0) {
                buf.format(" ", new Object[0]);
            }
            if (myd.isVariableLength()) {
                buf.format("*", new Object[0]);
                continue;
            }
            if (myd.isShared()) {
                buf.format("%s", dimName);
                continue;
            }
            buf.format("%d", myd.getLength());
        }
        return buf.toString();
    }

    @Deprecated
    public static List<Dimension> makeDimensionsList(Group parentGroup, String dimString) throws IllegalArgumentException {
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        if (dimString == null) {
            return newDimensions;
        }
        if ((dimString = dimString.trim()).isEmpty()) {
            return newDimensions;
        }
        StringTokenizer stoke = new StringTokenizer(dimString);
        while (stoke.hasMoreTokens()) {
            String dimName = stoke.nextToken();
            Dimension d = dimName.equals("*") ? VLEN : parentGroup.findDimension(dimName);
            if (d == null) {
                try {
                    int len = Integer.parseInt(dimName);
                    d = Dimension.builder().setLength(len).setIsShared(false).build();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Dimension " + dimName + " does not exist");
                }
            }
            newDimensions.add(d);
        }
        return newDimensions;
    }

    @Deprecated
    public static List<Dimension> makeDimensionsList(List<Dimension> dimensions, String dimString) {
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        if (dimString == null) {
            return newDimensions;
        }
        if ((dimString = dimString.trim()).isEmpty()) {
            return newDimensions;
        }
        StringTokenizer stoke = new StringTokenizer(dimString);
        while (stoke.hasMoreTokens()) {
            String dimName = stoke.nextToken();
            Dimension dim = dimName.equals("*") ? VLEN : (Dimension)dimensions.stream().filter(d -> d.getShortName().equals(dimName)).findFirst().orElse(null);
            if (dim == null) {
                try {
                    int len = Integer.parseInt(dimName);
                    dim = Dimension.builder().setLength(len).setIsShared(false).build();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Dimension " + dimName + " does not exist");
                }
            }
            newDimensions.add(dim);
        }
        return newDimensions;
    }

    @Deprecated
    public static List<Dimension> makeDimensionsAnon(int[] shape) {
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        if (shape == null || shape.length == 0) {
            return newDimensions;
        }
        for (int len : shape) {
            newDimensions.add(Dimension.builder().setLength(len).setIsShared(false).build());
        }
        return newDimensions;
    }

    private Dimension(Builder builder) {
        super(builder.shortName);
        this.setParentGroup(builder.parent);
        this.isShared = builder.isShared;
        this.isVariableLength = builder.isVariableLength;
        this.isUnlimited = builder.isUnlimited;
        this.length = builder.length;
    }

    public Builder toBuilder() {
        return Dimension.builder().setName(this.shortName).setGroup(this.getGroup()).setIsUnlimited(this.isUnlimited).setIsVariableLength(this.isVariableLength).setIsShared(this.isShared).setLength(this.length);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String getName() {
        return this.shortName;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    public boolean isUnlimited() {
        return this.isUnlimited;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public boolean isShared() {
        return this.isShared;
    }

    @Override
    @Deprecated
    public Group getGroup() {
        return this.getParentGroup();
    }

    @Deprecated
    public String makeFullName() {
        return super.getFullName();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)oo;
        Group g2 = this.getGroup();
        if (g2 != null && !g2.equals(other.getGroup())) {
            return false;
        }
        if (this.getShortName() == null && other.getShortName() != null) {
            return false;
        }
        if (this.getShortName() != null && !this.getShortName().equals(other.getShortName())) {
            return false;
        }
        return this.getLength() == other.getLength() && this.isUnlimited() == other.isUnlimited() && this.isVariableLength() == other.isVariableLength() && this.isShared() == other.isShared();
    }

    public int hashCode() {
        int result = 17;
        Group g2 = this.getGroup();
        if (g2 != null) {
            result += 37 * result + g2.hashCode();
        }
        if (null != this.getShortName()) {
            result += 37 * result + this.getShortName().hashCode();
        }
        result += 37 * result + this.getLength();
        result += 37 * result + (this.isUnlimited() ? 0 : 1);
        result += 37 * result + (this.isVariableLength() ? 0 : 1);
        result += 37 * result + (this.isShared() ? 0 : 1);
        return result;
    }

    public String toString() {
        return this.writeCDL(false);
    }

    @Override
    public int compareTo(Dimension odim) {
        String name = this.getShortName();
        return name.compareTo(odim.getShortName());
    }

    @Deprecated
    public String writeCDL(boolean strict) {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), strict);
        return f.toString();
    }

    @Deprecated
    void writeCDL(Formatter out, Indent indent, boolean strict) {
        String name = strict ? NetcdfFiles.makeValidCDLName(this.getShortName()) : this.getShortName();
        out.format("%s%s", indent, name);
        if (this.isUnlimited()) {
            out.format(" = UNLIMITED;   // (%d currently)", this.getLength());
        } else if (this.isVariableLength()) {
            out.format(" = UNKNOWN;", new Object[0]);
        } else {
            out.format(" = %d;", this.getLength());
        }
    }

    public Dimension(String name, int length) {
        this(name, length, true, false, false);
    }

    @Deprecated
    public Dimension(String name, int length, boolean isShared) {
        this(name, length, isShared, false, false);
    }

    public Dimension(String name, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        super(name);
        this.isShared = isShared;
        this.isUnlimited = isUnlimited;
        this.isVariableLength = isVariableLength;
        if (isVariableLength && (isUnlimited || isShared)) {
            throw new IllegalArgumentException("variable length dimension cannot be shared or unlimited");
        }
        this.setLength(length);
        assert (name != null || !this.isShared);
    }

    @Deprecated
    public Dimension(String name, Dimension from) {
        super(name);
        this.length = from.length;
        this.isUnlimited = from.isUnlimited;
        this.isVariableLength = from.isVariableLength;
        this.isShared = from.isShared;
    }

    @Deprecated
    public void setUnlimited(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isUnlimited = b;
        this.setLength(this.length);
    }

    @Deprecated
    public void setVariableLength(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isVariableLength = b;
        if (b) {
            this.isShared = false;
            this.isUnlimited = false;
        }
        this.setLength(this.length);
    }

    @Deprecated
    public void setShared(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isShared = b;
    }

    @Deprecated
    public void setLength(int n) {
        if (this.immutable && !this.isUnlimited) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.isVariableLength) {
            if (n != -1) {
                throw new IllegalArgumentException("VariableLength Dimension length =" + n + " must be -1");
            }
        } else if (this.isUnlimited) {
            if (n < 0) {
                throw new IllegalArgumentException("Unlimited Dimension length =" + n + " must >= 0");
            }
        } else if (n < 1) {
            throw new IllegalArgumentException("Dimension length =" + n + " must be > 0");
        }
        this.length = n;
    }

    @Deprecated
    public String setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (name.isEmpty()) {
            name = null;
        }
        this.setShortName(name);
        return this.getShortName();
    }

    @Deprecated
    public void setGroup(Group g2) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setParentGroup(g2);
    }

    @Override
    @Deprecated
    public Dimension setImmutable() {
        super.setImmutable();
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name, int length) {
        return new Builder().setName(name).setLength(length);
    }

    public static class Builder {
        private Group parent;
        private String shortName;
        private boolean isUnlimited;
        private boolean isVariableLength;
        private boolean isShared = true;
        private int length;
        private boolean built;

        private Builder() {
        }

        public Builder setIsUnlimited(boolean isUnlimited) {
            this.isUnlimited = isUnlimited;
            return this;
        }

        public Builder setIsVariableLength(boolean isVariableLength) {
            this.isVariableLength = isVariableLength;
            if (isVariableLength) {
                this.isShared = false;
                this.isUnlimited = false;
                this.length = -1;
            }
            return this;
        }

        public Builder setIsShared(boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder setLength(int n) {
            if (this.isVariableLength) {
                if (n != -1) {
                    throw new IllegalArgumentException("VariableLength Dimension length =" + n + " must be -1");
                }
            } else if (this.isUnlimited) {
                if (n < 0) {
                    throw new IllegalArgumentException("Unlimited Dimension length =" + n + " must >= 0");
                }
            } else if (n < 1) {
                throw new IllegalArgumentException("Dimension length =" + n + " must be > 0");
            }
            this.length = n;
            return this;
        }

        public Builder setName(String shortName) {
            this.shortName = NetcdfFiles.makeValidCdmObjectName(shortName);
            return this;
        }

        @Deprecated
        public Builder setGroup(Group parent) {
            this.parent = parent;
            return this;
        }

        public Dimension build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Dimension(this);
        }
    }
}

