/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.osmpbf.iterators;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.sedona.sql.datasources.osmpbf.ParseUtils;
import org.apache.sedona.sql.datasources.osmpbf.build.Fileformat;
import org.apache.sedona.sql.datasources.osmpbf.build.Osmformat;
import org.apache.sedona.sql.datasources.osmpbf.extractors.DenseNodeExtractor;
import org.apache.sedona.sql.datasources.osmpbf.iterators.DenseNodeIterator;
import org.apache.sedona.sql.datasources.osmpbf.iterators.NodeIterator;
import org.apache.sedona.sql.datasources.osmpbf.iterators.RelationIterator;
import org.apache.sedona.sql.datasources.osmpbf.iterators.WayIterator;
import org.apache.sedona.sql.datasources.osmpbf.model.OSMEntity;

public class BlobIterator
implements Iterator<OSMEntity> {
    Fileformat.Blob blob;
    Osmformat.PrimitiveBlock primitiveBlock;
    int primitiveGroupIdx;
    Iterator<OSMEntity> iterator;
    Osmformat.PrimitiveGroup currentPrimitiveGroup;

    public BlobIterator(Fileformat.Blob blob) throws DataFormatException, IOException {
        this.primitiveBlock = Osmformat.PrimitiveBlock.parseFrom(ParseUtils.dataInputStreamBlob(blob));
        this.primitiveGroupIdx = 0;
        this.currentPrimitiveGroup = this.primitiveBlock.getPrimitivegroup(this.primitiveGroupIdx);
        this.iterator = this.resolveIterator();
        this.blob = blob;
    }

    @Override
    public boolean hasNext() {
        return this.primitiveGroupIdx < this.primitiveBlock.getPrimitivegroupList().size() - 1 || this.iterator.hasNext();
    }

    @Override
    public OSMEntity next() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        ++this.primitiveGroupIdx;
        this.currentPrimitiveGroup = this.primitiveBlock.getPrimitivegroup(this.primitiveGroupIdx);
        this.iterator = this.resolveIterator();
        return this.iterator.next();
    }

    Iterator<OSMEntity> resolveIterator() {
        return IteratorUtils.chainedIterator((Iterator[])new Iterator[]{new WayIterator(this.currentPrimitiveGroup.getWaysList(), this.primitiveBlock.getStringtable()), new RelationIterator(this.currentPrimitiveGroup.getRelationsList(), this.primitiveBlock.getStringtable()), new NodeIterator(this.currentPrimitiveGroup.getNodesList(), this.primitiveBlock), this.currentPrimitiveGroup.getDense() != null ? new DenseNodeIterator(this.currentPrimitiveGroup.getDense().getIdCount(), this.primitiveBlock.getStringtable(), new DenseNodeExtractor(this.currentPrimitiveGroup.getDense(), this.primitiveBlock.getLatOffset(), this.primitiveBlock.getLonOffset(), this.primitiveBlock.getGranularity())) : Collections.emptyIterator()});
    }
}

