/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v11;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.v11.Bits;
import ch.ethz.globis.phtree.v11.Node;
import ch.ethz.globis.phtree.v11.PhResultList;
import ch.ethz.globis.phtree.v11.PhTree11;
import ch.ethz.globis.phtree.v11.nt.NtIteratorMask;
import java.util.List;

public class NodeIteratorListReuse<T, R> {
    private final int dims;
    private final PhResultList<T, R> results;
    private int maxResults;
    private final long[] valTemplate;
    private long[] rangeMin;
    private long[] rangeMax;
    private final PhIteratorStack pool;

    NodeIteratorListReuse(int dims, PhResultList<T, R> results) {
        this.dims = dims;
        this.valTemplate = new long[dims];
        this.results = results;
        this.pool = new PhIteratorStack();
    }

    List<R> resetAndRun(Node node, long[] rangeMin, long[] rangeMax, int maxResults) {
        this.results.clear();
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.maxResults = maxResults;
        this.run(node);
        return this.results;
    }

    void run(Node node) {
        int i;
        long maskHcBit = 1L << node.getPostLen();
        long maskVT = -1L << node.getPostLen();
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (this.valTemplate[i] | maskHcBit) & maskVT;
                if (this.rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (this.rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (this.rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (this.rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        NodeIterator nIt = this.pool.prepare();
        nIt.reinitAndRun(node, lowerLimit, upperLimit);
        this.pool.pop();
    }

    private final class NodeIterator {
        private Node node;
        private NtIteratorMask<Object> niIterator;
        private int nMaxEntry;
        private int nEntryFound = 0;
        private long maskLower;
        private long maskUpper;
        private boolean useHcIncrementer;

        private NodeIterator() {
        }

        void reinitAndRun(Node node, long lower, long upper) {
            this.node = node;
            boolean isNI = node.isNT();
            this.niIterator = null;
            this.nMaxEntry = node.getEntryCount();
            this.nEntryFound = 0;
            this.maskLower = lower;
            this.maskUpper = upper;
            this.useHcIncrementer = false;
            if (isNI && this.niIterator == null) {
                this.niIterator = node.ntIteratorWithMask(NodeIteratorListReuse.this.dims, this.maskLower, this.maskUpper);
            }
            if (NodeIteratorListReuse.this.dims > 6) {
                this.initHCI(isNI);
            }
            this.getAll();
        }

        private void initHCI(boolean isNI) {
            long maxHcAddr = -1L << NodeIteratorListReuse.this.dims ^ 0xFFFFFFFFFFFFFFFFL;
            int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
            long nPossibleMatch = 1L << NodeIteratorListReuse.this.dims - nSetFilterBits;
            if (isNI) {
                int nChild = this.node.ntGetSize();
                int logNChild = 64 - Long.numberOfLeadingZeros(nChild);
                boolean bl = this.useHcIncrementer = NodeIteratorListReuse.this.dims < 50 && (double)nChild > (double)nPossibleMatch * (double)logNChild * 2.0;
                if (!this.useHcIncrementer) {
                    this.niIterator.reset(this.node.ind(), this.maskLower, this.maskUpper);
                }
            } else {
                int logNPost;
                this.useHcIncrementer = this.node.isAHC() ? nPossibleMatch < maxHcAddr : (double)this.nMaxEntry > (double)nPossibleMatch * (double)(logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxEntry) + 1);
            }
        }

        private void checkAndAddResult(PhEntry<T> e) {
            NodeIteratorListReuse.this.results.phOffer(e);
        }

        private void checkAndRunSubnode(Node sub, PhEntry<T> e) {
            if (e != null) {
                NodeIteratorListReuse.this.results.phReturnTemp(e);
            }
            if (NodeIteratorListReuse.this.results.phIsPrefixValid(NodeIteratorListReuse.this.valTemplate, sub.getPostLen() + 1)) {
                NodeIteratorListReuse.this.run(sub);
            }
        }

        private void readValue(int pin, long pos) {
            PhEntry<Object> resultBuffer = NodeIteratorListReuse.this.results.phGetTempEntry();
            long[] key = resultBuffer.getKey();
            Object o = this.node.checkAndGetEntryPIN(pin, pos, NodeIteratorListReuse.this.valTemplate, key, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax);
            if (o == null) {
                NodeIteratorListReuse.this.results.phReturnTemp(resultBuffer);
                return;
            }
            if (o instanceof Node) {
                this.checkAndRunSubnode((Node)o, resultBuffer);
                return;
            }
            resultBuffer.setValue(o);
            this.checkAndAddResult(resultBuffer);
        }

        private void readValue(long pos, Object value, PhEntry<T> result) {
            if (!this.node.checkAndGetEntryNt(pos, value, result, NodeIteratorListReuse.this.valTemplate, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax)) {
                return;
            }
            this.checkAndAddResult(result);
        }

        private void getAllHCI() {
            long currentPos = this.maskLower;
            do {
                int pin;
                if ((pin = this.node.getPosition(currentPos, NodeIteratorListReuse.this.dims)) < 0) continue;
                this.readValue(pin, currentPos);
            } while ((currentPos = PhTree11.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower && NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults);
        }

        private void getAll() {
            if (this.node.isNT()) {
                this.niAllNext();
                return;
            }
            if (this.useHcIncrementer) {
                this.getAllHCI();
            } else if (this.node.isAHC()) {
                this.getAllAHC();
            } else {
                this.getAllLHC();
            }
        }

        private void getAllAHC() {
            long currentPos = this.maskLower;
            while (NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                if (this.checkHcPos(currentPos)) {
                    this.readValue((int)currentPos, currentPos);
                }
                if (++currentPos <= this.maskUpper) continue;
                break;
            }
        }

        private void getAllLHC() {
            int currentOffsetKey = this.node.getBitPosIndex();
            int postEntryLenLHC = Node.IK_WIDTH(NodeIteratorListReuse.this.dims) + NodeIteratorListReuse.this.dims * this.node.getPostLen();
            while (NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults && ++this.nEntryFound <= this.nMaxEntry) {
                long currentPos = Bits.readArray(this.node.ba, currentOffsetKey, Node.IK_WIDTH(NodeIteratorListReuse.this.dims));
                currentOffsetKey += postEntryLenLHC;
                if (!this.checkHcPos(currentPos)) {
                    if (currentPos <= this.maskUpper) continue;
                    break;
                }
                this.readValue(this.nEntryFound - 1, currentPos);
            }
        }

        private void niAllNext() {
            if (this.useHcIncrementer) {
                this.niAllNextHCI();
            } else {
                this.niAllNextIterator();
            }
        }

        private void niAllNextIterator() {
            while (this.niIterator.hasNext() && NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                MaxKTreeI.NtEntry<Object> e = this.niIterator.nextEntryReuse();
                Object v = e.value();
                if (v instanceof Node) {
                    Node nextSubNode = (Node)v;
                    PhTreeHelper.applyHcPos(e.key(), this.node.getPostLen(), NodeIteratorListReuse.this.valTemplate);
                    if (!this.node.checkAndApplyInfixNt(nextSubNode.getInfixLen(), e.getKdKey(), NodeIteratorListReuse.this.valTemplate, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax)) continue;
                    this.checkAndRunSubnode(nextSubNode, null);
                    continue;
                }
                PhEntry resultBuffer = NodeIteratorListReuse.this.results.phGetTempEntry();
                System.arraycopy(e.getKdKey(), 0, resultBuffer.getKey(), 0, NodeIteratorListReuse.this.dims);
                this.readValue(e.key(), v, resultBuffer);
            }
        }

        private void niAllNextHCI() {
            long currentPos = this.maskLower;
            while (NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                PhEntry resultBuffer = NodeIteratorListReuse.this.results.phGetTempEntry();
                Object v = this.node.ntGetEntry(currentPos, resultBuffer.getKey(), NodeIteratorListReuse.this.valTemplate);
                if (v instanceof Node) {
                    Node sub = (Node)v;
                    PhTreeHelper.applyHcPos(currentPos, this.node.getPostLen(), NodeIteratorListReuse.this.valTemplate);
                    if (this.node.checkAndApplyInfixNt(sub.getInfixLen(), resultBuffer.getKey(), NodeIteratorListReuse.this.valTemplate, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax)) {
                        this.checkAndRunSubnode(sub, resultBuffer);
                    }
                } else if (v != null) {
                    this.readValue(currentPos, v, resultBuffer);
                }
                if ((currentPos = PhTree11.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower) continue;
                break;
            }
        }

        private boolean checkHcPos(long pos) {
            return ((pos | this.maskLower) & this.maskUpper) == pos;
        }
    }

    private class PhIteratorStack {
        private final NodeIterator[] stack = Refs.newArray(NodeIterator.class, 64);
        private int size = 0;

        private PhIteratorStack() {
        }

        NodeIterator prepare() {
            NodeIterator ni;
            if ((ni = this.stack[this.size++]) == null) {
                this.stack[this.size - 1] = ni = new NodeIterator();
            }
            return ni;
        }

        NodeIterator pop() {
            return this.stack[--this.size];
        }
    }
}

