/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

public abstract class PhTreeHelper {
    public static final boolean DEBUG_FULL = false;
    public static final boolean DEBUG = false;
    public static final Object NULL = new Object();
    public static int MAX_OBJECT_POOL_SIZE = 100;
    public static int ALLOC_BATCH_SIZE;
    public static int ALLOC_BATCH_SIZE_LONG;
    public static int ALLOC_BATCH_REF;
    public static boolean ARRAY_POOLING;
    public static int ARRAY_POOLING_MAX_ARRAY_SIZE;
    public static int ARRAY_POOLING_POOL_SIZE;

    private PhTreeHelper() {
    }

    public static void setAllocBatchSize(int size) {
        if (size == 0) {
            ALLOC_BATCH_SIZE_LONG = 63;
            ALLOC_BATCH_SIZE = 1;
            ALLOC_BATCH_REF = 1;
        } else {
            ALLOC_BATCH_SIZE_LONG = 64 * size - 1;
            ALLOC_BATCH_SIZE = size;
            ALLOC_BATCH_REF = 2 * size - 1;
        }
    }

    public static void enablePooling(boolean flag) {
        ARRAY_POOLING = flag;
    }

    public static void debugCheck() {
    }

    public static int align8(int n) {
        return (int)(8.0 * Math.ceil((double)n / 8.0));
    }

    public static int getMaxConflictingBits(long[] v1, long[] v2, int bitsToCheck) {
        if (bitsToCheck == 0) {
            return 0;
        }
        long mask = bitsToCheck == 64 ? -1L : -1L << bitsToCheck ^ 0xFFFFFFFFFFFFFFFFL;
        return PhTreeHelper.getMaxConflictingBitsWithMask(v1, v2, mask);
    }

    public static int getMaxConflictingBitsWithMask(long[] v1, long[] v2, long mask) {
        long x = 0L;
        for (int i = 0; i < v1.length; ++i) {
            x |= v1[i] ^ v2[i];
        }
        return 64 - Long.numberOfLeadingZeros(x &= mask);
    }

    public static long posInArray(long[] valSet, int postLen) {
        long valMask = 1L << postLen;
        long pos = 0L;
        for (int i = 0; i < valSet.length; ++i) {
            pos <<= 1;
            pos |= (valMask & valSet[i]) >>> postLen;
        }
        return pos;
    }

    public static long[] transposeValue(long[] valSet, int DEPTH) {
        long[] tv = new long[DEPTH];
        long valMask = 1L << DEPTH - 1;
        int rightShift = DEPTH - 1;
        for (int j = 0; j < DEPTH; ++j) {
            long pos = 0L;
            for (int i = 0; i < valSet.length; ++i) {
                pos <<= 1;
                pos |= (valMask & valSet[i]) >>> rightShift;
            }
            tv[j] = pos;
            valMask >>>= 1;
            --rightShift;
        }
        return tv;
    }

    public static void applyHcPos(long pos, int currentPostLen, long[] val) {
        long mask = 1L << currentPostLen;
        pos = Long.rotateLeft(pos, currentPostLen);
        for (int d = val.length - 1; d >= 0; --d) {
            val[d] = val[d] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | mask & pos;
            pos = Long.rotateRight(pos, 1);
        }
    }

    public static <T> Object maskNull(T value) {
        return value == null ? NULL : value;
    }

    public static <T> T unmaskNull(Object value) {
        return (T)(value == NULL ? null : value);
    }

    static {
        PhTreeHelper.setAllocBatchSize(1);
        ARRAY_POOLING = true;
        ARRAY_POOLING_MAX_ARRAY_SIZE = 10000;
        ARRAY_POOLING_POOL_SIZE = 100;
    }
}

