/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.twak.utils.Mathz;

public class Line3d {
    public Point3d start;
    public Point3d end;

    public Line3d(Point3d s2, Point3d e) {
        this.start = s2;
        this.end = e;
    }

    public Line3d(double ax, double ay, double az, double bx, double by, double bz) {
        this(new Point3d(ax, ay, az), new Point3d(bx, by, bz));
    }

    public Line3d(Line3d l) {
        this.start = l.start;
        this.end = l.end;
    }

    public Vector3d dir() {
        Vector3d out = new Vector3d(this.end);
        out.sub(this.start);
        return out;
    }

    public Line3d move(Vector3d m3) {
        this.start = new Point3d(this.start);
        this.end = new Point3d(this.end);
        this.start.add(m3);
        this.end.add(m3);
        return this;
    }

    public Point3d[] points() {
        return new Point3d[]{this.start, this.end};
    }

    public Point3d fromPPram(double fParam) {
        Vector3d v2 = this.dir();
        v2.scale(fParam);
        v2.add(this.start);
        return new Point3d(v2);
    }

    public double findPPram(Point3d pt) {
        Vector3d v1 = this.dir();
        Vector3d v2 = new Vector3d(pt);
        v2.sub(this.start);
        return v1.dot(v2) / v1.dot(v1);
    }

    public Line3d reverse() {
        Point3d tmp = this.end;
        this.end = this.start;
        this.start = tmp;
        return this;
    }

    public double angle(Vector3d dir) {
        return dir.angle(this.dir());
    }

    public double lengthSquared() {
        return this.dir().lengthSquared();
    }

    public double length() {
        return this.dir().length();
    }

    public double distance(Point3d cen) {
        return this.closestPointOn(cen, true).distance(cen);
    }

    public double distanceSquared(Point3d cen) {
        return this.closestPointOn(cen, true).distanceSquared(cen);
    }

    public Point3d closestPointOn(Point3d p, boolean clamp) {
        Vector3d ap = new Vector3d(p);
        Vector3d ab = new Vector3d(this.end);
        ap.sub(this.start);
        ab.sub(this.start);
        Point3d out = new Point3d(ab);
        double fac = ap.dot(ab) / ab.dot(ab);
        if (clamp) {
            fac = Mathz.clamp(fac, 0.0, 1.0);
        }
        out.scale(fac);
        out.add(this.start);
        return out;
    }

    public static Line3d fromRay(Point3d pt, Vector3d dir) {
        Point3d end = new Point3d(pt);
        end.add(dir);
        return new Line3d(pt, end);
    }
}

