/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphframes.graphx.lib;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.graphframes.graphx.EdgeDirection;
import org.apache.spark.graphframes.graphx.EdgeDirection$;
import org.apache.spark.graphframes.graphx.EdgeRDD;
import org.apache.spark.graphframes.graphx.EdgeTriplet;
import org.apache.spark.graphframes.graphx.Graph;
import org.apache.spark.graphframes.graphx.Graph$;
import org.apache.spark.graphframes.graphx.Pregel$;
import org.apache.spark.graphframes.graphx.TripletFields;
import org.apache.spark.graphframes.graphx.VertexRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

public final class PageRank$
implements Logging {
    public static PageRank$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PageRank$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <VD, ED> Graph<Object, Object> run(Graph<VD, ED> graph, int numIter, double resetProb, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        return this.runWithOptions(graph, numIter, resetProb, (Option<Object>)None$.MODULE$, evidence$1, evidence$2);
    }

    public <VD, ED> double run$default$3() {
        return 0.15;
    }

    private Graph<Object, Object> runUpdate(Graph<Object, Object> rankGraph, boolean personalized, double resetProb, long src2) {
        VertexRDD rankUpdates = rankGraph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
            ctx.sendToDst(BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(ctx.srcAttr()) * BoxesRunTime.unboxToDouble(ctx.attr()))));
            return BoxedUnit.UNIT;
        }, (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2, TripletFields.Src, ClassTag$.MODULE$.Double());
        JFunction2.mcDJJ.sp & Serializable & scala.Serializable rPrb = personalized ? (JFunction2.mcDJJ.sp & Serializable & scala.Serializable)(src, id) -> resetProb * PageRank$.delta$1(src, id) : (JFunction2.mcDJJ.sp & Serializable & scala.Serializable)(x$3, x$4) -> resetProb;
        return rankGraph.outerJoinVertices(rankUpdates, (arg_0, arg_1, arg_2) -> PageRank$.$anonfun$runUpdate$5$adapted((Function2)rPrb, src2, resetProb, arg_0, arg_1, arg_2), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public <VD, ED> Graph<Object, Object> runWithOptions(Graph<VD, ED> graph, int numIter, double resetProb, Option<Object> srcId, ClassTag<VD> evidence$3, ClassTag<ED> evidence$4) {
        return this.runWithOptions(graph, numIter, resetProb, srcId, true, evidence$3, evidence$4);
    }

    public <VD, ED> Graph<Object, Object> runWithOptions(Graph<VD, ED> graph, int numIter, double resetProb, Option<Object> srcId, boolean normalized, ClassTag<VD> evidence$5, ClassTag<ED> evidence$6) {
        Predef$.MODULE$.require(numIter > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Number of iterations must be greater than 0,").append(" but got ").append(numIter).toString());
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Random reset probability must belong").append(" to [0, 1], but got ").append(resetProb).toString());
        boolean personalized = srcId.isDefined();
        long src = BoxesRunTime.unboxToLong((Object)srcId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        VertexRDD<Object> x$1 = Graph$.MODULE$.graphToGraphOps(graph, evidence$5, evidence$6).outDegrees();
        Function3 & Serializable & scala.Serializable x$2 = (Function3 & Serializable & scala.Serializable)(x$6, x$7, deg) -> BoxesRunTime.boxToInteger((int)PageRank$.$anonfun$runWithOptions$4(BoxesRunTime.unboxToLong((Object)x$6), x$7, deg));
        ClassTag x$3 = ClassTag$.MODULE$.Int();
        ClassTag x$4 = ClassTag$.MODULE$.Int();
        Null$ x$5 = graph.outerJoinVertices$default$5(x$1, x$2);
        Graph qual$1 = graph.outerJoinVertices(x$1, x$2, x$3, x$4, null).mapTriplets((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)PageRank$.$anonfun$runWithOptions$6(e)), TripletFields.Src, ClassTag$.MODULE$.Double());
        JFunction2.mcDJI.sp & Serializable & scala.Serializable x$62 = (JFunction2.mcDJI.sp & Serializable & scala.Serializable)(id, x$8) -> {
            if (id == src || !personalized) {
                return 1.0;
            }
            return 0.0;
        };
        ClassTag x$72 = ClassTag$.MODULE$.Double();
        Null$ x$82 = qual$1.mapVertices$default$3(x$62);
        Graph<Object, Object> rankGraph = qual$1.mapVertices(x$62, x$72, null);
        Graph<Object, Object> prevRankGraph = null;
        for (int iteration = 0; iteration < numIter; ++iteration) {
            rankGraph.cache();
            prevRankGraph = rankGraph;
            rankGraph = this.runUpdate(rankGraph, personalized, resetProb, src);
            rankGraph.cache();
            rankGraph.edges().foreachPartition((Function1 & Serializable & scala.Serializable)x$9 -> {
                PageRank$.$anonfun$runWithOptions$8(x$9);
                return BoxedUnit.UNIT;
            });
            VertexRDD<Object> qual$2 = prevRankGraph.vertices();
            boolean x$92 = qual$2.unpersist$default$1();
            qual$2.unpersist(x$92);
            EdgeRDD<Object> qual$3 = prevRankGraph.edges();
            boolean x$10 = qual$3.unpersist$default$1();
            qual$3.unpersist(x$10);
        }
        if (normalized) {
            return this.normalizeRankSum(rankGraph, personalized);
        }
        return rankGraph;
    }

    public <VD, ED> double runWithOptions$default$3() {
        return 0.15;
    }

    public <VD, ED> Option<Object> runWithOptions$default$4() {
        return None$.MODULE$;
    }

    public <VD, ED> Graph<Object, Object> runWithOptionsWithPreviousPageRank(Graph<VD, ED> graph, int numIter, double resetProb, Option<Object> srcId, Graph<Object, Object> preRankGraph, ClassTag<VD> evidence$7, ClassTag<ED> evidence$8) {
        return this.runWithOptionsWithPreviousPageRank(graph, numIter, resetProb, srcId, true, preRankGraph, evidence$7, evidence$8);
    }

    public <VD, ED> Graph<Object, Object> runWithOptionsWithPreviousPageRank(Graph<VD, ED> graph, int numIter, double resetProb, Option<Object> srcId, boolean normalized, Graph<Object, Object> preRankGraph, ClassTag<VD> evidence$9, ClassTag<ED> evidence$10) {
        Predef$.MODULE$.require(numIter > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Number of iterations must be greater than 0,").append(" but got ").append(numIter).toString());
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Random reset probability must belong").append(" to [0, 1], but got ").append(resetProb).toString());
        long graphVertices = Graph$.MODULE$.graphToGraphOps(graph, evidence$9, evidence$10).numVertices();
        long prePageRankVertices = Graph$.MODULE$.graphToGraphOps(preRankGraph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).numVertices();
        Predef$.MODULE$.require(graphVertices == prePageRankVertices, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Graph and previous pageRankGraph").append(" must have the same number of vertices but got ").append(graphVertices).append(" and ").append(prePageRankVertices).toString());
        boolean personalized = srcId.isDefined();
        long src = BoxesRunTime.unboxToLong((Object)srcId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        Graph<Object, Object> rankGraph = preRankGraph;
        Graph<Object, Object> prevRankGraph = null;
        for (int iteration = 0; iteration < numIter; ++iteration) {
            rankGraph.cache();
            prevRankGraph = rankGraph;
            rankGraph = this.runUpdate(rankGraph, personalized, resetProb, src);
            rankGraph.cache();
            rankGraph.edges().foreachPartition((Function1 & Serializable & scala.Serializable)x$10 -> {
                PageRank$.$anonfun$runWithOptionsWithPreviousPageRank$5(x$10);
                return BoxedUnit.UNIT;
            });
            VertexRDD<Object> qual$1 = prevRankGraph.vertices();
            boolean x$1 = qual$1.unpersist$default$1();
            qual$1.unpersist(x$1);
            EdgeRDD<Object> qual$2 = prevRankGraph.edges();
            boolean x$2 = qual$2.unpersist$default$1();
            qual$2.unpersist(x$2);
        }
        if (normalized) {
            return this.normalizeRankSum(rankGraph, personalized);
        }
        return rankGraph;
    }

    public <VD, ED> Graph<org.apache.spark.ml.linalg.Vector, Object> runParallelPersonalizedPageRank(Graph<VD, ED> graph, int numIter, double resetProb, long[] sources, ClassTag<VD> evidence$11, ClassTag<ED> evidence$12) {
        Predef$.MODULE$.require(numIter > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Number of iterations must be greater than 0,").append(" but got ").append(numIter).toString());
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Random reset probability must belong").append(" to [0, 1], but got ").append(resetProb).toString());
        Predef$.MODULE$.require(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sources)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("The list of sources must be non-empty,").append(" but got ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sources)).mkString("[", ",", "]")).toString());
        Vector zero = Vectors$.MODULE$.sparse(sources.length, (Seq)Nil$.MODULE$).asBreeze();
        Map sourcesInitMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sources)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long vid = tuple2._1$mcJ$sp();
                int i = tuple2._2$mcI$sp();
                Vector v = Vectors$.MODULE$.sparse(sources.length, new int[]{i}, new double[]{1.0}).asBreeze();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)vid), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        SparkContext sc = graph.vertices().sparkContext();
        Broadcast sourcesInitMapBC = sc.broadcast((Object)sourcesInitMap, ClassTag$.MODULE$.apply(Map.class));
        VertexRDD<Object> x$1 = Graph$.MODULE$.graphToGraphOps(graph, evidence$11, evidence$12).outDegrees();
        Function3 & Serializable & scala.Serializable x$2 = (Function3 & Serializable & scala.Serializable)(x$11, x$12, deg) -> BoxesRunTime.boxToInteger((int)PageRank$.$anonfun$runParallelPersonalizedPageRank$5(BoxesRunTime.unboxToLong((Object)x$11), x$12, deg));
        ClassTag x$3 = ClassTag$.MODULE$.Int();
        ClassTag x$4 = ClassTag$.MODULE$.Int();
        Null$ x$5 = graph.outerJoinVertices$default$5(x$1, x$2);
        Graph qual$1 = graph.outerJoinVertices(x$1, x$2, x$3, x$4, null).mapTriplets((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)PageRank$.$anonfun$runParallelPersonalizedPageRank$7(e)), TripletFields.Src, ClassTag$.MODULE$.Double());
        Function2 & Serializable & scala.Serializable x$6 = (Function2 & Serializable & scala.Serializable)(vid, x$13) -> PageRank$.$anonfun$runParallelPersonalizedPageRank$8(sourcesInitMapBC, zero, BoxesRunTime.unboxToLong((Object)vid), BoxesRunTime.unboxToInt((Object)x$13));
        ClassTag x$7 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$8 = qual$1.mapVertices$default$3(x$6);
        Graph rankGraph = qual$1.mapVertices(x$6, x$7, null);
        for (int i = 0; i < numIter; ++i) {
            Graph prevRankGraph = rankGraph;
            VertexRDD rankUpdates = rankGraph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                ctx.sendToDst(((ImmutableNumericOps)ctx.srcAttr()).$times$colon$times(ctx.attr(), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulScalar()));
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Vector)a.$plus$colon$plus(b, (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpAdd()), TripletFields.Src, ClassTag$.MODULE$.apply(Vector.class));
            rankGraph = rankGraph.outerJoinVertices(rankUpdates, (Function3 & Serializable & scala.Serializable)(vid, x$14, msgSumOpt) -> PageRank$.$anonfun$runParallelPersonalizedPageRank$12(zero, resetProb, sourcesInitMapBC, BoxesRunTime.unboxToLong((Object)vid), x$14, msgSumOpt), ClassTag$.MODULE$.apply(Vector.class), ClassTag$.MODULE$.apply(Vector.class), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
            rankGraph.edges().foreachPartition((Function1 & Serializable & scala.Serializable)x$15 -> {
                PageRank$.$anonfun$runParallelPersonalizedPageRank$14(x$15);
                return BoxedUnit.UNIT;
            });
            prevRankGraph.vertices().unpersist(prevRankGraph.vertices().unpersist$default$1());
            prevRankGraph.edges().unpersist(prevRankGraph.edges().unpersist$default$1());
        }
        Vector rankSums = (Vector)RDD$.MODULE$.rddToPairRDDFunctions(rankGraph.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Long$.MODULE$).values().fold((Object)zero, (Function2 & Serializable & scala.Serializable)(x$16, x$17) -> (Vector)x$16.$plus$colon$plus(x$17, (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpAdd()));
        Graph qual$2 = rankGraph;
        Function2 & Serializable & scala.Serializable x$9 = (Function2 & Serializable & scala.Serializable)(x$18, attr) -> Vectors$.MODULE$.fromBreeze((Vector)attr.$div$colon$div((Object)rankSums, (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_Double_OpDiv()));
        ClassTag x$10 = ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class);
        Null$ x$112 = qual$2.mapVertices$default$3(x$9);
        return qual$2.mapVertices(x$9, x$10, null);
    }

    public <VD, ED> double runParallelPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public <VD, ED> Graph<Object, Object> runUntilConvergence(Graph<VD, ED> graph, double tol, double resetProb, ClassTag<VD> evidence$13, ClassTag<ED> evidence$14) {
        return this.runUntilConvergenceWithOptions(graph, tol, resetProb, this.runUntilConvergenceWithOptions$default$4(), evidence$13, evidence$14);
    }

    public <VD, ED> double runUntilConvergence$default$3() {
        return 0.15;
    }

    public <VD, ED> Graph<Object, Object> runUntilConvergenceWithOptions(Graph<VD, ED> graph, double tol, double resetProb, Option<Object> srcId, ClassTag<VD> evidence$15, ClassTag<ED> evidence$16) {
        Predef$.MODULE$.require(tol >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Tolerance must be no less than 0, but got ").append(tol).toString());
        Predef$.MODULE$.require(resetProb >= 0.0 && resetProb <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Random reset probability must belong").append(" to [0, 1], but got ").append(resetProb).toString());
        boolean personalized = srcId.isDefined();
        long src = BoxesRunTime.unboxToLong((Object)srcId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        VertexRDD<Object> x$1 = Graph$.MODULE$.graphToGraphOps(graph, evidence$15, evidence$16).outDegrees();
        Function3 & Serializable & scala.Serializable x$2 = (Function3 & Serializable & scala.Serializable)(x$19, x$20, deg) -> BoxesRunTime.boxToInteger((int)PageRank$.$anonfun$runUntilConvergenceWithOptions$4(BoxesRunTime.unboxToLong((Object)x$19), x$20, deg));
        ClassTag x$3 = ClassTag$.MODULE$.Int();
        ClassTag x$4 = ClassTag$.MODULE$.Int();
        Null$ x$5 = graph.outerJoinVertices$default$5(x$1, x$2);
        Graph qual$1 = graph.outerJoinVertices(x$1, x$2, x$3, x$4, null).mapTriplets((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)PageRank$.$anonfun$runUntilConvergenceWithOptions$6(e)), ClassTag$.MODULE$.Double());
        Function2 & Serializable & scala.Serializable x$6 = (Function2 & Serializable & scala.Serializable)(id, x$21) -> PageRank$.$anonfun$runUntilConvergenceWithOptions$7(src, BoxesRunTime.unboxToLong((Object)id), BoxesRunTime.unboxToInt((Object)x$21));
        ClassTag x$7 = ClassTag$.MODULE$.apply(Tuple2.class);
        Null$ x$8 = qual$1.mapVertices$default$3(x$6);
        Graph pagerankGraph = qual$1.mapVertices(x$6, x$7, null).cache();
        double initialMessage = personalized ? 0.0 : resetProb / (1.0 - resetProb);
        Function3 & Serializable & scala.Serializable vp = personalized ? (Function3 & Serializable & scala.Serializable)(id, attr, msgSum) -> PageRank$.personalizedVertexProgram$1(BoxesRunTime.unboxToLong((Object)id), attr, BoxesRunTime.unboxToDouble((Object)msgSum), resetProb) : (Function3 & Serializable & scala.Serializable)(id, attr, msgSum) -> PageRank$.vertexProgram$1(BoxesRunTime.unboxToLong((Object)id), attr, BoxesRunTime.unboxToDouble((Object)msgSum), resetProb);
        Graph x$9 = pagerankGraph;
        double x$10 = initialMessage;
        EdgeDirection x$11 = EdgeDirection$.MODULE$.Out();
        int x$12 = Pregel$.MODULE$.apply$default$3();
        Function3 & Serializable & scala.Serializable x$13 = vp;
        Function1 & Serializable & scala.Serializable x$14 = (Function1 & Serializable & scala.Serializable)edge -> PageRank$.sendMessage$1(edge, tol);
        JFunction2.mcDDD.sp & Serializable & scala.Serializable x$15 = (JFunction2.mcDDD.sp & Serializable & scala.Serializable)(a, b) -> PageRank$.messageCombiner$1(a, b);
        Graph qual$2 = Pregel$.MODULE$.apply(x$9, BoxesRunTime.boxToDouble((double)x$10), x$12, x$11, x$13, x$14, x$15, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
        Function2 & Serializable & scala.Serializable x$16 = (Function2 & Serializable & scala.Serializable)(x$23, attr) -> BoxesRunTime.boxToDouble((double)attr._1$mcD$sp());
        ClassTag x$17 = ClassTag$.MODULE$.Double();
        Null$ x$18 = qual$2.mapVertices$default$3(x$16);
        Graph<Object, Object> rankGraph = qual$2.mapVertices(x$16, x$17, null);
        return this.normalizeRankSum(rankGraph, personalized);
    }

    public <VD, ED> double runUntilConvergenceWithOptions$default$3() {
        return 0.15;
    }

    public <VD, ED> Option<Object> runUntilConvergenceWithOptions$default$4() {
        return None$.MODULE$;
    }

    private Graph<Object, Object> normalizeRankSum(Graph<Object, Object> rankGraph, boolean personalized) {
        double rankSum = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(rankGraph.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Long$.MODULE$).values()).sum();
        if (personalized) {
            return rankGraph.mapVertices((JFunction2.mcDJD.sp & Serializable & scala.Serializable)(x$24, rank) -> rank / rankSum, ClassTag$.MODULE$.Double(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        }
        long numVertices = Graph$.MODULE$.graphToGraphOps(rankGraph, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).numVertices();
        double correctionFactor = (double)numVertices / rankSum;
        return rankGraph.mapVertices((JFunction2.mcDJD.sp & Serializable & scala.Serializable)(x$25, rank) -> rank * correctionFactor, ClassTag$.MODULE$.Double(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    private static final double delta$1(long u, long v) {
        if (u == v) {
            return 1.0;
        }
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$runUpdate$5(Function2 rPrb$1, long src$1, double resetProb$1, long id, double x$5, Option msgSumOpt) {
        return rPrb$1.apply$mcDJJ$sp(src$1, id) + (1.0 - resetProb$1) * BoxesRunTime.unboxToDouble((Object)msgSumOpt.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
    }

    public static final /* synthetic */ int $anonfun$runWithOptions$4(long x$6, Object x$7, Option deg) {
        return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ double $anonfun$runWithOptions$6(EdgeTriplet e) {
        return 1.0 / (double)BoxesRunTime.unboxToInt(e.srcAttr());
    }

    public static final /* synthetic */ void $anonfun$runWithOptions$8(Iterator x$9) {
    }

    public static final /* synthetic */ void $anonfun$runWithOptionsWithPreviousPageRank$5(Iterator x$10) {
    }

    public static final /* synthetic */ int $anonfun$runParallelPersonalizedPageRank$5(long x$11, Object x$12, Option deg) {
        return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ double $anonfun$runParallelPersonalizedPageRank$7(EdgeTriplet e) {
        return 1.0 / (double)BoxesRunTime.unboxToInt(e.srcAttr());
    }

    public static final /* synthetic */ Vector $anonfun$runParallelPersonalizedPageRank$8(Broadcast sourcesInitMapBC$1, Vector zero$1, long vid, int x$13) {
        return (Vector)((MapLike)sourcesInitMapBC$1.value()).getOrElse((Object)BoxesRunTime.boxToLong((long)vid), (Function0 & Serializable & scala.Serializable)() -> zero$1);
    }

    public static final /* synthetic */ Vector $anonfun$runParallelPersonalizedPageRank$12(Vector zero$1, double resetProb$4, Broadcast sourcesInitMapBC$1, long vid, Vector x$14, Option msgSumOpt) {
        Vector popActivations = (Vector)((ImmutableNumericOps)msgSumOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> zero$1)).$times$colon$times((Object)BoxesRunTime.boxToDouble((double)(1.0 - resetProb$4)), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulScalar());
        Vector resetActivations = ((MapLike)sourcesInitMapBC$1.value()).contains((Object)BoxesRunTime.boxToLong((long)vid)) ? (Vector)((ImmutableNumericOps)((MapLike)sourcesInitMapBC$1.value()).apply((Object)BoxesRunTime.boxToLong((long)vid))).$times$colon$times((Object)BoxesRunTime.boxToDouble((double)resetProb$4), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulScalar()) : zero$1;
        return (Vector)popActivations.$plus$colon$plus((Object)resetActivations, (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpAdd());
    }

    public static final /* synthetic */ void $anonfun$runParallelPersonalizedPageRank$14(Iterator x$15) {
    }

    public static final /* synthetic */ int $anonfun$runUntilConvergenceWithOptions$4(long x$19, Object x$20, Option deg) {
        return BoxesRunTime.unboxToInt((Object)deg.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ double $anonfun$runUntilConvergenceWithOptions$6(EdgeTriplet e) {
        return 1.0 / (double)BoxesRunTime.unboxToInt(e.srcAttr());
    }

    public static final /* synthetic */ Tuple2 $anonfun$runUntilConvergenceWithOptions$7(long src$3, long id, int x$21) {
        if (id == src$3) {
            return new Tuple2.mcDD.sp(0.0, Double.NEGATIVE_INFINITY);
        }
        return new Tuple2.mcDD.sp(0.0, 0.0);
    }

    private static final Tuple2 vertexProgram$1(long id, Tuple2 attr, double msgSum, double resetProb$5) {
        Tuple2 tuple2 = attr;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double oldPR = tuple2._1$mcD$sp();
        double oldPR2 = oldPR;
        double newPR = oldPR2 + (1.0 - resetProb$5) * msgSum;
        return new Tuple2.mcDD.sp(newPR, newPR - oldPR2);
    }

    private static final Tuple2 personalizedVertexProgram$1(long id, Tuple2 attr, double msgSum, double resetProb$5) {
        Tuple2 tuple2 = attr;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double oldPR = tuple2._1$mcD$sp();
        double lastDelta = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(oldPR, lastDelta);
        double oldPR2 = sp2._1$mcD$sp();
        double lastDelta2 = sp2._2$mcD$sp();
        double newPR = lastDelta2 == Double.NEGATIVE_INFINITY ? 1.0 : oldPR2 + (1.0 - resetProb$5) * msgSum;
        return new Tuple2.mcDD.sp(newPR, newPR - oldPR2);
    }

    private static final Iterator sendMessage$1(EdgeTriplet edge, double tol$1) {
        if (((Tuple2)edge.srcAttr())._2$mcD$sp() > tol$1) {
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJD.sp(edge.dstId(), ((Tuple2)edge.srcAttr())._2$mcD$sp() * edge.attr$mcD$sp())}));
        }
        return package$.MODULE$.Iterator().empty();
    }

    private static final double messageCombiner$1(double a, double b) {
        return a + b;
    }

    private PageRank$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$runUpdate$5$adapted(Function2 rPrb$1, long src$1, double resetProb$1, Object id, Object x$5, Option msgSumOpt) {
        return BoxesRunTime.boxToDouble((double)PageRank$.$anonfun$runUpdate$5(rPrb$1, src$1, resetProb$1, BoxesRunTime.unboxToLong((Object)id), BoxesRunTime.unboxToDouble((Object)x$5), msgSumOpt));
    }
}

