/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.nc2.ft.fmrc.EnsCoord;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ft.fmrc.TimeCoord;
import ucar.nc2.ft.fmrc.VertCoord;
import ucar.nc2.time.CalendarDate;

public class FmrInv
implements Comparable<FmrInv> {
    private final List<TimeCoord> timeCoords = new ArrayList<TimeCoord>();
    private final List<EnsCoord> ensCoords = new ArrayList<EnsCoord>();
    private final List<VertCoord> vertCoords = new ArrayList<VertCoord>();
    private final Map<String, GridVariable> uvHash = new HashMap<String, GridVariable>();
    private List<GridVariable> gridList;
    private final List<GridDatasetInv> invList = new ArrayList<GridDatasetInv>();
    private final CalendarDate runtime;

    public List<TimeCoord> getTimeCoords() {
        return this.timeCoords;
    }

    public List<EnsCoord> getEnsCoords() {
        return this.ensCoords;
    }

    public List<VertCoord> getVertCoords() {
        return this.vertCoords;
    }

    public List<GridVariable> getGrids() {
        return this.gridList;
    }

    public List<GridDatasetInv> getInventoryList() {
        return this.invList;
    }

    public CalendarDate getRunDate() {
        return this.runtime;
    }

    public String getName() {
        return "";
    }

    FmrInv(CalendarDate runtime) {
        this.runtime = runtime;
    }

    void addDataset(GridDatasetInv inv, Formatter debug) {
        this.invList.add(inv);
        if (debug != null) {
            debug.format(" Fmr add GridDatasetInv %s = ", inv.getLocation());
            for (TimeCoord tc : inv.getTimeCoords()) {
                debug.format("  %s %n", tc);
            }
        }
        for (TimeCoord tc : inv.getTimeCoords()) {
            for (GridDatasetInv.Grid grid : tc.getGridInventory()) {
                GridVariable uv = this.uvHash.get(grid.getName());
                if (uv == null) {
                    uv = new GridVariable(grid.getName());
                    this.uvHash.put(grid.getName(), uv);
                }
                uv.addGridDatasetInv(grid);
            }
        }
    }

    void finish() {
        this.gridList = new ArrayList<GridVariable>(this.uvHash.values());
        Collections.sort(this.gridList);
        for (GridVariable gridVariable : this.gridList) {
            gridVariable.finish();
        }
        int seqno = 0;
        for (TimeCoord tc : this.timeCoords) {
            tc.setId(seqno++);
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (VertCoord vc : this.vertCoords) {
            List list = hashMap.computeIfAbsent(vc.getName(), k -> new ArrayList());
            list.add(vc);
        }
        for (List list : hashMap.values()) {
            if (list.isEmpty()) continue;
            int count = 0;
            for (VertCoord vc : list) {
                if (count > 0) {
                    vc.setName(vc.getName() + count);
                }
                ++count;
            }
        }
    }

    @Override
    public int compareTo(FmrInv fmr) {
        return this.runtime.compareTo(fmr.getRunDate());
    }

    public Set<GridDatasetInv> getFiles() {
        HashSet<GridDatasetInv> fileSet = new HashSet<GridDatasetInv>();
        for (GridVariable grid : this.getGrids()) {
            for (GridDatasetInv.Grid inv : grid.getInventory()) {
                fileSet.add(inv.getFile());
            }
        }
        return fileSet;
    }

    public class GridVariable
    implements Comparable<GridVariable> {
        private final String name;
        private final List<GridDatasetInv.Grid> gridList = new ArrayList<GridDatasetInv.Grid>();
        VertCoord vertCoordUnion;
        EnsCoord ensCoordUnion;
        TimeCoord timeCoordUnion;
        TimeCoord timeExpected;

        GridVariable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public CalendarDate getRunDate() {
            return FmrInv.this.getRunDate();
        }

        void addGridDatasetInv(GridDatasetInv.Grid grid) {
            this.gridList.add(grid);
        }

        public List<GridDatasetInv.Grid> getInventory() {
            return this.gridList;
        }

        public TimeCoord getTimeExpected() {
            return this.timeExpected;
        }

        public TimeCoord getTimeCoord() {
            return this.timeCoordUnion;
        }

        @Override
        public int compareTo(GridVariable o) {
            return this.name.compareTo(o.name);
        }

        public int getNVerts() {
            return this.vertCoordUnion == null ? 1 : this.vertCoordUnion.getSize();
        }

        public int countTotal() {
            int total = 0;
            for (GridDatasetInv.Grid grid : this.gridList) {
                total += grid.countTotal();
            }
            return total;
        }

        void finish() {
            if (this.gridList.size() == 1) {
                GridDatasetInv.Grid grid = this.gridList.get(0);
                this.ensCoordUnion = EnsCoord.findEnsCoord(FmrInv.this.getEnsCoords(), grid.ec);
                this.vertCoordUnion = VertCoord.findVertCoord(FmrInv.this.getVertCoords(), grid.vc);
                this.timeCoordUnion = TimeCoord.findTimeCoord(FmrInv.this.getTimeCoords(), grid.tc);
                return;
            }
            ArrayList<EnsCoord> ensList = new ArrayList<EnsCoord>();
            EnsCoord ec_union = null;
            for (GridDatasetInv.Grid grid : this.gridList) {
                EnsCoord ec = grid.ec;
                if (ec == null) continue;
                if (ec_union == null) {
                    ec_union = new EnsCoord(ec);
                    continue;
                }
                if (ec_union.equalsData(ec)) continue;
                ensList.add(ec);
            }
            if (ec_union != null) {
                if (!ensList.isEmpty()) {
                    EnsCoord.normalize(ec_union, ensList);
                }
                this.ensCoordUnion = EnsCoord.findEnsCoord(FmrInv.this.getEnsCoords(), ec_union);
            }
            ArrayList<VertCoord> vertList = new ArrayList<VertCoord>();
            VertCoord vc_union = null;
            for (GridDatasetInv.Grid grid : this.gridList) {
                VertCoord vc = grid.vc;
                if (vc == null) continue;
                if (vc_union == null) {
                    vc_union = new VertCoord(vc);
                    continue;
                }
                if (vc_union.equalsData(vc)) continue;
                vertList.add(vc);
            }
            if (vc_union != null) {
                VertCoord.normalize(vc_union, vertList);
                this.vertCoordUnion = VertCoord.findVertCoord(FmrInv.this.getVertCoords(), vc_union);
            }
            ArrayList<TimeCoord> timeList = new ArrayList<TimeCoord>();
            for (GridDatasetInv.Grid grid : this.gridList) {
                TimeCoord tc = grid.tc;
                timeList.add(tc);
            }
            TimeCoord timeCoord = TimeCoord.makeUnion(timeList, this.getRunDate());
            this.timeCoordUnion = TimeCoord.findTimeCoord(FmrInv.this.getTimeCoords(), timeCoord);
        }
    }
}

