/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.simplify.ComponentJumpChecker;
import org.locationtech.jts.simplify.LineSegmentIndex;
import org.locationtech.jts.simplify.TaggedLineString;
import org.locationtech.jts.simplify.TaggedLineStringSimplifier;

class TaggedLinesSimplifier {
    private LineSegmentIndex inputIndex = new LineSegmentIndex();
    private LineSegmentIndex outputIndex = new LineSegmentIndex();
    private double distanceTolerance = 0.0;

    public void setDistanceTolerance(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public void simplify(Collection taggedLines) {
        ComponentJumpChecker jumpChecker = new ComponentJumpChecker(taggedLines);
        Iterator i = taggedLines.iterator();
        while (i.hasNext()) {
            this.inputIndex.add((TaggedLineString)i.next());
        }
        i = taggedLines.iterator();
        while (i.hasNext()) {
            TaggedLineStringSimplifier tlss = new TaggedLineStringSimplifier(this.inputIndex, this.outputIndex, jumpChecker);
            tlss.simplify((TaggedLineString)i.next(), this.distanceTolerance);
        }
    }
}

