/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;

public class Envelope
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5873921885273102420L;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Coordinate.hashCode(this.minx);
        result2 = 37 * result2 + Coordinate.hashCode(this.maxx);
        result2 = 37 * result2 + Coordinate.hashCode(this.miny);
        result2 = 37 * result2 + Coordinate.hashCode(this.maxy);
        return result2;
    }

    public static boolean intersects(Coordinate p1, Coordinate p2, Coordinate q) {
        double d = q.x;
        double d2 = p1.x < p2.x ? p1.x : p2.x;
        if (d >= d2) {
            double d3 = q.x;
            double d4 = p1.x > p2.x ? p1.x : p2.x;
            if (d3 <= d4) {
                double d5 = q.y;
                double d6 = p1.y < p2.y ? p1.y : p2.y;
                if (d5 >= d6) {
                    double d7 = q.y;
                    double d8 = p1.y > p2.y ? p1.y : p2.y;
                    if (d7 <= d8) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean intersects(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        double minq = Math.min(q1.x, q2.x);
        double maxq = Math.max(q1.x, q2.x);
        double minp = Math.min(p1.x, p2.x);
        double maxp = Math.max(p1.x, p2.x);
        if (minp > maxq) {
            return false;
        }
        if (maxp < minq) {
            return false;
        }
        minq = Math.min(q1.y, q2.y);
        maxq = Math.max(q1.y, q2.y);
        minp = Math.min(p1.y, p2.y);
        maxp = Math.max(p1.y, p2.y);
        if (minp > maxq) {
            return false;
        }
        return !(maxp < minq);
    }

    public Envelope() {
        this.init();
    }

    public Envelope(double x1, double x2, double y1, double y2) {
        this.init(x1, x2, y1, y2);
    }

    public Envelope(Coordinate p1, Coordinate p2) {
        this.init(p1.x, p2.x, p1.y, p2.y);
    }

    public Envelope(Coordinate p) {
        this.init(p.x, p.x, p.y, p.y);
    }

    public Envelope(Envelope env) {
        this.init(env);
    }

    public void init() {
        this.setToNull();
    }

    public void init(double x1, double x2, double y1, double y2) {
        if (x1 < x2) {
            this.minx = x1;
            this.maxx = x2;
        } else {
            this.minx = x2;
            this.maxx = x1;
        }
        if (y1 < y2) {
            this.miny = y1;
            this.maxy = y2;
        } else {
            this.miny = y2;
            this.maxy = y1;
        }
    }

    public Envelope copy() {
        return new Envelope(this);
    }

    public void init(Coordinate p1, Coordinate p2) {
        this.init(p1.x, p2.x, p1.y, p2.y);
    }

    public void init(Coordinate p) {
        this.init(p.x, p.x, p.y, p.y);
    }

    public void init(Envelope env) {
        this.minx = env.minx;
        this.maxx = env.maxx;
        this.miny = env.miny;
        this.maxy = env.maxy;
    }

    public void setToNull() {
        this.minx = 0.0;
        this.maxx = -1.0;
        this.miny = 0.0;
        this.maxy = -1.0;
    }

    public boolean isNull() {
        return this.maxx < this.minx;
    }

    public double getWidth() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxx - this.minx;
    }

    public double getHeight() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxy - this.miny;
    }

    public double getDiameter() {
        if (this.isNull()) {
            return 0.0;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        return Math.sqrt(w * w + h * h);
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public double minExtent() {
        double h;
        if (this.isNull()) {
            return 0.0;
        }
        double w = this.getWidth();
        if (w < (h = this.getHeight())) {
            return w;
        }
        return h;
    }

    public double maxExtent() {
        double h;
        if (this.isNull()) {
            return 0.0;
        }
        double w = this.getWidth();
        if (w > (h = this.getHeight())) {
            return w;
        }
        return h;
    }

    public void expandToInclude(Coordinate p) {
        this.expandToInclude(p.x, p.y);
    }

    public void expandBy(double distance) {
        this.expandBy(distance, distance);
    }

    public void expandBy(double deltaX, double deltaY) {
        if (this.isNull()) {
            return;
        }
        this.minx -= deltaX;
        this.maxx += deltaX;
        this.miny -= deltaY;
        this.maxy += deltaY;
        if (this.minx > this.maxx || this.miny > this.maxy) {
            this.setToNull();
        }
    }

    public void expandToInclude(double x, double y) {
        if (this.isNull()) {
            this.minx = x;
            this.maxx = x;
            this.miny = y;
            this.maxy = y;
        } else {
            if (x < this.minx) {
                this.minx = x;
            }
            if (x > this.maxx) {
                this.maxx = x;
            }
            if (y < this.miny) {
                this.miny = y;
            }
            if (y > this.maxy) {
                this.maxy = y;
            }
        }
    }

    public void expandToInclude(Envelope other) {
        if (other.isNull()) {
            return;
        }
        if (this.isNull()) {
            this.minx = other.getMinX();
            this.maxx = other.getMaxX();
            this.miny = other.getMinY();
            this.maxy = other.getMaxY();
        } else {
            if (other.minx < this.minx) {
                this.minx = other.minx;
            }
            if (other.maxx > this.maxx) {
                this.maxx = other.maxx;
            }
            if (other.miny < this.miny) {
                this.miny = other.miny;
            }
            if (other.maxy > this.maxy) {
                this.maxy = other.maxy;
            }
        }
    }

    public void translate(double transX, double transY) {
        if (this.isNull()) {
            return;
        }
        this.init(this.getMinX() + transX, this.getMaxX() + transX, this.getMinY() + transY, this.getMaxY() + transY);
    }

    public Coordinate centre() {
        if (this.isNull()) {
            return null;
        }
        return new Coordinate((this.getMinX() + this.getMaxX()) / 2.0, (this.getMinY() + this.getMaxY()) / 2.0);
    }

    public Envelope intersection(Envelope env) {
        if (this.isNull() || env.isNull() || !this.intersects(env)) {
            return new Envelope();
        }
        double intMinX = this.minx > env.minx ? this.minx : env.minx;
        double intMinY = this.miny > env.miny ? this.miny : env.miny;
        double intMaxX = this.maxx < env.maxx ? this.maxx : env.maxx;
        double intMaxY = this.maxy < env.maxy ? this.maxy : env.maxy;
        return new Envelope(intMinX, intMaxX, intMinY, intMaxY);
    }

    public boolean intersects(Envelope other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        return !(other.minx > this.maxx || other.maxx < this.minx || other.miny > this.maxy || other.maxy < this.miny);
    }

    public boolean intersects(Coordinate a, Coordinate b) {
        double envmaxy;
        double envminy;
        double envmaxx;
        double envminx;
        if (this.isNull()) {
            return false;
        }
        double d = envminx = a.x < b.x ? a.x : b.x;
        if (envminx > this.maxx) {
            return false;
        }
        double d2 = envmaxx = a.x > b.x ? a.x : b.x;
        if (envmaxx < this.minx) {
            return false;
        }
        double d3 = envminy = a.y < b.y ? a.y : b.y;
        if (envminy > this.maxy) {
            return false;
        }
        double d4 = envmaxy = a.y > b.y ? a.y : b.y;
        return !(envmaxy < this.miny);
    }

    public boolean disjoint(Envelope other) {
        if (this.isNull() || other.isNull()) {
            return true;
        }
        return other.minx > this.maxx || other.maxx < this.minx || other.miny > this.maxy || other.maxy < this.miny;
    }

    public boolean overlaps(Envelope other) {
        return this.intersects(other);
    }

    public boolean intersects(Coordinate p) {
        return this.intersects(p.x, p.y);
    }

    public boolean overlaps(Coordinate p) {
        return this.intersects(p);
    }

    public boolean intersects(double x, double y) {
        if (this.isNull()) {
            return false;
        }
        return !(x > this.maxx || x < this.minx || y > this.maxy || y < this.miny);
    }

    public boolean overlaps(double x, double y) {
        return this.intersects(x, y);
    }

    public boolean contains(Envelope other) {
        return this.covers(other);
    }

    public boolean contains(Coordinate p) {
        return this.covers(p);
    }

    public boolean contains(double x, double y) {
        return this.covers(x, y);
    }

    public boolean covers(double x, double y) {
        if (this.isNull()) {
            return false;
        }
        return x >= this.minx && x <= this.maxx && y >= this.miny && y <= this.maxy;
    }

    public boolean covers(Coordinate p) {
        return this.covers(p.x, p.y);
    }

    public boolean covers(Envelope other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        return other.getMinX() >= this.minx && other.getMaxX() <= this.maxx && other.getMinY() >= this.miny && other.getMaxY() <= this.maxy;
    }

    public double distance(Envelope env) {
        if (this.intersects(env)) {
            return 0.0;
        }
        double dx = 0.0;
        if (this.maxx < env.minx) {
            dx = env.minx - this.maxx;
        } else if (this.minx > env.maxx) {
            dx = this.minx - env.maxx;
        }
        double dy = 0.0;
        if (this.maxy < env.miny) {
            dy = env.miny - this.maxy;
        } else if (this.miny > env.maxy) {
            dy = this.miny - env.maxy;
        }
        if (dx == 0.0) {
            return dy;
        }
        if (dy == 0.0) {
            return dx;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Envelope)) {
            return false;
        }
        Envelope otherEnvelope = (Envelope)other;
        if (this.isNull()) {
            return otherEnvelope.isNull();
        }
        return this.maxx == otherEnvelope.getMaxX() && this.maxy == otherEnvelope.getMaxY() && this.minx == otherEnvelope.getMinX() && this.miny == otherEnvelope.getMinY();
    }

    public String toString() {
        return "Env[" + this.minx + " : " + this.maxx + ", " + this.miny + " : " + this.maxy + "]";
    }

    public int compareTo(Object o) {
        Envelope env = (Envelope)o;
        if (this.isNull()) {
            if (env.isNull()) {
                return 0;
            }
            return -1;
        }
        if (env.isNull()) {
            return 1;
        }
        if (this.minx < env.minx) {
            return -1;
        }
        if (this.minx > env.minx) {
            return 1;
        }
        if (this.miny < env.miny) {
            return -1;
        }
        if (this.miny > env.miny) {
            return 1;
        }
        if (this.maxx < env.maxx) {
            return -1;
        }
        if (this.maxx > env.maxx) {
            return 1;
        }
        if (this.maxy < env.maxy) {
            return -1;
        }
        if (this.maxy > env.maxy) {
            return 1;
        }
        return 0;
    }
}

