/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketNetworkModule;
import org.eclipse.paho.client.mqttv3.spi.NetworkModuleFactory;

public class WebSocketNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ws")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectOptions options, String clientId) throws MqttException {
        SocketFactory factory;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 80;
        }
        if ((factory = options.getSocketFactory()) == null) {
            factory = SocketFactory.getDefault();
        } else if (factory instanceof SSLSocketFactory) {
            throw ExceptionHelper.createMqttException(32105);
        }
        WebSocketNetworkModule netModule = new WebSocketNetworkModule(factory, brokerUri.toString(), host, port, clientId, options.getCustomWebSocketHeaders());
        netModule.setConnectTimeout(options.getConnectionTimeout());
        return netModule;
    }
}

