/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.rocks.support;

import com.alipay.sofa.jraft.rhea.util.concurrent.NamedThreadFactory;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.rocksdb.HistogramData;
import org.rocksdb.HistogramType;
import org.rocksdb.Statistics;
import org.rocksdb.StatisticsCollectorCallback;
import org.rocksdb.StatsCollectorInput;
import org.rocksdb.TickerType;

public class RocksStatisticsCollector {
    private final CopyOnWriteArrayList<StatsCollectorInput> statsCollectorInputList = new CopyOnWriteArrayList();
    private final long statsCollectionIntervalInMillis;
    private final ExecutorService executorService;
    private volatile boolean isRunning = true;

    public RocksStatisticsCollector(long statsCollectionIntervalInMillis) {
        this.statsCollectionIntervalInMillis = statsCollectionIntervalInMillis;
        this.executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("rocks-statistics-collector", true));
    }

    public void start() {
        this.executorService.submit(this.collectStatistics());
    }

    public void addStatsCollectorInput(StatsCollectorInput input) {
        this.statsCollectorInputList.add(input);
    }

    public void shutdown(int shutdownTimeout) throws InterruptedException {
        this.isRunning = false;
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
    }

    private Runnable collectStatistics() {
        return () -> {
            while (this.isRunning) {
                try {
                    if (Thread.currentThread().isInterrupted()) break;
                    for (StatsCollectorInput statsCollectorInput : this.statsCollectorInputList) {
                        Statistics statistics = statsCollectorInput.getStatistics();
                        StatisticsCollectorCallback statsCallback = statsCollectorInput.getCallback();
                        for (TickerType tickerType : TickerType.values()) {
                            if (tickerType == TickerType.TICKER_ENUM_MAX) continue;
                            long tickerValue = statistics.getTickerCount(tickerType);
                            statsCallback.tickerCallback(tickerType, tickerValue);
                        }
                        for (TickerType tickerType : HistogramType.values()) {
                            if (tickerType == HistogramType.HISTOGRAM_ENUM_MAX) continue;
                            HistogramData histogramData = statistics.getHistogramData((HistogramType)tickerType);
                            statsCallback.histogramCallback((HistogramType)tickerType, histogramData);
                        }
                    }
                    Thread.sleep(this.statsCollectionIntervalInMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while calculating statistics", e);
                }
            }
        };
    }
}

