/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.rhea.KVCommandProcessor;
import com.alipay.sofa.jraft.rhea.StoreEngine;
import com.alipay.sofa.jraft.rhea.cmd.store.BatchDeleteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.BatchPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.CASAllRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.CompareAndPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ContainsKeyRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.DeleteRangeRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.DeleteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetAndPutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.GetSequenceRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.KeyLockRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.KeyUnlockRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.MergeRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.MultiGetRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.NodeExecuteRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.PutIfAbsentRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.PutRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.RangeSplitRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ResetSequenceRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.ScanRequest;
import com.alipay.sofa.jraft.rhea.util.concurrent.CallerRunsPolicyWithReport;
import com.alipay.sofa.jraft.rhea.util.concurrent.NamedThreadFactory;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public final class StoreEngineHelper {
    public static ExecutorService createReadIndexExecutor(int coreThreads) {
        int maxThreads = coreThreads << 2;
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        return StoreEngineHelper.newPool(coreThreads, maxThreads, "rheakv-read-index-callback", handler);
    }

    public static ExecutorService createRaftStateTrigger(int coreThreads) {
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(32);
        return StoreEngineHelper.newPool(coreThreads, coreThreads, "rheakv-raft-state-trigger", workQueue);
    }

    public static ExecutorService createSnapshotExecutor(int coreThreads, int maxThreads) {
        return StoreEngineHelper.newPool(coreThreads, maxThreads, "rheakv-snapshot-executor");
    }

    public static ExecutorService createCliRpcExecutor(int coreThreads) {
        int maxThreads = coreThreads << 2;
        return StoreEngineHelper.newPool(coreThreads, maxThreads, "rheakv-cli-rpc-executor");
    }

    public static ExecutorService createRaftRpcExecutor(int coreThreads) {
        int maxThreads = coreThreads << 1;
        return StoreEngineHelper.newPool(coreThreads, maxThreads, "rheakv-raft-rpc-executor");
    }

    public static ExecutorService createKvRpcExecutor(int coreThreads) {
        int maxThreads = coreThreads << 2;
        return StoreEngineHelper.newPool(coreThreads, maxThreads, "rheakv-kv-store-rpc-executor");
    }

    public static ScheduledExecutorService createMetricsScheduler() {
        return Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("rheakv-metrics-reporter", true));
    }

    public static void addKvStoreRequestProcessor(RpcServer rpcServer, StoreEngine engine) {
        rpcServer.registerProcessor(new KVCommandProcessor<GetRequest>(GetRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<MultiGetRequest>(MultiGetRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<ContainsKeyRequest>(ContainsKeyRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<GetSequenceRequest>(GetSequenceRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<ResetSequenceRequest>(ResetSequenceRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<ScanRequest>(ScanRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<PutRequest>(PutRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<GetAndPutRequest>(GetAndPutRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<CompareAndPutRequest>(CompareAndPutRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<MergeRequest>(MergeRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<PutIfAbsentRequest>(PutIfAbsentRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<KeyLockRequest>(KeyLockRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<KeyUnlockRequest>(KeyUnlockRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<BatchPutRequest>(BatchPutRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<DeleteRequest>(DeleteRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<DeleteRangeRequest>(DeleteRangeRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<BatchDeleteRequest>(BatchDeleteRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<NodeExecuteRequest>(NodeExecuteRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<RangeSplitRequest>(RangeSplitRequest.class, engine));
        rpcServer.registerProcessor(new KVCommandProcessor<CASAllRequest>(CASAllRequest.class, engine));
    }

    private static ExecutorService newPool(int coreThreads, int maxThreads, String name) {
        CallerRunsPolicyWithReport defaultHandler = new CallerRunsPolicyWithReport(name, name);
        return StoreEngineHelper.newPool(coreThreads, maxThreads, name, defaultHandler);
    }

    private static ExecutorService newPool(int coreThreads, int maxThreads, String name, BlockingQueue<Runnable> workQueue) {
        CallerRunsPolicyWithReport defaultHandler = new CallerRunsPolicyWithReport(name, name);
        return StoreEngineHelper.newPool(coreThreads, maxThreads, workQueue, name, defaultHandler);
    }

    private static ExecutorService newPool(int coreThreads, int maxThreads, String name, RejectedExecutionHandler handler) {
        SynchronousQueue<Runnable> defaultWorkQueue = new SynchronousQueue<Runnable>();
        return StoreEngineHelper.newPool(coreThreads, maxThreads, defaultWorkQueue, name, handler);
    }

    private static ExecutorService newPool(int coreThreads, int maxThreads, BlockingQueue<Runnable> workQueue, String name, RejectedExecutionHandler handler) {
        return ThreadPoolUtil.newBuilder().poolName(name).enableMetric(Boolean.valueOf(true)).coreThreads(Integer.valueOf(coreThreads)).maximumThreads(Integer.valueOf(maxThreads)).keepAliveSeconds(Long.valueOf(60L)).workQueue(workQueue).threadFactory((ThreadFactory)new NamedThreadFactory(name, true)).rejectedHandler(handler).build();
    }

    private StoreEngineHelper() {
    }
}

