/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.topic;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class UpdateTopicListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateTopicList";
    }

    @Override
    public String commandDesc() {
        return "create or update topic in batch";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = new Option("b", "brokerAddr", true, "create topic to which broker");
        optionGroup.addOption(opt);
        opt = new Option("c", "clusterName", true, "create topic to which cluster");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        opt = new Option("f", "filename", true, "Path to a file with list of org.apache.rocketmq.common.TopicConfig in json format");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        String fileName = commandLine.getOptionValue('f').trim();
        try {
            Path filePath = Paths.get(fileName, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                System.out.printf("the file path %s does not exists%n", fileName);
                return;
            }
            byte[] topicConfigListBytes = Files.readAllBytes(filePath);
            List topicConfigs = JSON.parseArray((byte[])topicConfigListBytes, TopicConfig.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            if (null == topicConfigs || topicConfigs.isEmpty()) {
                return;
            }
            if (commandLine.hasOption('b')) {
                String brokerAddress = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                defaultMQAdminExt.createAndUpdateTopicConfigList(brokerAddress, topicConfigs);
                System.out.printf("submit batch of topic config to %s success, please check the result later.%n", brokerAddress);
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                for (String brokerAddress : masterSet) {
                    defaultMQAdminExt.createAndUpdateTopicConfigList(brokerAddress, topicConfigs);
                    System.out.printf("submit batch of topic config to %s success, please check the result later.%n", brokerAddress);
                }
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

