/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.file;

import com.alibaba.fastjson.JSON;
import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.AppendResult;
import org.apache.rocketmq.tieredstore.file.FlatCommitLogFile;
import org.apache.rocketmq.tieredstore.file.FlatConsumeQueueFile;
import org.apache.rocketmq.tieredstore.file.FlatFileFactory;
import org.apache.rocketmq.tieredstore.file.FlatFileInterface;
import org.apache.rocketmq.tieredstore.metadata.MetadataStore;
import org.apache.rocketmq.tieredstore.metadata.entity.QueueMetadata;
import org.apache.rocketmq.tieredstore.metadata.entity.TopicMetadata;
import org.apache.rocketmq.tieredstore.provider.FileSegment;
import org.apache.rocketmq.tieredstore.util.MessageFormatUtil;
import org.apache.rocketmq.tieredstore.util.MessageStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatMessageFile
implements FlatFileInterface {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected volatile boolean closed = false;
    protected TopicMetadata topicMetadata;
    protected QueueMetadata queueMetadata;
    protected final String filePath;
    protected final ReentrantLock fileLock;
    protected final Semaphore commitLock = new Semaphore(1);
    protected final MessageStoreConfig storeConfig;
    protected final MetadataStore metadataStore;
    protected final FlatCommitLogFile commitLog;
    protected final FlatConsumeQueueFile consumeQueue;
    protected final ConcurrentMap<String, CompletableFuture<?>> inFlightRequestMap;

    public FlatMessageFile(FlatFileFactory fileFactory, String topic, int queueId) {
        this(fileFactory, MessageStoreUtil.toFilePath(new MessageQueue(topic, fileFactory.getStoreConfig().getBrokerName(), queueId)));
        this.topicMetadata = this.recoverTopicMetadata(topic);
        this.queueMetadata = this.recoverQueueMetadata(topic, queueId);
    }

    public FlatMessageFile(FlatFileFactory fileFactory, String filePath) {
        this.filePath = filePath;
        this.fileLock = new ReentrantLock(false);
        this.storeConfig = fileFactory.getStoreConfig();
        this.metadataStore = fileFactory.getMetadataStore();
        this.commitLog = fileFactory.createFlatFileForCommitLog(filePath);
        this.consumeQueue = fileFactory.createFlatFileForConsumeQueue(filePath);
        this.inFlightRequestMap = new ConcurrentHashMap();
    }

    @Override
    public long getTopicId() {
        return this.topicMetadata.getTopicId();
    }

    @Override
    public MessageQueue getMessageQueue() {
        return this.queueMetadata != null ? this.queueMetadata.getQueue() : null;
    }

    @Override
    public boolean isFlatFileInit() {
        return !this.consumeQueue.fileSegmentTable.isEmpty();
    }

    public TopicMetadata recoverTopicMetadata(String topic) {
        TopicMetadata topicMetadata = this.metadataStore.getTopic(topic);
        if (topicMetadata == null) {
            topicMetadata = this.metadataStore.addTopic(topic, -1L);
        }
        return topicMetadata;
    }

    public QueueMetadata recoverQueueMetadata(String topic, int queueId) {
        MessageQueue mq = new MessageQueue(topic, this.storeConfig.getBrokerName(), queueId);
        QueueMetadata queueMetadata = this.metadataStore.getQueue(mq);
        if (queueMetadata == null) {
            queueMetadata = this.metadataStore.addQueue(mq, -1L);
        }
        return queueMetadata;
    }

    public void flushMetadata() {
        if (this.queueMetadata != null) {
            this.queueMetadata.setMinOffset(this.getConsumeQueueMinOffset());
            this.queueMetadata.setMaxOffset(this.getConsumeQueueCommitOffset());
            this.queueMetadata.setUpdateTimestamp(System.currentTimeMillis());
            this.metadataStore.updateQueue(this.queueMetadata);
        }
    }

    @Override
    public Lock getFileLock() {
        return this.fileLock;
    }

    @VisibleForTesting
    public Semaphore getCommitLock() {
        return this.commitLock;
    }

    @Override
    public boolean rollingFile(long interval) {
        return this.commitLog.tryRollingFile(interval);
    }

    @Override
    public void initOffset(long offset) {
        this.fileLock.lock();
        try {
            this.commitLog.initOffset(0L);
            this.consumeQueue.initOffset(offset * 20L);
        }
        finally {
            this.fileLock.unlock();
        }
    }

    @Override
    public AppendResult appendCommitLog(ByteBuffer message) {
        if (this.closed) {
            return AppendResult.FILE_CLOSED;
        }
        return this.commitLog.append(message, MessageFormatUtil.getStoreTimeStamp(message));
    }

    @Override
    public AppendResult appendCommitLog(SelectMappedBufferResult message) {
        if (this.closed) {
            return AppendResult.FILE_CLOSED;
        }
        return this.appendCommitLog(message.getByteBuffer());
    }

    @Override
    public AppendResult appendConsumeQueue(DispatchRequest request) {
        if (this.closed) {
            return AppendResult.FILE_CLOSED;
        }
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putLong(request.getCommitLogOffset());
        buffer.putInt(request.getMsgSize());
        buffer.putLong(request.getTagsCode());
        buffer.flip();
        return this.consumeQueue.append(buffer, request.getStoreTimestamp());
    }

    @Override
    public void release() {
    }

    @Override
    public long getMinStoreTimestamp() {
        long minStoreTime = -1L;
        if (Long.MAX_VALUE != this.commitLog.getMinTimestamp()) {
            minStoreTime = Math.max(minStoreTime, this.commitLog.getMinTimestamp());
        }
        if (Long.MAX_VALUE != this.consumeQueue.getMinTimestamp()) {
            minStoreTime = Math.max(minStoreTime, this.consumeQueue.getMinTimestamp());
        }
        return minStoreTime;
    }

    @Override
    public long getMaxStoreTimestamp() {
        return this.commitLog.getMaxTimestamp();
    }

    @Override
    public long getFirstMessageOffset() {
        return this.commitLog.getMinOffsetFromFile();
    }

    @Override
    public long getCommitLogMinOffset() {
        return this.commitLog.getMinOffset();
    }

    @Override
    public long getCommitLogMaxOffset() {
        return this.commitLog.getAppendOffset();
    }

    @Override
    public long getCommitLogCommitOffset() {
        return this.commitLog.getCommitOffset();
    }

    @Override
    public long getConsumeQueueMinOffset() {
        long cqOffset = this.consumeQueue.getMinOffset() / 20L;
        long effectiveOffset = this.commitLog.getMinOffsetFromFile();
        return Math.max(cqOffset, effectiveOffset);
    }

    @Override
    public long getConsumeQueueMaxOffset() {
        return this.consumeQueue.getAppendOffset() / 20L;
    }

    @Override
    public long getConsumeQueueCommitOffset() {
        return this.consumeQueue.getCommitOffset() / 20L;
    }

    @Override
    public CompletableFuture<Boolean> commitAsync() {
        if (this.commitLock.drainPermits() <= 0) {
            return CompletableFuture.completedFuture(false);
        }
        return ((CompletableFuture)this.commitLog.commitAsync().thenCompose(result -> {
            if (result.booleanValue()) {
                return this.consumeQueue.commitAsync();
            }
            return CompletableFuture.completedFuture(false);
        })).whenComplete((result, throwable) -> this.commitLock.release());
    }

    @Override
    public CompletableFuture<ByteBuffer> getMessageAsync(long queueOffset) {
        return this.getConsumeQueueAsync(queueOffset).thenCompose(cqBuffer -> {
            long commitLogOffset = MessageFormatUtil.getCommitLogOffsetFromItem(cqBuffer);
            int length = MessageFormatUtil.getSizeFromItem(cqBuffer);
            return this.getCommitLogAsync(commitLogOffset, length);
        });
    }

    @Override
    public CompletableFuture<ByteBuffer> getCommitLogAsync(long offset, int length) {
        return this.commitLog.readAsync(offset, length);
    }

    @Override
    public CompletableFuture<ByteBuffer> getConsumeQueueAsync(long queueOffset) {
        return this.getConsumeQueueAsync(queueOffset, 1);
    }

    @Override
    public CompletableFuture<ByteBuffer> getConsumeQueueAsync(long queueOffset, int count) {
        return this.consumeQueue.readAsync(queueOffset * 20L, count * 20);
    }

    @Override
    public CompletableFuture<Long> getQueueOffsetByTimeAsync(long timestamp, BoundaryType boundaryType) {
        FileSegment fileSegment;
        long cqMin = this.getConsumeQueueMinOffset();
        long cqMax = this.getConsumeQueueCommitOffset() - 1L;
        if (cqMax == -1L || cqMax < cqMin) {
            return CompletableFuture.completedFuture(cqMin);
        }
        ByteBuffer buffer = this.getMessageAsync(cqMax).join();
        long storeTime = MessageFormatUtil.getStoreTimeStamp(buffer);
        if (storeTime < timestamp) {
            log.info("FlatMessageFile getQueueOffsetByTimeAsync, exceeded maximum time, filePath={}, timestamp={}, result={}", new Object[]{this.filePath, timestamp, cqMax + 1L});
            return CompletableFuture.completedFuture(cqMax + 1L);
        }
        buffer = this.getMessageAsync(cqMin).join();
        storeTime = MessageFormatUtil.getStoreTimeStamp(buffer);
        if (storeTime > timestamp) {
            log.info("FlatMessageFile getQueueOffsetByTimeAsync, less than minimum time, filePath={}, timestamp={}, result={}", new Object[]{this.filePath, timestamp, cqMin});
            return CompletableFuture.completedFuture(cqMin);
        }
        List<FileSegment> consumeQueueFileList = this.consumeQueue.getFileSegmentList();
        int low = 0;
        int high = consumeQueueFileList.size() - 1;
        int mid = low + (high - low) / 2;
        while (low <= high && ((fileSegment = consumeQueueFileList.get(mid)).getMinTimestamp() > timestamp || timestamp > fileSegment.getMaxTimestamp())) {
            if (timestamp < fileSegment.getMinTimestamp()) {
                high = mid - 1;
            } else {
                low = mid + 1;
            }
            mid = low + (high - low) / 2;
        }
        FileSegment target = consumeQueueFileList.get(mid);
        long minOffset = target.getBaseOffset() / 20L;
        long maxOffset = target.getCommitOffset() / 20L - 1L;
        ArrayList<String> queryLog = new ArrayList<String>();
        while (minOffset < maxOffset) {
            long middle = minOffset + (maxOffset - minOffset) / 2L;
            buffer = this.getMessageAsync(middle).join();
            storeTime = MessageFormatUtil.getStoreTimeStamp(buffer);
            queryLog.add(String.format("(range=%d-%d, middle=%d, timestamp=%d, diff=%dms)", minOffset, maxOffset, middle, storeTime, timestamp - storeTime));
            if (storeTime < timestamp) {
                minOffset = middle + 1L;
                continue;
            }
            maxOffset = middle;
        }
        long offset = minOffset;
        if (boundaryType == BoundaryType.UPPER) {
            long next;
            while ((next = offset + 1L) <= cqMax && (storeTime = MessageFormatUtil.getStoreTimeStamp(buffer = this.getMessageAsync(next).join())) == timestamp) {
                offset = next;
            }
        }
        log.info("FlatMessageFile getQueueOffsetByTimeAsync, filePath={}, timestamp={}, result={}, log={}", new Object[]{this.filePath, timestamp, offset, JSON.toJSONString(queryLog)});
        return CompletableFuture.completedFuture(offset);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.filePath, (CharSequence)((FlatMessageFile)obj).filePath);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void shutdown() {
        this.closed = true;
        this.fileLock.lock();
        try {
            this.consumeQueue.shutdown();
            this.commitLog.shutdown();
        }
        finally {
            this.fileLock.unlock();
        }
    }

    @Override
    public void destroyExpiredFile(long timestamp) {
        this.fileLock.lock();
        try {
            this.consumeQueue.destroyExpiredFile(timestamp);
            this.commitLog.destroyExpiredFile(timestamp);
        }
        finally {
            this.fileLock.unlock();
        }
    }

    @Override
    public void destroy() {
        this.shutdown();
        this.fileLock.lock();
        try {
            this.consumeQueue.destroyExpiredFile(Long.MAX_VALUE);
            this.commitLog.destroyExpiredFile(Long.MAX_VALUE);
            if (this.queueMetadata != null) {
                this.metadataStore.deleteQueue(this.queueMetadata.getQueue());
            }
        }
        finally {
            this.fileLock.unlock();
        }
    }

    public long getFileReservedHours() {
        if (this.topicMetadata.getReserveTime() > 0L) {
            return this.topicMetadata.getReserveTime();
        }
        return this.storeConfig.getTieredStoreFileReservedTime();
    }
}

