/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.processor;

import com.google.common.base.Stopwatch;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.common.Attributes;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.controller.metrics.ControllerMetricsConstant;
import org.apache.rocketmq.controller.metrics.ControllerMetricsManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.RoleChangeNotifyEntry;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.admin.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.BrokerHeartbeatRequestHeader;

public class ControllerRequestProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private static final int WAIT_TIMEOUT_OUT = 5;
    private final ControllerManager controllerManager;
    private final BrokerHeartbeatManager heartbeatManager;
    protected Set<String> configBlackList = new HashSet<String>();

    public ControllerRequestProcessor(ControllerManager controllerManager) {
        this.controllerManager = controllerManager;
        this.heartbeatManager = controllerManager.getHeartbeatManager();
        this.initConfigBlackList();
    }

    private void initConfigBlackList() {
        this.configBlackList.add("configBlackList");
        this.configBlackList.add("configStorePath");
        this.configBlackList.add("rocketmqHome");
        String[] configArray = this.controllerManager.getControllerConfig().getConfigBlackList().split(";");
        this.configBlackList.addAll(Arrays.asList(configArray));
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        if (ctx != null) {
            log.debug("Receive request, {} {} {}", new Object[]{request.getCode(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), request});
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            RemotingCommand resp = this.handleRequest(ctx, request);
            Attributes attributes = ControllerMetricsManager.newAttributesBuilder().put("request_type", ControllerMetricsConstant.RequestType.getLowerCaseNameByCode(request.getCode())).put("request_handle_status", ControllerMetricsConstant.RequestHandleStatus.SUCCESS.getLowerCaseName()).build();
            ControllerMetricsManager.requestTotal.add(1L, attributes);
            attributes = ControllerMetricsManager.newAttributesBuilder().put("request_type", ControllerMetricsConstant.RequestType.getLowerCaseNameByCode(request.getCode())).build();
            ControllerMetricsManager.requestLatency.record(stopwatch.elapsed(TimeUnit.MICROSECONDS), attributes);
            return resp;
        }
        catch (Exception e) {
            log.error("process request: {} error, ", (Object)request, (Object)e);
            Attributes attributes = e instanceof TimeoutException ? ControllerMetricsManager.newAttributesBuilder().put("request_type", ControllerMetricsConstant.RequestType.getLowerCaseNameByCode(request.getCode())).put("request_handle_status", ControllerMetricsConstant.RequestHandleStatus.TIMEOUT.getLowerCaseName()).build() : ControllerMetricsManager.newAttributesBuilder().put("request_type", ControllerMetricsConstant.RequestType.getLowerCaseNameByCode(request.getCode())).put("request_handle_status", ControllerMetricsConstant.RequestHandleStatus.FAILED.getLowerCaseName()).build();
            ControllerMetricsManager.requestTotal.add(1L, attributes);
            throw e;
        }
    }

    private RemotingCommand handleRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        switch (request.getCode()) {
            case 1001: {
                return this.handleAlterSyncStateSet(ctx, request);
            }
            case 1002: {
                return this.handleControllerElectMaster(ctx, request);
            }
            case 1004: {
                return this.handleControllerGetReplicaInfo(ctx, request);
            }
            case 1005: {
                return this.handleControllerGetMetadataInfo(ctx, request);
            }
            case 904: {
                return this.handleBrokerHeartbeat(ctx, request);
            }
            case 1006: {
                return this.handleControllerGetSyncStateData(ctx, request);
            }
            case 1009: {
                return this.handleUpdateControllerConfig(ctx, request);
            }
            case 1010: {
                return this.handleGetControllerConfig(ctx, request);
            }
            case 1011: {
                return this.handleCleanBrokerData(ctx, request);
            }
            case 1012: {
                return this.handleGetNextBrokerId(ctx, request);
            }
            case 1013: {
                return this.handleApplyBrokerId(ctx, request);
            }
            case 1003: {
                return this.handleRegisterBroker(ctx, request);
            }
        }
        String error = " request type " + request.getCode() + " not supported";
        return RemotingCommand.createResponseCommand((int)3, (String)error);
    }

    private RemotingCommand handleAlterSyncStateSet(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        AlterSyncStateSetRequestHeader controllerRequest = (AlterSyncStateSetRequestHeader)request.decodeCommandCustomHeader(AlterSyncStateSetRequestHeader.class);
        SyncStateSet syncStateSet = (SyncStateSet)RemotingSerializable.decode((byte[])request.getBody(), SyncStateSet.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().alterSyncStateSet(controllerRequest, syncStateSet);
        if (future != null) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleControllerElectMaster(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        ElectMasterRequestHeader electMasterRequest = (ElectMasterRequestHeader)request.decodeCommandCustomHeader(ElectMasterRequestHeader.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().electMaster(electMasterRequest);
        if (future != null) {
            RemotingCommand response = future.get(5L, TimeUnit.SECONDS);
            if (response.getCode() == 0 && this.controllerManager.getControllerConfig().isNotifyBrokerRoleChanged()) {
                this.controllerManager.notifyBrokerRoleChanged(RoleChangeNotifyEntry.convert((RemotingCommand)response));
            }
            return response;
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleControllerGetReplicaInfo(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        GetReplicaInfoRequestHeader controllerRequest = (GetReplicaInfoRequestHeader)request.decodeCommandCustomHeader(GetReplicaInfoRequestHeader.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().getReplicaInfo(controllerRequest);
        if (future != null) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleControllerGetMetadataInfo(ChannelHandlerContext ctx, RemotingCommand request) {
        return this.controllerManager.getController().getControllerMetadata();
    }

    private RemotingCommand handleBrokerHeartbeat(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        BrokerHeartbeatRequestHeader requestHeader = (BrokerHeartbeatRequestHeader)request.decodeCommandCustomHeader(BrokerHeartbeatRequestHeader.class);
        if (requestHeader.getBrokerId() == null) {
            return RemotingCommand.createResponseCommand((int)2005, (String)"Heart beat with empty brokerId");
        }
        this.heartbeatManager.onBrokerHeartbeat(requestHeader.getClusterName(), requestHeader.getBrokerName(), requestHeader.getBrokerAddr(), requestHeader.getBrokerId(), requestHeader.getHeartbeatTimeoutMills(), ctx.channel(), requestHeader.getEpoch(), requestHeader.getMaxOffset(), requestHeader.getConfirmOffset(), requestHeader.getElectionPriority());
        return RemotingCommand.createResponseCommand((int)0, (String)"Heart beat success");
    }

    private RemotingCommand handleControllerGetSyncStateData(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        CompletableFuture<RemotingCommand> future;
        List brokerNames;
        if (request.getBody() != null && (brokerNames = (List)RemotingSerializable.decode((byte[])request.getBody(), List.class)) != null && brokerNames.size() > 0 && (future = this.controllerManager.getController().getSyncStateData(brokerNames)) != null) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleCleanBrokerData(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        CleanControllerBrokerDataRequestHeader requestHeader = (CleanControllerBrokerDataRequestHeader)request.decodeCommandCustomHeader(CleanControllerBrokerDataRequestHeader.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().cleanBrokerData(requestHeader);
        if (null != future) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleGetNextBrokerId(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        GetNextBrokerIdRequestHeader requestHeader = (GetNextBrokerIdRequestHeader)request.decodeCommandCustomHeader(GetNextBrokerIdRequestHeader.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().getNextBrokerId(requestHeader);
        if (future != null) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleApplyBrokerId(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        ApplyBrokerIdRequestHeader requestHeader = (ApplyBrokerIdRequestHeader)request.decodeCommandCustomHeader(ApplyBrokerIdRequestHeader.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().applyBrokerId(requestHeader);
        if (future != null) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleRegisterBroker(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        RegisterBrokerToControllerRequestHeader requestHeader = (RegisterBrokerToControllerRequestHeader)request.decodeCommandCustomHeader(RegisterBrokerToControllerRequestHeader.class);
        CompletableFuture<RemotingCommand> future = this.controllerManager.getController().registerBroker(requestHeader);
        if (future != null) {
            return future.get(5L, TimeUnit.SECONDS);
        }
        return RemotingCommand.createResponseCommand(null);
    }

    private RemotingCommand handleUpdateControllerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        if (ctx != null) {
            log.info("updateConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = request.getBody();
        if (body != null) {
            String bodyStr;
            try {
                bodyStr = new String(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("updateConfig byte array to string error: ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
            Properties properties = MixAll.string2Properties((String)bodyStr);
            if (properties == null) {
                log.error("updateConfig MixAll.string2Properties error {}", (Object)bodyStr);
                response.setCode(1);
                response.setRemark("string2Properties error");
                return response;
            }
            if (this.validateBlackListConfigExist(properties)) {
                response.setCode(16);
                response.setRemark("Can not update config in black list.");
                return response;
            }
            this.controllerManager.getConfiguration().update(properties);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand handleGetControllerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.controllerManager.getConfiguration().getAllConfigsFormatString();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("getConfig error, ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public boolean rejectRequest() {
        return false;
    }

    private boolean validateBlackListConfigExist(Properties properties) {
        for (String blackConfig : this.configBlackList) {
            if (!properties.containsKey(blackConfig)) continue;
            return true;
        }
        return false;
    }
}

