/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import java.util.Objects;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class EpochEntry
extends RemotingSerializable {
    private int epoch;
    private long startOffset;
    private long endOffset = Long.MAX_VALUE;

    public EpochEntry(EpochEntry entry) {
        this.epoch = entry.getEpoch();
        this.startOffset = entry.getStartOffset();
        this.endOffset = entry.getEndOffset();
    }

    public EpochEntry(int epoch, long startOffset) {
        this.epoch = epoch;
        this.startOffset = startOffset;
    }

    public EpochEntry(int epoch, long startOffset, long endOffset) {
        this.epoch = epoch;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(long endOffset) {
        this.endOffset = endOffset;
    }

    public String toString() {
        return "EpochEntry{epoch=" + this.epoch + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EpochEntry entry = (EpochEntry)o;
        return this.epoch == entry.epoch && this.startOffset == entry.startOffset && this.endOffset == entry.endOffset;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.startOffset, this.endOffset);
    }
}

