/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeeringConfig;
import com.microsoft.azure.management.network.ExpressRouteCrossConnection;
import com.microsoft.azure.management.network.ExpressRouteCrossConnectionPeering;
import com.microsoft.azure.management.network.ExpressRoutePeeringState;
import com.microsoft.azure.management.network.ExpressRoutePeeringType;
import com.microsoft.azure.management.network.Ipv6ExpressRouteCircuitPeeringConfig;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCrossConnectionPeeringsInner;
import com.microsoft.azure.management.network.implementation.Ipv6PeeringConfigImpl;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Arrays;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ExpressRouteCrossConnectionPeeringImpl
extends CreatableUpdatableImpl<ExpressRouteCrossConnectionPeering, ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeeringImpl>
implements ExpressRouteCrossConnectionPeering,
ExpressRouteCrossConnectionPeering.Definition,
ExpressRouteCrossConnectionPeering.Update {
    private final ExpressRouteCrossConnectionPeeringsInner client;
    private final ExpressRouteCrossConnection parent;

    ExpressRouteCrossConnectionPeeringImpl(ExpressRouteCrossConnectionImpl parent, ExpressRouteCrossConnectionPeeringInner innerObject, ExpressRoutePeeringType type) {
        super(type.toString(), (Object)innerObject);
        this.client = ((NetworkManagementClientImpl)((Object)((NetworkManager)parent.manager()).inner())).expressRouteCrossConnectionPeerings();
        this.parent = parent;
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withPeeringType(type);
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withAdvertisedPublicPrefixes(String publicPrefix) {
        this.ensureMicrosoftPeeringConfig().withAdvertisedPublicPrefixes(Arrays.asList(publicPrefix));
        return this;
    }

    private ExpressRouteCircuitPeeringConfig ensureMicrosoftPeeringConfig() {
        if (((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).microsoftPeeringConfig() == null) {
            ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withMicrosoftPeeringConfig(new ExpressRouteCircuitPeeringConfig());
        }
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).microsoftPeeringConfig();
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withPrimaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withPrimaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withSecondaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withSecondaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withVlanId(int vlanId) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withVlanId(vlanId);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withPeerAsn(long peerAsn) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withPeerASN(peerAsn);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeering.DefinitionStages.WithCreate withSharedKey(String sharedKey) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withSharedKey(sharedKey);
        return this;
    }

    public Ipv6PeeringConfigImpl defineIpv6Config() {
        return new Ipv6PeeringConfigImpl(new Ipv6ExpressRouteCircuitPeeringConfig(), this);
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withoutIpv6Config() {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withIpv6PeeringConfig(null);
        return this;
    }

    ExpressRouteCrossConnectionPeeringImpl attachIpv6Config(Ipv6PeeringConfigImpl ipv6PeeringConfig) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withIpv6PeeringConfig((Ipv6ExpressRouteCircuitPeeringConfig)ipv6PeeringConfig.inner());
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withCustomerASN(int customerASN) {
        this.ensureMicrosoftPeeringConfig().withCustomerASN(customerASN);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withRoutingRegistryName(String routingRegistryName) {
        this.ensureMicrosoftPeeringConfig().withRoutingRegistryName(routingRegistryName);
        return this;
    }

    @Override
    public ExpressRouteCrossConnectionPeeringImpl withState(ExpressRoutePeeringState state) {
        ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).withState(state);
        return this;
    }

    protected Observable<ExpressRouteCrossConnectionPeeringInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    public boolean isInCreateMode() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).id() == null;
    }

    public Observable<ExpressRouteCrossConnectionPeering> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), (ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).map((Func1)new Func1<ExpressRouteCrossConnectionPeeringInner, ExpressRouteCrossConnectionPeering>(){

            public ExpressRouteCrossConnectionPeering call(ExpressRouteCrossConnectionPeeringInner innerModel) {
                ExpressRouteCrossConnectionPeeringImpl.this.setInner((Object)innerModel);
                ExpressRouteCrossConnectionPeeringImpl.this.parent.refresh();
                return ExpressRouteCrossConnectionPeeringImpl.this;
            }
        });
    }

    public String id() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).id();
    }

    public NetworkManager manager() {
        return (NetworkManager)((Object)this.parent.manager());
    }

    public String resourceGroupName() {
        return this.parent.resourceGroupName();
    }

    @Override
    public ExpressRoutePeeringType peeringType() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).peeringType();
    }

    @Override
    public ExpressRoutePeeringState state() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).state();
    }

    @Override
    public int azureASN() {
        return Utils.toPrimitiveInt((Integer)((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).azureASN());
    }

    @Override
    public long peerASN() {
        return Utils.toPrimitiveLong((Long)((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).peerASN());
    }

    @Override
    public String primaryPeerAddressPrefix() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).primaryPeerAddressPrefix();
    }

    @Override
    public String secondaryPeerAddressPrefix() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).secondaryPeerAddressPrefix();
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).secondaryAzurePort();
    }

    @Override
    public String sharedKey() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).sharedKey();
    }

    @Override
    public int vlanId() {
        return Utils.toPrimitiveInt((Integer)((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).vlanId());
    }

    @Override
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).microsoftPeeringConfig();
    }

    @Override
    public String provisioningState() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String gatewayManagerEtag() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).gatewayManagerEtag();
    }

    @Override
    public String lastModifiedBy() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).lastModifiedBy();
    }

    @Override
    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return ((ExpressRouteCrossConnectionPeeringInner)((Object)this.inner())).ipv6PeeringConfig();
    }
}

