/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintTarget;
import javax.validation.Payload;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import javax.xml.bind.JAXBElement;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.EmptyBuilder;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.metadata.XmlBuilder$org_apache_bval_util_reflection_Reflection$$getPublicMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION;
import org.apache.bval.jsr.metadata.XmlBuilder$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.util.AnnotationProxyBuilder;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.jsr.xml.AnnotationType;
import org.apache.bval.jsr.xml.BeanType;
import org.apache.bval.jsr.xml.ClassType;
import org.apache.bval.jsr.xml.ConstraintMappingsType;
import org.apache.bval.jsr.xml.ConstraintType;
import org.apache.bval.jsr.xml.ConstructorType;
import org.apache.bval.jsr.xml.ContainerElementTypeType;
import org.apache.bval.jsr.xml.CrossParameterType;
import org.apache.bval.jsr.xml.ElementType;
import org.apache.bval.jsr.xml.FieldType;
import org.apache.bval.jsr.xml.GetterType;
import org.apache.bval.jsr.xml.GroupConversionType;
import org.apache.bval.jsr.xml.GroupSequenceType;
import org.apache.bval.jsr.xml.GroupsType;
import org.apache.bval.jsr.xml.MappingValidator;
import org.apache.bval.jsr.xml.MethodType;
import org.apache.bval.jsr.xml.ParameterType;
import org.apache.bval.jsr.xml.PayloadType;
import org.apache.bval.jsr.xml.ReturnValueType;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class XmlBuilder {
    private final ApacheValidatorFactory validatorFactory;
    private final ConstraintMappingsType constraintMappings;
    private final Version version;

    private static final <T> T lazy(Lazy<T> lazy, String name) {
        Validate.validState(lazy != null, "%s not set", name);
        return lazy.get();
    }

    public XmlBuilder(ApacheValidatorFactory validatorFactory, ConstraintMappingsType constraintMappings) {
        this.validatorFactory = Validate.notNull(validatorFactory, "validatorFactory", new Object[0]);
        this.constraintMappings = Validate.notNull(constraintMappings, "constraintMappings", new Object[0]);
        this.version = Version.of(constraintMappings);
        new MappingValidator(constraintMappings, this::resolveClass).validateMappings();
    }

    public Map<Class<?>, MetadataBuilder.ForBean<?>> forBeans() {
        return this.constraintMappings.getBean().stream().map(x$0 -> new ForBean((BeanType)x$0)).collect(ToUnmodifiable.map(ForBean::getBeanClass, Function.identity()));
    }

    public String getDefaultPackage() {
        return this.constraintMappings.getDefaultPackage();
    }

    boolean atLeast(Version v) {
        return this.version.compareTo(v) >= 0;
    }

    <T> Class<T> resolveClass(String className) {
        return this.loadClass(this.toQualifiedClassName(className));
    }

    private String toQualifiedClassName(String className) {
        if (this.isQualifiedClass(className)) {
            return className;
        }
        if (className.startsWith("[L") && className.endsWith(";")) {
            return "[L" + this.getDefaultPackage() + "." + className.substring(2);
        }
        return this.getDefaultPackage() + "." + className;
    }

    private boolean isQualifiedClass(String clazz) {
        return clazz.indexOf(46) >= 0;
    }

    private <T> Class<T> loadClass(String fqn) {
        ClassLoader loader = XmlBuilder.org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(XmlBuilder.class);
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            return Class.forName(fqn, true, loader);
        }
        catch (ClassNotFoundException ex) {
            throw Exceptions.create(ValidationException::new, ex, "Unable to load class: %d", fqn);
        }
    }

    @Privileged
    private static /* synthetic */ ClassLoader org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return XmlBuilder.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
        }
        return (ClassLoader)AccessController.doPrivileged(new XmlBuilder$org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ ClassLoader __privileged_access$0(Class clazz) {
        return XmlBuilder.__privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(clazz);
    }

    private static /* synthetic */ ClassLoader __privileged_org_apache_bval_util_reflection_Reflection$$loaderFromThreadOrClass(Class<?> clazz) {
        return Optional.of(Thread.currentThread()).map(Thread::getContextClassLoader).orElseGet(() -> Validate.notNull(clazz).getClassLoader());
    }

    private Class<?>[] loadClasses(Supplier<Stream<String>> classNames) {
        return (Class[])this.streamClasses(classNames).toArray(Class[]::new);
    }

    private Stream<Class<?>> streamClasses(Supplier<Stream<String>> classNames) {
        return classNames.get().map(this::loadClass);
    }

    private <A extends Annotation, T> A createConstraint(ConstraintType constraint) {
        return this.createConstraint(constraint, ConstraintTarget.IMPLICIT);
    }

    private <A extends Annotation, T> A createConstraint(ConstraintType constraint, ConstraintTarget target) {
        Class<T> annotationClass = this.loadClass(this.toQualifiedClassName(constraint.getAnnotation()));
        AnnotationProxyBuilder<Class<T>> annoBuilder = this.validatorFactory.getAnnotationsManager().buildProxyFor(annotationClass);
        if (constraint.getMessage() != null) {
            annoBuilder.setMessage(constraint.getMessage());
        }
        annoBuilder.setGroups(this.getGroups(constraint.getGroups()));
        annoBuilder.setPayload(this.getPayload(constraint.getPayload()));
        if (ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.analyze(annotationClass).isValid()) {
            annoBuilder.setValidationAppliesTo(target);
        }
        for (ElementType elementType : constraint.getElement()) {
            String name = elementType.getName();
            Class<?> returnType = this.getAnnotationParameterType(annotationClass, name);
            Object elementValue = this.getElementValue(elementType, returnType);
            annoBuilder.setValue(name, elementValue);
        }
        return (A)annoBuilder.createAnnotation();
    }

    private <A extends Annotation> Class<?> getAnnotationParameterType(Class<A> annotationClass, String name) {
        Method m = XmlBuilder.org_apache_bval_util_reflection_Reflection$$getPublicMethod(annotationClass, name, new Class[0]);
        Exceptions.raiseIf(m == null, ValidationException::new, "Annotation of type %s does not contain a parameter %s.", annotationClass.getName(), name);
        return m.getReturnType();
    }

    @Privileged
    private static /* synthetic */ Method org_apache_bval_util_reflection_Reflection$$getPublicMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        if (!(System.getSecurityManager() != null)) {
            return XmlBuilder.__privileged_org_apache_bval_util_reflection_Reflection$$getPublicMethod(clazz, string, classArray);
        }
        return (Method)AccessController.doPrivileged(new XmlBuilder$org_apache_bval_util_reflection_Reflection$$getPublicMethod$$Ljava_lang_Class$Ljava_lang_String$arrayOfLjava_lang_Class$_ACTION(clazz, string, classArray));
    }

    static /* synthetic */ Method __privileged_access$1(Class clazz, String string, Class[] classArray) {
        return XmlBuilder.__privileged_org_apache_bval_util_reflection_Reflection$$getPublicMethod(clazz, string, classArray);
    }

    private static /* synthetic */ Method __privileged_org_apache_bval_util_reflection_Reflection$$getPublicMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Object getElementValue(ElementType elementType, Class<?> returnType) {
        this.removeEmptyContentElements(elementType);
        List<Serializable> content = elementType.getContent();
        int sz = content.size();
        if (returnType.isArray()) {
            Object result = Array.newInstance(returnType.getComponentType(), sz);
            for (int i = 0; i < sz; ++i) {
                Array.set(result, i, this.getSingleValue(content.get(i), returnType.getComponentType()));
            }
            return result;
        }
        Exceptions.raiseIf(sz != 1, ValidationException::new, "Attempt to specify an array where single value is expected.", new Object[0]);
        return this.getSingleValue(content.get(0), returnType);
    }

    private void removeEmptyContentElements(ElementType elementType) {
        Iterator<Serializable> iter = elementType.getContent().iterator();
        while (iter.hasNext()) {
            Serializable content = iter.next();
            if (!(content instanceof String) || !((String)((Object)content)).matches("[\\n ].*")) continue;
            iter.remove();
        }
    }

    private Object getSingleValue(Serializable serializable, Class<?> returnType) {
        if (serializable instanceof String) {
            return this.convertToResultType(returnType, (String)((Object)serializable));
        }
        if (serializable instanceof JAXBElement) {
            JAXBElement elem = (JAXBElement)serializable;
            if (String.class.equals((Object)elem.getDeclaredType())) {
                return this.convertToResultType(returnType, (String)elem.getValue());
            }
            if (AnnotationType.class.equals((Object)elem.getDeclaredType())) {
                AnnotationType annotationType = (AnnotationType)elem.getValue();
                try {
                    return this.createAnnotation(annotationType, returnType);
                }
                catch (ClassCastException e) {
                    throw new ValidationException("Unexpected parameter value");
                }
            }
        }
        throw new ValidationException("Unexpected parameter value");
    }

    private Object convertToResultType(Class<?> returnType, String value) {
        if (String.class.equals(returnType)) {
            return value;
        }
        if (Class.class.equals(returnType)) {
            return this.resolveClass(value);
        }
        if (returnType.isEnum()) {
            try {
                Enum e = Enum.valueOf(returnType.asSubclass(Enum.class), value);
                return e;
            }
            catch (IllegalArgumentException e) {
                throw new ConstraintDeclarationException((Throwable)e);
            }
        }
        try {
            if (Byte.class.equals(returnType) || Byte.TYPE.equals(returnType)) {
                return Byte.parseByte(value);
            }
            if (Short.class.equals(returnType) || Short.TYPE.equals(returnType)) {
                return Short.parseShort(value);
            }
            if (Integer.class.equals(returnType) || Integer.TYPE.equals(returnType)) {
                return Integer.parseInt(value);
            }
            if (Long.class.equals(returnType) || Long.TYPE.equals(returnType)) {
                return Long.parseLong(value);
            }
            if (Float.class.equals(returnType) || Float.TYPE.equals(returnType)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.class.equals(returnType) || Double.TYPE.equals(returnType)) {
                return Double.parseDouble(value);
            }
            if (Boolean.class.equals(returnType) || Boolean.TYPE.equals(returnType)) {
                return Boolean.parseBoolean(value);
            }
        }
        catch (Exception e) {
            Exceptions.raise(ValidationException::new, e, "Unable to coerce value '%s' to %s", value, returnType);
        }
        if (Character.class.equals(returnType) || Character.TYPE.equals(returnType)) {
            Exceptions.raiseIf(value.length() > 1, ConstraintDeclarationException::new, "a char must have a length of 1", new Object[0]);
            return Character.valueOf(value.charAt(0));
        }
        return Exceptions.raise(ValidationException::new, "Unknown annotation value type %s", returnType.getName());
    }

    private <A extends Annotation> Annotation createAnnotation(AnnotationType annotationType, Class<A> returnType) {
        AnnotationProxyBuilder<Class<A>> metaAnnotation = this.validatorFactory.getAnnotationsManager().buildProxyFor(returnType);
        for (ElementType elementType : annotationType.getElement()) {
            String name = elementType.getName();
            metaAnnotation.setValue(name, this.getElementValue(elementType, this.getAnnotationParameterType(returnType, name)));
        }
        return metaAnnotation.createAnnotation();
    }

    private Class<?>[] getGroups(GroupsType groupsType) {
        if (groupsType == null) {
            return ObjectUtils.EMPTY_CLASS_ARRAY;
        }
        return this.loadClasses(groupsType.getValue()::stream);
    }

    private Class<? extends Payload>[] getPayload(PayloadType payloadType) {
        if (payloadType == null) {
            return ObjectUtils.EMPTY_CLASS_ARRAY;
        }
        return (Class[])this.streamClasses(payloadType.getValue()::stream).peek(pc -> Exceptions.raiseUnless(Payload.class.isAssignableFrom((Class<?>)pc), ConstraintDeclarationException::new, "Specified payload class %s does not implement %s", pc.getName(), Payload.class.getName())).map(pc -> pc.asSubclass(Payload.class)).toArray(Class[]::new);
    }

    private class ForReturnValue<E extends Executable>
    extends ForContainer<ForReturnValue<E>, E, ReturnValueType> {
        ForReturnValue(ReturnValueType descriptor) {
            super(descriptor);
            ((ForReturnValue)((ForReturnValue)((ForReturnValue)((ForReturnValue)this.withGetDeclaredConstraints(d -> (Annotation[])d.getConstraint().stream().map(ct -> XmlBuilder.this.createConstraint(ct, ConstraintTarget.RETURN_VALUE)).toArray(Annotation[]::new))).withGetIgnoreAnnotations(ReturnValueType::getIgnoreAnnotations)).withGetValid(ReturnValueType::getValid)).withGetGroupConversions(ReturnValueType::getConvertGroup)).withGetContainerElementTypes(ReturnValueType::getContainerElementType);
        }
    }

    private class ForCrossParameter<E extends Executable>
    extends ForElement<ForCrossParameter<E>, E, CrossParameterType> {
        ForCrossParameter(CrossParameterType descriptor) {
            super(descriptor);
            ((ForCrossParameter)this.withGetIgnoreAnnotations(CrossParameterType::getIgnoreAnnotations)).withGetDeclaredConstraints(d -> (Annotation[])d.getConstraint().stream().map(ct -> XmlBuilder.this.createConstraint(ct, ConstraintTarget.PARAMETERS)).toArray(Annotation[]::new));
        }
    }

    private class ForParameter
    extends ForContainer<ForParameter, Parameter, ParameterType> {
        ForParameter(ParameterType descriptor) {
            super(descriptor);
            ((ForParameter)((ForParameter)((ForParameter)((ForParameter)this.withGetIgnoreAnnotations(ParameterType::getIgnoreAnnotations)).withGetConstraintTypes(ParameterType::getConstraint)).withGetValid(ParameterType::getValid)).withGetGroupConversions(ParameterType::getConvertGroup)).withGetContainerElementTypes(ParameterType::getContainerElementType);
        }
    }

    private class ForMethod
    extends ForExecutable<ForMethod, Method, MethodType> {
        ForMethod(MethodType descriptor) {
            super(descriptor);
            ((ForMethod)((ForMethod)((ForMethod)this.withGetIgnoreAnnotations(MethodType::getIgnoreAnnotations)).withGetReturnValue(MethodType::getReturnValue)).withGetCrossParameter(MethodType::getCrossParameter)).withGetParameters(MethodType::getParameter);
        }
    }

    private class ForConstructor<T>
    extends ForExecutable<ForConstructor<T>, Constructor<? extends T>, ConstructorType> {
        ForConstructor(ConstructorType descriptor) {
            super(descriptor);
            ((ForConstructor)((ForConstructor)((ForConstructor)this.withGetIgnoreAnnotations(ConstructorType::getIgnoreAnnotations)).withGetReturnValue(ConstructorType::getReturnValue)).withGetCrossParameter(ConstructorType::getCrossParameter)).withGetParameters(ConstructorType::getParameter);
        }
    }

    private abstract class ForExecutable<SELF extends ForExecutable<SELF, E, D>, E extends Executable, D>
    extends NonRootLevel<SELF, D>
    implements MetadataBuilder.ForExecutable<E> {
        Lazy<ReturnValueType> getReturnValue;
        Lazy<CrossParameterType> getCrossParameter;
        Lazy<List<ParameterType>> getParameters;

        ForExecutable(D descriptor) {
            super(descriptor);
        }

        @Override
        public MetadataBuilder.ForElement<E> getCrossParameter(Meta<E> meta) {
            CrossParameterType cp = (CrossParameterType)XmlBuilder.lazy(this.getCrossParameter, "getCrossParameter");
            if (cp == null) {
                return EmptyBuilder.instance().forExecutable().getCrossParameter(meta);
            }
            return new ForCrossParameter(cp);
        }

        @Override
        public MetadataBuilder.ForContainer<E> getReturnValue(Meta<E> meta) {
            ReturnValueType rv = (ReturnValueType)XmlBuilder.lazy(this.getReturnValue, "getReturnValue");
            if (rv == null) {
                return EmptyBuilder.instance().forExecutable().getReturnValue(meta);
            }
            return new ForReturnValue(rv);
        }

        @Override
        public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<E> meta) {
            return ((List)XmlBuilder.lazy(this.getParameters, "getParameters")).stream().map(x$0 -> new ForParameter((ParameterType)x$0)).collect(Collectors.toList());
        }

        SELF withGetReturnValue(Function<D, ReturnValueType> getReturnValue) {
            Validate.notNull(getReturnValue);
            this.getReturnValue = new Lazy<ReturnValueType>(() -> (ReturnValueType)getReturnValue.apply(this.descriptor));
            return (SELF)this;
        }

        SELF withGetCrossParameter(Function<D, CrossParameterType> getCrossParameter) {
            Validate.notNull(getCrossParameter);
            this.getCrossParameter = new Lazy<CrossParameterType>(() -> (CrossParameterType)getCrossParameter.apply(this.descriptor));
            return (SELF)this;
        }

        SELF withGetParameters(Function<D, List<ParameterType>> getParameters) {
            Validate.notNull(getParameters);
            this.getParameters = new Lazy<List>(() -> (List)getParameters.apply(this.descriptor));
            return (SELF)this;
        }
    }

    private class ForGetter
    extends ForContainer<ForGetter, Method, GetterType> {
        ForGetter(GetterType descriptor) {
            super(descriptor);
            ((ForGetter)((ForGetter)((ForGetter)((ForGetter)this.withGetIgnoreAnnotations(GetterType::getIgnoreAnnotations)).withGetConstraintTypes(GetterType::getConstraint)).withGetValid(GetterType::getValid)).withGetGroupConversions(GetterType::getConvertGroup)).withGetContainerElementTypes(GetterType::getContainerElementType);
        }
    }

    private class ForField
    extends ForContainer<ForField, Field, FieldType> {
        ForField(FieldType descriptor) {
            super(descriptor);
            ((ForField)((ForField)((ForField)((ForField)this.withGetIgnoreAnnotations(FieldType::getIgnoreAnnotations)).withGetConstraintTypes(FieldType::getConstraint)).withGetValid(FieldType::getValid)).withGetGroupConversions(FieldType::getConvertGroup)).withGetContainerElementTypes(FieldType::getContainerElementType);
        }
    }

    private class ForContainerElementType
    extends ForContainer<ForContainerElementType, AnnotatedType, ContainerElementTypeType> {
        ForContainerElementType(ContainerElementTypeType descriptor) {
            super(descriptor);
            ((ForContainerElementType)((ForContainerElementType)((ForContainerElementType)this.withGetConstraintTypes(ContainerElementTypeType::getConstraint)).withGetValid(ContainerElementTypeType::getValid)).withGetGroupConversions(ContainerElementTypeType::getConvertGroup)).withGetContainerElementTypes(ContainerElementTypeType::getContainerElementType);
        }
    }

    private class ForContainer<SELF extends ForContainer<SELF, E, D>, E extends AnnotatedElement, D>
    extends ForElement<SELF, E, D>
    implements MetadataBuilder.ForContainer<E> {
        private Lazy<Boolean> isCascade;
        private Lazy<Set<GroupConversion>> getGroupConversions;
        private Lazy<List<ContainerElementTypeType>> getContainerElementTypes;

        ForContainer(D descriptor) {
            super(descriptor);
        }

        @Override
        public boolean isCascade(Meta<E> meta) {
            return Boolean.TRUE.equals(XmlBuilder.lazy(this.isCascade, "isCascade"));
        }

        @Override
        public Set<GroupConversion> getGroupConversions(Meta<E> meta) {
            return (Set)XmlBuilder.lazy(this.getGroupConversions, "getGroupConversions");
        }

        @Override
        public Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> meta) {
            if (!XmlBuilder.this.atLeast(Version.v20)) {
                return Collections.emptyMap();
            }
            List elements = (List)XmlBuilder.lazy(this.getContainerElementTypes, "getContainerElementTypes");
            AnnotatedType annotatedType = meta.getAnnotatedType();
            Object host = meta.getHost();
            if (annotatedType instanceof AnnotatedParameterizedType) {
                AnnotatedType[] actualTypeArguments = ((AnnotatedParameterizedType)annotatedType).getAnnotatedActualTypeArguments();
                return elements.stream().collect(ToUnmodifiable.map(cet -> {
                    Integer typeArgumentIndex = cet.getTypeArgumentIndex();
                    if (typeArgumentIndex == null) {
                        Exceptions.raiseIf(actualTypeArguments.length > 1, ValidationException::new, "Missing required type argument index for %s", host);
                        typeArgumentIndex = 0;
                    }
                    return new ContainerElementKey(annotatedType, typeArgumentIndex);
                }, x$0 -> new ForContainerElementType((ContainerElementTypeType)x$0)));
            }
            if (!elements.isEmpty()) {
                Exceptions.raise(ValidationException::new, "Illegally specified %d container element type(s) for %s", elements.size(), host);
            }
            return Collections.emptyMap();
        }

        SELF withGetValid(Function<D, String> getValid) {
            Validate.notNull(getValid);
            this.isCascade = new Lazy<Boolean>(() -> getValid.apply(this.descriptor) != null);
            return (SELF)this;
        }

        SELF withGetGroupConversions(Function<D, List<GroupConversionType>> getGroupConversions) {
            Validate.notNull(getGroupConversions);
            this.getGroupConversions = new Lazy<Set>(() -> ((List)getGroupConversions.apply(this.descriptor)).stream().map(gc -> {
                String from = gc.getFrom();
                Class<Default> source = from == null ? Default.class : XmlBuilder.this.resolveClass(from);
                Class target = XmlBuilder.this.resolveClass(gc.getTo());
                return GroupConversion.from(source).to(target);
            }).collect(ToUnmodifiable.set()));
            return (SELF)this;
        }

        SELF withGetContainerElementTypes(Function<D, List<ContainerElementTypeType>> getContainerElementTypes) {
            Validate.notNull(getContainerElementTypes);
            this.getContainerElementTypes = new Lazy<List>(() -> (List)getContainerElementTypes.apply(this.descriptor));
            return (SELF)this;
        }
    }

    private class ForClass<T>
    extends ForElement<ForClass<T>, Class<T>, ClassType>
    implements MetadataBuilder.ForClass<T> {
        ForClass(ClassType descriptor) {
            super(descriptor);
            ((ForClass)this.withGetConstraintTypes(ClassType::getConstraint)).withGetIgnoreAnnotations(ClassType::getIgnoreAnnotations);
        }

        @Override
        public List<Class<?>> getGroupSequence(Meta<Class<T>> meta) {
            GroupSequenceType groupSequence = ((ClassType)this.descriptor).getGroupSequence();
            return groupSequence == null ? null : groupSequence.getValue().stream().map(XmlBuilder.this::resolveClass).collect(ToUnmodifiable.list());
        }
    }

    private class ForElement<SELF extends ForElement<SELF, E, D>, E extends AnnotatedElement, D>
    extends NonRootLevel<SELF, D>
    implements MetadataBuilder.ForElement<E> {
        private Lazy<Annotation[]> getDeclaredConstraints;

        ForElement(D descriptor) {
            super(descriptor);
        }

        @Override
        public final Annotation[] getDeclaredConstraints(Meta<E> meta) {
            return (Annotation[])XmlBuilder.lazy(this.getDeclaredConstraints, "getDeclaredConstraints");
        }

        final SELF withGetConstraintTypes(Function<D, List<ConstraintType>> getConstraintTypes) {
            return this.withGetDeclaredConstraints(getConstraintTypes.andThen(l -> (Annotation[])l.stream().map(x$0 -> XmlBuilder.this.createConstraint(x$0)).toArray(Annotation[]::new)));
        }

        final SELF withGetDeclaredConstraints(Function<D, Annotation[]> getDeclaredConstraints) {
            this.getDeclaredConstraints = new Lazy<Annotation[]>(() -> (Annotation[])getDeclaredConstraints.apply(this.descriptor));
            return (SELF)this;
        }
    }

    private class NonRootLevel<SELF extends NonRootLevel<SELF, D>, D>
    implements HasAnnotationBehavior {
        protected final D descriptor;
        private Lazy<Boolean> getIgnoreAnnotations;

        public NonRootLevel(D descriptor) {
            this.descriptor = Validate.notNull(descriptor, "descriptor", new Object[0]);
        }

        @Override
        public final AnnotationBehavior getAnnotationBehavior() {
            return Optional.ofNullable(this.getIgnoreAnnotations).map(Lazy::get).map(b -> b != false ? AnnotationBehavior.EXCLUDE : AnnotationBehavior.INCLUDE).orElse(AnnotationBehavior.ABSTAIN);
        }

        final SELF withGetIgnoreAnnotations(Function<D, Boolean> getIgnoreAnnotations) {
            Validate.notNull(getIgnoreAnnotations);
            this.getIgnoreAnnotations = new Lazy<Boolean>(() -> (Boolean)getIgnoreAnnotations.apply(this.descriptor));
            return (SELF)this;
        }
    }

    private class ForBean<T>
    implements MetadataBuilder.ForBean<T> {
        private final BeanType descriptor;

        ForBean(BeanType descriptor) {
            this.descriptor = Validate.notNull(descriptor, "descriptor", new Object[0]);
        }

        Class<?> getBeanClass() {
            return XmlBuilder.this.resolveClass(this.descriptor.getClazz());
        }

        @Override
        public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> meta) {
            ClassType classType = this.descriptor.getClassType();
            return classType == null ? EmptyBuilder.instance().forBean().getClass(meta) : new ForClass(classType);
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> meta) {
            return this.descriptor.getField().stream().collect(ToUnmodifiable.map(FieldType::getName, x$0 -> new ForField((FieldType)x$0)));
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> meta) {
            return this.descriptor.getGetter().stream().collect(ToUnmodifiable.map(GetterType::getName, x$0 -> new ForGetter((GetterType)x$0)));
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> meta) {
            if (!XmlBuilder.this.atLeast(Version.v11)) {
                return Collections.emptyMap();
            }
            Function<ConstructorType, Class[]> params = ct -> (Class[])ct.getParameter().stream().map(ParameterType::getType).map(XmlBuilder.this::resolveClass).toArray(Class[]::new);
            Function<ConstructorType, Signature> signature = ct -> new Signature(((Class)meta.getHost()).getName(), (Class[])params.apply((ConstructorType)ct));
            return this.descriptor.getConstructor().stream().collect(Collectors.toMap(signature, x$0 -> new ForConstructor((ConstructorType)x$0)));
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> meta) {
            if (!XmlBuilder.this.atLeast(Version.v11)) {
                return Collections.emptyMap();
            }
            Function<MethodType, Class[]> params = mt -> (Class[])mt.getParameter().stream().map(ParameterType::getType).map(XmlBuilder.this::resolveClass).toArray(Class[]::new);
            Function<MethodType, Signature> signature = mt -> new Signature(mt.getName(), (Class[])params.apply((MethodType)mt));
            return this.descriptor.getMethod().stream().collect(Collectors.toMap(signature, x$0 -> new ForMethod((MethodType)x$0)));
        }

        @Override
        public final AnnotationBehavior getAnnotationBehavior() {
            return this.descriptor.getIgnoreAnnotations() != false ? AnnotationBehavior.EXCLUDE : AnnotationBehavior.INCLUDE;
        }
    }

    public static enum Version {
        v10("1.0"),
        v11("1.1"),
        v20("2.0");

        private final String id;

        static Version of(ConstraintMappingsType constraintMappings) {
            Validate.notNull(constraintMappings);
            String version = constraintMappings.getVersion();
            if (StringUtils.isBlank(version)) {
                return v10;
            }
            version = version.trim();
            for (Version candidate : Version.values()) {
                if (!candidate.id.equals(version)) continue;
                return candidate;
            }
            throw new ValidationException("Unknown schema version: " + version);
        }

        private Version(String number) {
            this.id = number;
        }

        public String getId() {
            return this.id;
        }
    }
}

