/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.ElementKind;
import javax.validation.ParameterNameProvider;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.CompositeBuilder;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.EmptyBuilder;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.jsr.metadata.HierarchyBuilder$org_apache_bval_util_reflection_Reflection$$hierarchy$$Ljava_lang_Class$Lorg_apache_bval_util_reflection_Reflection$Interfaces$_ACTION;
import org.apache.bval.jsr.metadata.Liskov;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.Proxies;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class HierarchyBuilder
extends CompositeBuilder {
    private final Function<Class<?>, MetadataBuilder.ForBean<?>> getBeanBuilder;

    public HierarchyBuilder(ApacheValidatorFactory validatorFactory, Function<Class<?>, MetadataBuilder.ForBean<?>> getBeanBuilder) {
        super(validatorFactory, AnnotationBehaviorMergeStrategy.first());
        this.getBeanBuilder = Validate.notNull(getBeanBuilder, "getBeanBuilder function was null", new Object[0]);
    }

    public <T> MetadataBuilder.ForBean<T> forBean(Class<T> beanClass) {
        ArrayList<MetadataBuilder.ForBean> delegates = new ArrayList<MetadataBuilder.ForBean>();
        delegates.add(Optional.of(beanClass).map(this.getBeanBuilder).orElseGet(() -> EmptyBuilder.instance().forBean()));
        Iterator<Class<?>> hierarchy = HierarchyBuilder.org_apache_bval_util_reflection_Reflection$$hierarchy(beanClass, Reflection.Interfaces.INCLUDE).iterator();
        hierarchy.next();
        hierarchy.forEachRemaining(t -> Optional.of(t).filter(this::canValidate).map(this.getBeanBuilder).filter(b -> !b.isEmpty()).map(b -> new BeanDelegate(b, t)).ifPresent(delegates::add));
        if (delegates.size() == 1) {
            return (MetadataBuilder.ForBean)delegates.get(0);
        }
        return delegates.stream().map(MetadataBuilder.ForBean.class::cast).collect(this.compose());
    }

    @Privileged
    private static /* synthetic */ Iterable<Class<?>> org_apache_bval_util_reflection_Reflection$$hierarchy(Class<?> clazz, Reflection.Interfaces interfaces) {
        if (!(System.getSecurityManager() != null)) {
            return HierarchyBuilder.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, interfaces);
        }
        return (Iterable)AccessController.doPrivileged(new HierarchyBuilder$org_apache_bval_util_reflection_Reflection$$hierarchy$$Ljava_lang_Class$Lorg_apache_bval_util_reflection_Reflection$Interfaces$_ACTION(clazz, interfaces));
    }

    static /* synthetic */ Iterable __privileged_access$0(Class clazz, Reflection.Interfaces interfaces) {
        return HierarchyBuilder.__privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(clazz, interfaces);
    }

    private static /* synthetic */ Iterable<Class<?>> __privileged_org_apache_bval_util_reflection_Reflection$$hierarchy(Class<?> clazz, Reflection.Interfaces interfaces) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Reflection.ClassHierarchy classHierarchy = new Reflection.ClassHierarchy(clazz);
        return interfaces == Reflection.Interfaces.INCLUDE ? new Reflection.FullHierarchy(classHierarchy) : classHierarchy;
    }

    @Override
    protected <E extends AnnotatedElement> Map<Meta<E>, Annotation[]> getConstraintDeclarationMap(CompositeBuilder.ForElement<? extends MetadataBuilder.ForElement<E>, E> composite, Meta<E> meta) {
        Function<MetadataBuilder.ForElement, Meta> keyMapper = d -> Optional.of(d).filter(HierarchyDelegate.class::isInstance).map(HierarchyDelegate.class::cast).map(HierarchyDelegate::getHierarchyElement).orElse(meta);
        return composite.delegates.stream().collect(Collectors.toMap(keyMapper, d -> d.getDeclaredConstraints(meta), (u, v) -> (Annotation[])Stream.of(u, v).flatMap(Stream::of).toArray(Annotation[]::new), LinkedHashMap::new));
    }

    @Override
    protected <T> List<Class<?>> getGroupSequence(CompositeBuilder.ForClass<T> composite, Meta<Class<T>> meta) {
        return ((MetadataBuilder.ForClass)composite.delegates.get(0)).getGroupSequence(meta);
    }

    @Override
    protected <DELEGATE extends MetadataBuilder.ForContainer<E>, E extends AnnotatedElement> MetadataBuilder.ForContainer<E> forContainer(List<DELEGATE> delegates, Meta<E> meta, ElementKind elementKind) {
        if (delegates.isEmpty()) {
            return super.forContainer(delegates, meta, elementKind);
        }
        List hierarchyDelegates = delegates.stream().map(d -> d instanceof ContainerDelegate ? (ContainerDelegate)d : new ContainerDelegate(d, meta)).collect(Collectors.toList());
        ForContainer result = new ForContainer(hierarchyDelegates, elementKind);
        return result;
    }

    @Override
    protected <DELEGATE extends MetadataBuilder.ForElement<E>, E extends Executable> MetadataBuilder.ForElement<E> forCrossParameter(List<DELEGATE> delegates, Meta<E> meta) {
        if (delegates.isEmpty()) {
            return super.forCrossParameter(delegates, meta);
        }
        List hierarchyDelegates = delegates.stream().map(d -> d instanceof CrossParameterDelegate ? (CrossParameterDelegate)d : new CrossParameterDelegate(d, meta)).collect(Collectors.toList());
        return new ForCrossParameter(hierarchyDelegates);
    }

    private boolean canValidate(Class<?> t) {
        return !t.getName().startsWith("java.") && !Proxies.isProxyClass(t);
    }

    private class ForContainer<E extends AnnotatedElement>
    extends CompositeBuilder.ForContainer<ContainerDelegate<E>, E> {
        ForContainer(List<ContainerDelegate<E>> delegates, ElementKind elementKind) {
            super(delegates);
            Liskov.validateContainerHierarchy(delegates, Validate.notNull(elementKind, "elementKind", new Object[0]));
        }
    }

    private class ForCrossParameter<E extends Executable>
    extends CompositeBuilder.ForElement<CrossParameterDelegate<E>, E> {
        ForCrossParameter(List<CrossParameterDelegate<E>> delegates) {
            super(delegates);
            Liskov.validateCrossParameterHierarchy(delegates);
        }
    }

    private class CrossParameterDelegate<E extends Executable>
    extends ElementDelegate<E, MetadataBuilder.ForElement<E>>
    implements MetadataBuilder.ForElement<E> {
        CrossParameterDelegate(MetadataBuilder.ForElement<E> delegate, Meta<E> hierarchyElement) {
            super(delegate, hierarchyElement);
        }

        @Override
        public Annotation[] getDeclaredConstraints(Meta<E> meta) {
            return this.getDeclaredConstraints();
        }
    }

    private class ExecutableDelegate<E extends Executable>
    extends HierarchyDelegate<E, MetadataBuilder.ForExecutable<E>>
    implements MetadataBuilder.ForExecutable<E> {
        final BiFunction<ParameterNameProvider, E, List<String>> getParameterNames;

        ExecutableDelegate(MetadataBuilder.ForExecutable<E> delegate, Meta<E> hierarchyElement, BiFunction<ParameterNameProvider, E, List<String>> getParameterNames) {
            super(delegate, hierarchyElement);
            this.getParameterNames = Validate.notNull(getParameterNames, "getParameterNames", new Object[0]);
        }

        @Override
        public MetadataBuilder.ForContainer<E> getReturnValue(Meta<E> meta) {
            return new ContainerDelegate(((MetadataBuilder.ForExecutable)this.delegate).getReturnValue(this.hierarchyElement), this.hierarchyElement);
        }

        @Override
        public MetadataBuilder.ForElement<E> getCrossParameter(Meta<E> meta) {
            return new CrossParameterDelegate(((MetadataBuilder.ForExecutable)this.delegate).getCrossParameter(this.hierarchyElement), this.hierarchyElement);
        }

        @Override
        public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<E> meta) {
            List<MetadataBuilder.ForContainer<Parameter>> parameterDelegates = ((MetadataBuilder.ForExecutable)this.delegate).getParameters(this.hierarchyElement);
            if (parameterDelegates.isEmpty()) {
                return parameterDelegates;
            }
            List<Meta<Parameter>> metaParameters = HierarchyBuilder.this.getMetaParameters(this.hierarchyElement, this.getParameterNames);
            if (metaParameters.size() != parameterDelegates.size()) {
                Exceptions.raise(IllegalStateException::new, "Got wrong number of parameter delegates for %s", meta.getHost());
            }
            return IntStream.range(0, parameterDelegates.size()).mapToObj(n -> new ContainerDelegate((MetadataBuilder.ForContainer)parameterDelegates.get(n), (Meta)metaParameters.get(n))).collect(Collectors.toList());
        }
    }

    class ContainerDelegate<E extends AnnotatedElement>
    extends ElementDelegate<E, MetadataBuilder.ForContainer<E>>
    implements MetadataBuilder.ForContainer<E> {
        ContainerDelegate(MetadataBuilder.ForContainer<E> delegate, Meta<E> hierarchyElement) {
            super(delegate, hierarchyElement);
        }

        boolean isCascade() {
            return ((MetadataBuilder.ForContainer)this.delegate).isCascade(this.hierarchyElement);
        }

        @Override
        public final boolean isCascade(Meta<E> meta) {
            return this.isCascade();
        }

        Set<GroupConversion> getGroupConversions() {
            return ((MetadataBuilder.ForContainer)this.delegate).getGroupConversions(this.hierarchyElement);
        }

        @Override
        public final Set<GroupConversion> getGroupConversions(Meta<E> meta) {
            return this.getGroupConversions();
        }

        @Override
        public Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> meta) {
            Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> containerElementTypes = ((MetadataBuilder.ForContainer)this.delegate).getContainerElementTypes(this.hierarchyElement);
            LinkedHashMap<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> result = new LinkedHashMap<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>>();
            containerElementTypes.forEach((k, v) -> result.put((ContainerElementKey)k, (MetadataBuilder.ForContainer<AnnotatedType>)new ContainerDelegate<AnnotatedType>((MetadataBuilder.ForContainer<AnnotatedType>)v, new Meta.ForContainerElement(this.hierarchyElement, (ContainerElementKey)k))));
            return result;
        }

        @Override
        public Annotation[] getDeclaredConstraints(Meta<E> meta) {
            return this.getDeclaredConstraints();
        }
    }

    private class ClassDelegate<H, T extends H>
    extends ElementDelegate<Class<H>, MetadataBuilder.ForClass<H>>
    implements MetadataBuilder.ForClass<T> {
        ClassDelegate(MetadataBuilder.ForClass<H> delegate, Meta<Class<H>> hierarchyType) {
            super(delegate, hierarchyType);
        }

        @Override
        public List<Class<?>> getGroupSequence(Meta<Class<T>> meta) {
            return ((MetadataBuilder.ForClass)this.delegate).getGroupSequence(this.hierarchyElement);
        }

        @Override
        public Annotation[] getDeclaredConstraints(Meta<Class<T>> meta) {
            return this.getDeclaredConstraints();
        }
    }

    private class BeanDelegate<H, T extends H>
    extends HierarchyDelegate<Class<H>, MetadataBuilder.ForBean<H>>
    implements MetadataBuilder.ForBean<T> {
        BeanDelegate(MetadataBuilder.ForBean<H> delegate, Class<H> hierarchyType) {
            super(delegate, new Meta.ForClass<H>(hierarchyType));
        }

        @Override
        public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> meta) {
            return new ClassDelegate(((MetadataBuilder.ForBean)this.delegate).getClass(this.hierarchyElement), this.hierarchyElement);
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> meta) {
            Map<String, MetadataBuilder.ForContainer<Field>> fields = ((MetadataBuilder.ForBean)this.delegate).getFields(this.hierarchyElement);
            if (fields.isEmpty()) {
                return fields;
            }
            LinkedHashMap<String, MetadataBuilder.ForContainer<Field>> result = new LinkedHashMap<String, MetadataBuilder.ForContainer<Field>>();
            fields.forEach((k, v) -> {
                Field fld = Reflection.getDeclaredField((Class)this.hierarchyElement.getHost(), k);
                Exceptions.raiseIf(fld == null, IllegalStateException::new, "delegate builder specified unknown field", new Object[0]);
                result.put((String)k, (MetadataBuilder.ForContainer<Field>)new ContainerDelegate<Field>((MetadataBuilder.ForContainer<Field>)v, new Meta.ForField(fld)));
            });
            return result;
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> meta) {
            if (this.hierarchyElement.equals(meta)) {
                Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> result = ((MetadataBuilder.ForBean)this.delegate).getConstructors(meta);
                return result;
            }
            return Collections.emptyMap();
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> meta) {
            Map<String, MetadataBuilder.ForContainer<Method>> getters = ((MetadataBuilder.ForBean)this.delegate).getGetters(this.hierarchyElement);
            if (getters.isEmpty()) {
                return getters;
            }
            LinkedHashMap<String, MetadataBuilder.ForContainer<Method>> result = new LinkedHashMap<String, MetadataBuilder.ForContainer<Method>>();
            ArrayList delegates = new ArrayList();
            getters.forEach((k, v) -> {
                Method getter = Methods.getter((Class)this.hierarchyElement.getHost(), k);
                Exceptions.raiseIf(getter == null, IllegalStateException::new, "delegate builder specified unknown getter", new Object[0]);
                ContainerDelegate<Method> d = new ContainerDelegate<Method>((MetadataBuilder.ForContainer<Method>)v, new Meta.ForMethod(getter));
                result.put((String)k, (MetadataBuilder.ForContainer<Method>)d);
                delegates.add(d);
            });
            Liskov.validateValidateOnExecution(delegates);
            return result;
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> meta) {
            Map<Signature, MetadataBuilder.ForExecutable<Method>> methods = ((MetadataBuilder.ForBean)this.delegate).getMethods(this.hierarchyElement);
            if (methods.isEmpty()) {
                return methods;
            }
            LinkedHashMap<Signature, MetadataBuilder.ForExecutable<Method>> result = new LinkedHashMap<Signature, MetadataBuilder.ForExecutable<Method>>();
            ArrayList delegates = new ArrayList();
            methods.forEach((k, v) -> {
                ExecutableDelegate<Method> d = new ExecutableDelegate<Method>((MetadataBuilder.ForExecutable<Method>)v, new Meta.ForMethod(Reflection.getDeclaredMethod((Class)this.hierarchyElement.getHost(), k.getName(), k.getParameterTypes())), ParameterNameProvider::getParameterNames);
                result.put((Signature)k, (MetadataBuilder.ForExecutable<Method>)d);
                delegates.add(d);
            });
            Liskov.validateValidateOnExecution(delegates);
            return result;
        }
    }

    static abstract class ElementDelegate<E extends AnnotatedElement, T extends MetadataBuilder.ForElement<E>>
    extends HierarchyDelegate<E, T> {
        ElementDelegate(T delegate, Meta<E> hierarchyElement) {
            super(delegate, hierarchyElement);
        }

        Annotation[] getDeclaredConstraints() {
            return ((MetadataBuilder.ForElement)this.delegate).getDeclaredConstraints(this.hierarchyElement);
        }
    }

    static abstract class HierarchyDelegate<E extends AnnotatedElement, D extends HasAnnotationBehavior> {
        final D delegate;
        final Meta<E> hierarchyElement;

        HierarchyDelegate(D delegate, Meta<E> hierarchyElement) {
            this.delegate = (HasAnnotationBehavior)Validate.notNull(delegate, "delegate", new Object[0]);
            this.hierarchyElement = Validate.notNull(hierarchyElement, "hierarchyElement", new Object[0]);
        }

        Meta<E> getHierarchyElement() {
            return this.hierarchyElement;
        }
    }
}

