/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Objects;
import javax.validation.Path;
import javax.validation.ValidationException;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public class GraphContext {
    private final ApacheFactoryContext validatorContext;
    private final PathImpl path;
    private final Object value;
    private final GraphContext parent;

    public GraphContext(ApacheFactoryContext validatorContext, PathImpl path, Object value) {
        this(validatorContext, path, value, null);
    }

    private GraphContext(ApacheFactoryContext validatorContext, PathImpl path, Object value, GraphContext parent) {
        this.validatorContext = Validate.notNull(validatorContext, "validatorContext", new Object[0]);
        this.path = Validate.notNull(path, "path", new Object[0]);
        this.value = value;
        this.parent = parent;
    }

    public ApacheFactoryContext getValidatorContext() {
        return this.validatorContext;
    }

    public PathImpl getPath() {
        return PathImpl.copy(this.path);
    }

    public Object getValue() {
        return this.value;
    }

    public GraphContext child(NodeImpl node, Object value) {
        Validate.notNull(node, "node", new Object[0]);
        PathImpl p = PathImpl.copy(this.path);
        p.addNode(node);
        return new GraphContext(this.validatorContext, p, value, this);
    }

    public GraphContext child(Path p, Object value) {
        Validate.notNull(p, "Path", new Object[0]);
        PathImpl impl = PathImpl.of(p);
        Validate.isTrue(impl.isSubPathOf(this.path), "%s is not a subpath of %s", p, this.path);
        return new GraphContext(this.validatorContext, impl == p ? PathImpl.copy(impl) : impl, value, this);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isRecursive() {
        GraphContext c = this.parent;
        while (c != null) {
            if (c.value == this.value) {
                return true;
            }
            c = c.parent;
        }
        return false;
    }

    public GraphContext getParent() {
        return this.parent;
    }

    public String toString() {
        return String.format("%s: %s at '%s'", this.getClass().getSimpleName(), this.value, this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GraphContext other = (GraphContext)obj;
        return other.validatorContext == this.validatorContext && other.value == this.value && other.getPath().equals(this.path);
    }

    public int hashCode() {
        return Objects.hash(this.validatorContext, this.value, this.path);
    }

    public ContainerElementKey runtimeKey(ContainerElementKey key) {
        Validate.notNull(key);
        if (this.value != null) {
            Class<?> containerClass = key.getContainerClass();
            Class<?> runtimeType = this.value.getClass();
            if (!runtimeType.equals(containerClass)) {
                Exceptions.raiseUnless(containerClass.isAssignableFrom(runtimeType), ValidationException::new, "Value %s is not assignment-compatible with %s", this.value, containerClass);
                if (key.getTypeArgumentIndex() == null) {
                    return new ContainerElementKey(runtimeType, null);
                }
                Map<TypeVariable<?>, Type> typeArguments = TypeUtils.getTypeArguments(runtimeType, containerClass);
                Type type = typeArguments.get(containerClass.getTypeParameters()[key.getTypeArgumentIndex()]);
                while (type instanceof TypeVariable) {
                    TypeVariable var = (TypeVariable)type;
                    Type nextType = typeArguments.get(var);
                    if (nextType instanceof TypeVariable) {
                        type = nextType;
                        continue;
                    }
                    return ContainerElementKey.forTypeVariable(var);
                }
            }
        }
        return key;
    }
}

