/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import jakarta.servlet.DispatcherType;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee11.servlet.FilterHolder;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;

@ManagedObject(value="Filter Mappings")
public class FilterMapping
implements Dumpable {
    public static final int DEFAULT = 0;
    public static final int REQUEST = 1;
    public static final int FORWARD = 2;
    public static final int INCLUDE = 4;
    public static final int ERROR = 8;
    public static final int ASYNC = 16;
    public static final int ALL = 31;
    private int _dispatches = 0;
    private String _filterName;
    private FilterHolder _holder;
    private String[] _pathSpecs;
    private String[] _servletNames;

    public static DispatcherType dispatch(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return DispatcherType.REQUEST;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return DispatcherType.FORWARD;
        }
        if ("include".equalsIgnoreCase(type)) {
            return DispatcherType.INCLUDE;
        }
        if ("error".equalsIgnoreCase(type)) {
            return DispatcherType.ERROR;
        }
        if ("async".equalsIgnoreCase(type)) {
            return DispatcherType.ASYNC;
        }
        throw new IllegalArgumentException(type);
    }

    public static int dispatch(DispatcherType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DispatcherType.REQUEST -> 1;
            case DispatcherType.ASYNC -> 16;
            case DispatcherType.FORWARD -> 2;
            case DispatcherType.INCLUDE -> 4;
            case DispatcherType.ERROR -> 8;
        };
    }

    public static DispatcherType dispatch(int type) {
        return switch (type) {
            case 1 -> DispatcherType.REQUEST;
            case 16 -> DispatcherType.ASYNC;
            case 2 -> DispatcherType.FORWARD;
            case 4 -> DispatcherType.INCLUDE;
            case 8 -> DispatcherType.ERROR;
            default -> throw new IllegalArgumentException(Integer.toString(type));
        };
    }

    boolean appliesTo(String path, int type) {
        if (this.appliesTo(type)) {
            for (String pathSpec : this._pathSpecs) {
                if (pathSpec == null || !ServletPathSpec.match((String)pathSpec, (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    boolean appliesTo(int type) {
        if (this._dispatches == 0) {
            return type == 1 || type == 16 && this._holder != null && this._holder.isAsyncSupported();
        }
        return (this._dispatches & type) != 0;
    }

    public boolean appliesTo(DispatcherType t) {
        return this.appliesTo(FilterMapping.dispatch(t));
    }

    public boolean isDefaultDispatches() {
        return this._dispatches == 0;
    }

    @ManagedAttribute(value="filter name", readonly=true)
    public String getFilterName() {
        return this._filterName;
    }

    FilterHolder getFilterHolder() {
        return this._holder;
    }

    @ManagedAttribute(value="url patterns", readonly=true)
    public String[] getPathSpecs() {
        return this._pathSpecs;
    }

    public void setDispatcherTypes(EnumSet<DispatcherType> dispatcherTypes) {
        this._dispatches = 0;
        if (dispatcherTypes != null) {
            if (dispatcherTypes.contains(DispatcherType.ERROR)) {
                this._dispatches |= 8;
            }
            if (dispatcherTypes.contains(DispatcherType.FORWARD)) {
                this._dispatches |= 2;
            }
            if (dispatcherTypes.contains(DispatcherType.INCLUDE)) {
                this._dispatches |= 4;
            }
            if (dispatcherTypes.contains(DispatcherType.REQUEST)) {
                this._dispatches |= 1;
            }
            if (dispatcherTypes.contains(DispatcherType.ASYNC)) {
                this._dispatches |= 0x10;
            }
        }
    }

    public EnumSet<DispatcherType> getDispatcherTypes() {
        EnumSet<DispatcherType> dispatcherTypes = EnumSet.noneOf(DispatcherType.class);
        if ((this._dispatches & 8) == 8) {
            dispatcherTypes.add(DispatcherType.ERROR);
        }
        if ((this._dispatches & 2) == 2) {
            dispatcherTypes.add(DispatcherType.FORWARD);
        }
        if ((this._dispatches & 4) == 4) {
            dispatcherTypes.add(DispatcherType.INCLUDE);
        }
        if ((this._dispatches & 1) == 1) {
            dispatcherTypes.add(DispatcherType.REQUEST);
        }
        if ((this._dispatches & 0x10) == 16) {
            dispatcherTypes.add(DispatcherType.ASYNC);
        }
        return dispatcherTypes;
    }

    public void setDispatches(int dispatches) {
        this._dispatches = dispatches;
    }

    public void setFilterName(String filterName) {
        this._filterName = Objects.requireNonNull(filterName);
    }

    void setFilterHolder(FilterHolder holder) {
        this._holder = Objects.requireNonNull(holder);
        this.setFilterName(holder.getName());
    }

    public void setPathSpecs(String[] pathSpecs) {
        this._pathSpecs = pathSpecs;
    }

    public void setPathSpec(String pathSpec) {
        this._pathSpecs = new String[]{pathSpec};
    }

    @ManagedAttribute(value="servlet names", readonly=true)
    public String[] getServletNames() {
        return this._servletNames;
    }

    public void setServletNames(String[] servletNames) {
        this._servletNames = servletNames;
    }

    public void setServletName(String servletName) {
        this._servletNames = new String[]{servletName};
    }

    public String toString() {
        return String.valueOf(TypeUtil.asList((Object[])this._pathSpecs)) + "/" + String.valueOf(TypeUtil.asList((Object[])this._servletNames)) + "/" + String.valueOf(Arrays.stream(DispatcherType.values()).filter(this::appliesTo).collect(Collectors.toSet())) + "=>" + this._filterName;
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(String.valueOf(this)).append("\n");
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }
}

