/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class INList
implements Iterable<IN> {
    private EnvironmentImpl envImpl;
    private boolean enabled;
    private volatile boolean recalcInProgress;
    private volatile boolean recalcToggle;
    private boolean recalcConsistent;
    private AtomicLong recalcTotal;
    private final ConcurrentMap<IN, IN> ins;
    private AtomicLong nCachedUpperINs;
    private AtomicLong nCachedBINs;
    private AtomicLong nCachedBINDeltas;

    INList(EnvironmentImpl envImpl) {
        this.init(envImpl);
        this.ins = new ConcurrentHashMap<IN, IN>();
        this.enabled = false;
    }

    private void init(EnvironmentImpl environmentImpl) {
        this.envImpl = environmentImpl;
        this.recalcInProgress = false;
        this.recalcToggle = false;
        this.recalcConsistent = true;
        this.recalcTotal = new AtomicLong();
        this.nCachedUpperINs = new AtomicLong();
        this.nCachedBINs = new AtomicLong();
        this.nCachedBINDeltas = new AtomicLong();
    }

    public StatGroup loadStats() {
        StatGroup stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        long istat = this.nCachedUpperINs.get();
        long bstat = this.nCachedBINs.get();
        long bdstat = this.nCachedBINDeltas.get();
        new LongStat(stats, EvictorStatDefinition.CACHED_UPPER_INS, istat);
        new LongStat(stats, EvictorStatDefinition.CACHED_BINS, bstat);
        new LongStat(stats, EvictorStatDefinition.CACHED_BIN_DELTAS, bdstat);
        return stats;
    }

    private void verifyPrint(long istat, long bstat) {
        int numINs = 0;
        int numBINs = 0;
        for (IN theIN : this.ins.keySet()) {
            if (theIN instanceof BIN) {
                ++numBINs;
                continue;
            }
            ++numINs;
        }
        System.out.println("size=" + this.getSize() + " INcount=" + numINs + " BINCount=" + numBINs + " INstat=" + istat + " bstat=" + bstat);
    }

    public int getSize() {
        return this.ins.size();
    }

    public boolean contains(IN in) {
        return this.ins.containsKey(in);
    }

    public void enable() {
        assert (this.ins.isEmpty());
        assert (!this.enabled);
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void add(IN in) {
        IN oldValue;
        if (!this.enabled) {
            return;
        }
        if (in.isBIN()) {
            this.nCachedBINs.incrementAndGet();
            if (in.isBINDelta(false)) {
                this.nCachedBINDeltas.incrementAndGet();
            }
        } else {
            this.nCachedUpperINs.incrementAndGet();
        }
        if ((oldValue = this.ins.putIfAbsent(in, in)) != null) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Failed adding new IN node=" + in.getNodeId() + " dbIdentity=" + System.identityHashCode(in.getDatabase()) + " db=" + in.getDatabase().dumpString(0) + "\nExisting IN node=" + oldValue.getNodeId() + " dbIdentity=" + System.identityHashCode(oldValue.getDatabase()) + " db=" + oldValue.getDatabase().dumpString(0));
        }
        long size = in.getBudgetedMemorySize();
        this.memRecalcAdd(in, size);
        this.envImpl.getMemoryBudget().updateTreeMemoryUsage(size);
        in.setInListResident(true);
    }

    public void remove(IN in) {
        if (!this.enabled) {
            return;
        }
        boolean removed = this.removeInternal(in);
        assert (removed);
        long delta = 0L - in.getBudgetedMemorySize();
        this.memRecalcRemove(in, delta);
        this.envImpl.getMemoryBudget().updateTreeMemoryUsage(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInternal(IN in) {
        if (in.isBIN()) {
            this.nCachedBINs.decrementAndGet();
            if (in.isBINDelta(false)) {
                this.nCachedBINDeltas.decrementAndGet();
            }
        } else {
            this.nCachedUpperINs.decrementAndGet();
        }
        Evictor evictor = this.envImpl.getEvictor();
        boolean latchAcquired = false;
        if (!in.isLatchOwner()) {
            in.latch(CacheMode.UNCHANGED);
            latchAcquired = true;
        }
        try {
            evictor.remove(in);
            in.setInListResident(false);
            this.envImpl.getOffHeapCache().removeINFromMain(in);
        }
        finally {
            if (latchAcquired) {
                in.releaseLatch();
            }
        }
        IN oldValue = (IN)this.ins.remove(in);
        return oldValue != null;
    }

    public void updateBINDeltaStat(int incr) {
        this.nCachedBINDeltas.addAndGet(incr);
    }

    @Override
    public Iterator<IN> iterator() {
        return new Iter();
    }

    public void clear() {
        this.ins.clear();
        this.nCachedUpperINs.set(0L);
        this.nCachedBINs.set(0L);
        this.nCachedBINDeltas.set(0L);
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        mb.refreshTreeMemoryUsage(0L);
        mb.refreshTreeAdminMemoryUsage(0L);
    }

    public void dump() {
        System.out.println("size=" + this.getSize());
        for (IN theIN : this.ins.keySet()) {
            System.out.println("db=" + theIN.getDatabase().getId() + " nid=: " + theIN.getNodeId() + "/" + theIN.getLevel());
        }
    }

    public void memRecalcBegin() {
        this.recalcTotal.set(0L);
        this.recalcInProgress = true;
        this.recalcToggle = !this.recalcToggle;
    }

    public void memRecalcIterate(IN in) {
        assert (this.recalcInProgress);
        if (this.recalcConsistent && this.recalcToggle != in.getRecalcToggle()) {
            long delta = in.resetAndGetMemorySize();
            this.recalcTotal.addAndGet(delta);
        }
        in.setRecalcToggle(this.recalcToggle);
    }

    private void memRecalcAdd(IN in, long size) {
        if (this.recalcInProgress && this.recalcConsistent) {
            this.recalcTotal.addAndGet(size);
        }
        in.setRecalcToggle(this.recalcToggle);
    }

    private void memRecalcRemove(IN in, long delta) {
        this.memRecalcUpdate(in, delta);
    }

    public void memRecalcUpdate(IN in, long delta) {
        if (this.recalcInProgress && this.recalcConsistent && this.recalcToggle == in.getRecalcToggle()) {
            this.recalcTotal.addAndGet(delta);
        }
    }

    public void memRecalcEnd(boolean completed) {
        assert (this.recalcInProgress);
        if (completed && this.recalcConsistent) {
            this.envImpl.getMemoryBudget().refreshTreeMemoryUsage(this.recalcTotal.get());
        }
        this.recalcInProgress = false;
        this.recalcConsistent = completed;
    }

    private class Iter
    implements Iterator<IN> {
        private final Iterator<IN> baseIter;
        private IN next;
        private IN lastReturned;

        private Iter() {
            this.baseIter = INList.this.ins.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            return this.advance();
        }

        @Override
        public IN next() {
            if (this.next == null && !this.advance()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = null;
            return this.lastReturned;
        }

        private boolean advance() {
            while (this.baseIter.hasNext()) {
                IN in = this.baseIter.next();
                if (!in.getInListResident()) continue;
                this.next = in;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw EnvironmentFailureException.unexpectedState();
            }
            INList.this.removeInternal(this.lastReturned);
            this.lastReturned = null;
        }
    }
}

