/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jackson;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.jackson.BaseNodeDeserializer;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeFactory;
import tools.jackson.databind.node.ObjectNode;

public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    private static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class, null);
    }

    protected JsonNodeDeserializer(JsonNodeDeserializer base, boolean mergeArrays, boolean mergeObjects) {
        super(base, mergeArrays, mergeObjects);
    }

    @Override
    protected BaseNodeDeserializer<?> _createWithMerge(boolean mergeArrays, boolean mergeObjects) {
        return new JsonNodeDeserializer(this, mergeArrays, mergeObjects);
    }

    public static BaseNodeDeserializer<?> getDeserializer(Class<?> nodeClass) {
        if (nodeClass == ObjectNode.class) {
            return ObjectDeserializer.getInstance();
        }
        if (nodeClass == ArrayNode.class) {
            return ArrayDeserializer.getInstance();
        }
        return instance;
    }

    @Override
    public JsonNode getNullValue(DeserializationContext ctxt) {
        return ctxt.getNodeFactory().nullNode();
    }

    @Override
    public Object getAbsentValue(DeserializationContext ctxt) {
        return null;
    }

    @Override
    public JsonNode deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        BaseNodeDeserializer.ContainerStack stack = new BaseNodeDeserializer.ContainerStack();
        JsonNodeFactory nodeF = ctxt.getNodeFactory();
        JsonToken t = p.currentToken();
        if (t == JsonToken.START_OBJECT) {
            return this._deserializeContainerNoRecursion(p, ctxt, nodeF, stack, nodeF.objectNode());
        }
        if (t == JsonToken.START_ARRAY) {
            return this._deserializeContainerNoRecursion(p, ctxt, nodeF, stack, nodeF.arrayNode());
        }
        switch (p.currentTokenId()) {
            case 2: {
                return nodeF.objectNode();
            }
            case 5: {
                return this._deserializeObjectAtName(p, ctxt, nodeF, stack);
            }
        }
        return this._deserializeAnyScalar(p, ctxt);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return this._supportsUpdates;
    }

    static final class ObjectDeserializer
    extends BaseNodeDeserializer<ObjectNode> {
        protected static final ObjectDeserializer _instance = new ObjectDeserializer();

        protected ObjectDeserializer() {
            super(ObjectNode.class, true);
        }

        public static ObjectDeserializer getInstance() {
            return _instance;
        }

        protected ObjectDeserializer(ObjectDeserializer base, boolean mergeArrays, boolean mergeObjects) {
            super(base, mergeArrays, mergeObjects);
        }

        @Override
        protected BaseNodeDeserializer<?> _createWithMerge(boolean mergeArrays, boolean mergeObjects) {
            return new ObjectDeserializer(this, mergeArrays, mergeObjects);
        }

        @Override
        public ObjectNode deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            JsonNodeFactory nodeF = ctxt.getNodeFactory();
            if (p.isExpectedStartObjectToken()) {
                ObjectNode root = nodeF.objectNode();
                this._deserializeContainerNoRecursion(p, ctxt, nodeF, new BaseNodeDeserializer.ContainerStack(), root);
                return root;
            }
            if (p.hasToken(JsonToken.PROPERTY_NAME)) {
                return this._deserializeObjectAtName(p, ctxt, nodeF, new BaseNodeDeserializer.ContainerStack());
            }
            if (p.hasToken(JsonToken.END_OBJECT)) {
                return nodeF.objectNode();
            }
            return (ObjectNode)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }

        @Override
        public ObjectNode deserialize(JsonParser p, DeserializationContext ctxt, ObjectNode node) throws JacksonException {
            if (p.isExpectedStartObjectToken() || p.hasToken(JsonToken.PROPERTY_NAME)) {
                return (ObjectNode)this.updateObject(p, ctxt, node, new BaseNodeDeserializer.ContainerStack());
            }
            return (ObjectNode)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }
    }

    static final class ArrayDeserializer
    extends BaseNodeDeserializer<ArrayNode> {
        protected static final ArrayDeserializer _instance = new ArrayDeserializer();

        protected ArrayDeserializer() {
            super(ArrayNode.class, true);
        }

        public static ArrayDeserializer getInstance() {
            return _instance;
        }

        protected ArrayDeserializer(ArrayDeserializer base, boolean mergeArrays, boolean mergeObjects) {
            super(base, mergeArrays, mergeObjects);
        }

        @Override
        protected BaseNodeDeserializer<?> _createWithMerge(boolean mergeArrays, boolean mergeObjects) {
            return new ArrayDeserializer(this, mergeArrays, mergeObjects);
        }

        @Override
        public ArrayNode deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            if (p.isExpectedStartArrayToken()) {
                JsonNodeFactory nodeF = ctxt.getNodeFactory();
                ArrayNode arrayNode = nodeF.arrayNode();
                this._deserializeContainerNoRecursion(p, ctxt, nodeF, new BaseNodeDeserializer.ContainerStack(), arrayNode);
                return arrayNode;
            }
            return (ArrayNode)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }

        @Override
        public ArrayNode deserialize(JsonParser p, DeserializationContext ctxt, ArrayNode arrayNode) throws JacksonException {
            if (p.isExpectedStartArrayToken()) {
                this._deserializeContainerNoRecursion(p, ctxt, ctxt.getNodeFactory(), new BaseNodeDeserializer.ContainerStack(), arrayNode);
                return arrayNode;
            }
            return (ArrayNode)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
        }
    }
}

