/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.oxia.client.metrics.Unit;

public class UpDownCounter {
    private final LongUpDownCounter counter;
    private final Attributes attributes;

    UpDownCounter(Meter meter, String name, Unit unit, String description, String namespace, Attributes attributes) {
        LongUpDownCounterBuilder builder = meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit.toString());
        if (namespace != null) {
            attributes = attributes.toBuilder().put("oxia.namespace", namespace).build();
        }
        this.counter = builder.build();
        this.attributes = attributes;
    }

    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    public void add(long delta) {
        this.counter.add(delta, this.attributes);
    }

    public void subtract(long diff) {
        this.add(-diff);
    }
}

