/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.streams.impl.InboundBuffer;

abstract class VertxHttp2Stream<C extends Http2ConnectionBase> {
    private static final MultiMap EMPTY = new Http2HeadersAdaptor((Http2Headers)EmptyHttp2Headers.INSTANCE);
    protected final C conn;
    protected final VertxInternal vertx;
    protected final ContextInternal context;
    protected Http2Stream stream;
    private StreamPriority priority;
    private final InboundBuffer<Object> pending;
    private boolean writable;
    private long bytesRead;
    private long bytesWritten;
    private int writeInProgress = 0;
    protected boolean isConnect;

    VertxHttp2Stream(C conn, ContextInternal context) {
        this.conn = conn;
        this.vertx = ((Http2ConnectionBase)conn).vertx();
        this.context = context;
        this.pending = new InboundBuffer(context, 5L);
        this.priority = HttpUtils.DEFAULT_STREAM_PRIORITY;
        this.writable = true;
        this.isConnect = false;
        this.pending.handler(item -> {
            if (item instanceof MultiMap) {
                this.handleEnd((MultiMap)item);
            } else {
                Buffer data = (Buffer)item;
                int len = data.length();
                conn.getContext().emit(null, v -> {
                    if (this.stream.state().remoteSideOpen()) {
                        conn.consumeCredits(this.stream, len);
                    }
                });
                this.handleData(data);
            }
        });
        this.pending.exceptionHandler(context::reportException);
        this.pending.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Http2Stream stream) {
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            this.stream = stream;
            this.writable = ((Http2ConnectionBase)this.conn).handler.encoder().flowController().isWritable(stream);
        }
        stream.setProperty(((Http2ConnectionBase)this.conn).streamKey, (Object)this);
    }

    void onClose() {
        ((ConnectionBase)this.conn).flushBytesWritten();
        this.context.execute(ex -> this.handleClose());
    }

    void onException(Throwable cause) {
        this.context.emit(cause, this::handleException);
    }

    void onReset(long code) {
        this.context.emit(code, this::handleReset);
    }

    void onPriorityChange(StreamPriority newPriority) {
        this.context.emit(newPriority, priority -> {
            if (!this.priority.equals(priority)) {
                this.priority = priority;
                this.handlePriorityChange((StreamPriority)priority);
            }
        });
    }

    void onCustomFrame(HttpFrame frame) {
        this.context.emit(frame, this::handleCustomFrame);
    }

    void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
    }

    void onData(Buffer data) {
        this.bytesRead += (long)data.length();
        ((ConnectionBase)this.conn).reportBytesRead(data.length());
        this.context.execute(data, this.pending::write);
    }

    void onWritabilityChanged() {
        this.context.emit(null, v -> {
            boolean w;
            VertxHttp2Stream vertxHttp2Stream = this;
            synchronized (vertxHttp2Stream) {
                w = this.writable = !this.writable;
            }
            this.handleWritabilityChanged(w);
        });
    }

    void onEnd() {
        this.onEnd(EMPTY);
    }

    void onEnd(MultiMap trailers) {
        ((ConnectionBase)this.conn).flushBytesRead();
        this.context.emit(trailers, this.pending::write);
    }

    public int id() {
        return this.stream.id();
    }

    long bytesWritten() {
        return this.bytesWritten;
    }

    long bytesRead() {
        return this.bytesRead;
    }

    public void doPause() {
        this.pending.pause();
    }

    public void doFetch(long amount) {
        this.pending.fetch(amount);
    }

    public synchronized boolean isNotWritable() {
        return !this.writable;
    }

    public final void writeFrame(int type, int flags, ByteBuf payload) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).getContext().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteFrame(type, flags, payload);
        } else {
            eventLoop.execute(() -> this.doWriteFrame(type, flags, payload));
        }
    }

    private void doWriteFrame(int type, int flags, ByteBuf payload) {
        ((Http2ConnectionBase)this.conn).handler.writeFrame(this.stream, (byte)type, (short)flags, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeHeaders(Http2Headers headers, boolean end, boolean checkFlush, Handler<AsyncResult<Void>> handler) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).getContext().nettyEventLoop();
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            if (this.shouldQueue(eventLoop)) {
                this.queueForWrite(eventLoop, () -> this.doWriteHeaders(headers, end, checkFlush, handler));
                return;
            }
        }
        this.doWriteHeaders(headers, end, checkFlush, handler);
    }

    void doWriteHeaders(Http2Headers headers, boolean end, boolean checkFlush, Handler<AsyncResult<Void>> handler) {
        PromiseInternal<Void> promise;
        PromiseInternal<Void> promiseInternal = promise = handler == null ? null : this.context.promise(handler);
        if (end) {
            this.endWritten();
        }
        ((Http2ConnectionBase)this.conn).handler.writeHeaders(this.stream, headers, end, this.priority.getDependency(), this.priority.getWeight(), this.priority.isExclusive(), checkFlush, promise);
    }

    protected void endWritten() {
    }

    private void writePriorityFrame(StreamPriority priority) {
        ((Http2ConnectionBase)this.conn).handler.writePriority(this.stream, priority.getDependency(), priority.getWeight(), priority.isExclusive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeData(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
        ContextInternal ctx = ((ConnectionBase)this.conn).getContext();
        EventLoop eventLoop = ctx.nettyEventLoop();
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            if (this.shouldQueue(eventLoop)) {
                this.queueForWrite(eventLoop, () -> this.doWriteData(chunk, end, handler));
                return;
            }
        }
        this.doWriteData(chunk, end, handler);
    }

    protected boolean shouldQueue(EventLoop eventLoop) {
        return !eventLoop.inEventLoop() || this.writeInProgress > 0;
    }

    protected void queueForWrite(EventLoop eventLoop, Runnable action) {
        ++this.writeInProgress;
        eventLoop.execute(() -> {
            VertxHttp2Stream vertxHttp2Stream = this;
            synchronized (vertxHttp2Stream) {
                --this.writeInProgress;
            }
            action.run();
        });
    }

    void doWriteData(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> handler) {
        PromiseInternal<Void> promise;
        ByteBuf chunk = buf == null && end ? Unpooled.EMPTY_BUFFER : buf;
        int numOfBytes = chunk.readableBytes();
        this.bytesWritten += (long)numOfBytes;
        ((ConnectionBase)this.conn).reportBytesWritten(numOfBytes);
        PromiseInternal<Void> promiseInternal = promise = handler == null ? null : this.context.promise(handler);
        if (end) {
            this.endWritten();
        }
        ((Http2ConnectionBase)this.conn).handler.writeData(this.stream, chunk, end, promise);
    }

    final void writeReset(long code) {
        EventLoop eventLoop = ((ConnectionBase)this.conn).getContext().nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doWriteReset(code);
        } else {
            eventLoop.execute(() -> this.doWriteReset(code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteReset(long code) {
        int streamId;
        VertxHttp2Stream vertxHttp2Stream = this;
        synchronized (vertxHttp2Stream) {
            streamId = this.stream != null ? this.stream.id() : -1;
        }
        if (streamId != -1) {
            ((Http2ConnectionBase)this.conn).handler.writeReset(streamId, code);
        } else {
            this.handleReset(code);
        }
    }

    void handleWritabilityChanged(boolean writable) {
    }

    void handleData(Buffer buf) {
    }

    void handleCustomFrame(HttpFrame frame) {
    }

    void handleEnd(MultiMap trailers) {
    }

    void handleReset(long errorCode) {
    }

    void handleException(Throwable cause) {
    }

    void handleClose() {
    }

    synchronized void priority(StreamPriority streamPriority) {
        this.priority = streamPriority;
    }

    synchronized StreamPriority priority() {
        return this.priority;
    }

    synchronized void updatePriority(StreamPriority priority) {
        if (!this.priority.equals(priority)) {
            this.priority = priority;
            if (this.stream != null) {
                this.writePriorityFrame(priority);
            }
        }
    }

    void handlePriorityChange(StreamPriority newPriority) {
    }
}

