/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSheddingTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(LoadSheddingTask.class);
    private final AtomicReference<LoadManager> loadManager;
    private final ScheduledExecutorService loadManagerExecutor;
    private final ServiceConfiguration config;
    private volatile boolean isCancel = false;
    private volatile ScheduledFuture<?> future;

    public LoadSheddingTask(AtomicReference<LoadManager> loadManager, ScheduledExecutorService loadManagerExecutor, ServiceConfiguration config) {
        this.loadManager = loadManager;
        this.loadManagerExecutor = loadManagerExecutor;
        this.config = config;
    }

    @Override
    public void run() {
        if (this.isCancel) {
            return;
        }
        try {
            this.loadManager.get().doLoadShedding();
        }
        catch (Exception e) {
            LOG.warn("Error during the load shedding", (Throwable)e);
        }
        finally {
            this.start();
        }
    }

    public void start() {
        if (!this.isCancel && this.loadManagerExecutor != null && this.config != null) {
            this.future = this.loadManagerExecutor.schedule(this, (long)this.config.getLoadBalancerSheddingIntervalMinutes(), TimeUnit.MINUTES);
        }
    }

    public void cancel() {
        this.isCancel = true;
        if (this.future != null) {
            this.future.cancel(false);
        }
    }
}

