/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.PageCompletionListener;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;

public abstract class SwingPageRenderer
extends JPanel {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel controlPanel = new JPanel();
    private JButton backButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton finishButton = new JButton();
    private JPanel titlePanel = new JPanel();
    private JLabel titleLabel = new JLabel();
    private JLabel imagePanel = new JLabel();
    private GridLayout titleLayout = new GridLayout();
    protected Page page;
    protected SwingInstallerContext swingCtx;
    protected InstallerContext ctx;
    protected PageCompletionListener listener;
    private Border bevelBorder;
    private static Font titleFont = new JLabel().getFont();

    public void setPage(Page page) {
        block2: {
            this.page = page;
            try {
                this.jbInit();
            }
            catch (Exception e) {
                this.ctx.log(e.getMessage());
                if (!this.ctx.getInstaller().isVerbose()) break block2;
                this.ctx.log(e);
            }
        }
    }

    public void setContext(SwingInstallerContext swingCtx) {
        this.ctx = swingCtx.getInstallerContext();
        this.swingCtx = swingCtx;
    }

    private void jbInit() throws Exception {
        this.setDoubleBuffered(true);
        this.bevelBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(2, SizeConstants.LEFT_INDENT, 2, 2));
        this.bevelBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, SizeConstants.LEFT_INDENT, 2, 2));
        CompoundBorder tripleBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 4, 1, 4), this.bevelBorder);
        this.setLayout(this.borderLayout1);
        this.titleLabel.setBorder(tripleBorder);
        this.controlPanel.setBorder(tripleBorder);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.controlPanel, "South");
        this.titlePanel.add((Component)this.imagePanel, null);
        this.titlePanel.add((Component)this.titleLabel, null);
        this.titlePanel.setLayout(this.titleLayout);
        this.titleLayout.setColumns(1);
        this.titleLayout.setHgap(0);
        this.titleLayout.setRows(2);
        this.titleLayout.setVgap(2);
        this.titlePanel.setMinimumSize(new Dimension(SizeConstants.PAGE_WIDTH, SizeConstants.TITLE_PANEL_HEIGHT));
        this.titlePanel.setMaximumSize(new Dimension(SizeConstants.PAGE_WIDTH, SizeConstants.TITLE_PANEL_HEIGHT));
        this.titlePanel.setPreferredSize(new Dimension(SizeConstants.PAGE_WIDTH, SizeConstants.TITLE_PANEL_HEIGHT));
        this.titleLabel.setText(this.page.getDisplayText());
        this.titleLabel.setFont(titleFont);
        this.setImage(this.page.getImageResource());
        this.imagePanel.setMinimumSize(new Dimension(SizeConstants.PAGE_WIDTH, SizeConstants.TITLE_IMAGE_HEIGHT));
        this.imagePanel.setMaximumSize(new Dimension(SizeConstants.PAGE_WIDTH, SizeConstants.TITLE_IMAGE_HEIGHT));
        this.imagePanel.setPreferredSize(new Dimension(SizeConstants.PAGE_WIDTH, SizeConstants.TITLE_IMAGE_HEIGHT));
        this.controlPanel.add((Component)this.cancelButton, null);
        this.controlPanel.add((Component)this.backButton, null);
        this.controlPanel.add((Component)this.nextButton, null);
        this.controlPanel.add((Component)this.finishButton, null);
        this.backButton.setText(res.getString("backButton"));
        this.cancelButton.setText(res.getString("cancelButton"));
        this.nextButton.setText(res.getString("nextButton"));
        this.finishButton.setText(this.ctx.getInstaller().getFinishButtonText());
        this.finishButton.setEnabled(false);
        this.setEventListeners();
        this.setIcons();
    }

    public abstract void instanceInit() throws Exception;

    public abstract void updateInputFields();

    public abstract void updateDefaultValues();

    public abstract boolean validateFields() throws ValidationException;

    public void setPageCompletionListener(PageCompletionListener listener) {
        this.listener = listener;
    }

    private void setImage(String resource) throws Exception {
        if (resource == null) {
            resource = this.ctx.getInstaller().getDefaultImageResource();
        }
        ImageIcon icon = this.getImage(resource);
        this.imagePanel.setIcon(icon);
    }

    protected ImageIcon getImage(String resource) {
        block4: {
            try {
                if (resource != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream in = this.getClass().getResourceAsStream(resource);
                    byte[] buffer = new byte[2048];
                    int read = -1;
                    while ((read = in.read(buffer)) != -1) {
                        baos.write(buffer, 0, read);
                    }
                    ImageIcon icon = new ImageIcon(baos.toByteArray());
                    return icon;
                }
            }
            catch (Exception ex) {
                this.ctx.log("Can't load image resource:" + resource);
                if (!this.ctx.getInstaller().isVerbose()) break block4;
                this.ctx.log(ex);
            }
        }
        return null;
    }

    private void setEventListeners() {
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingPageRenderer.this.listener.pageBack(SwingPageRenderer.this.page);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingPageRenderer.this.page.setAbort(true);
                if (SwingPageRenderer.this.ctx.getInstaller().isVerbose()) {
                    SwingPageRenderer.this.ctx.log("Abort called");
                }
                SwingPageRenderer.this.listener.pageComplete(SwingPageRenderer.this.page);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingPageRenderer.this.listener.pageComplete(SwingPageRenderer.this.page);
            }
        });
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SwingPageRenderer.this.finishButton.getText().equals(res.getString("exit"))) {
                    System.exit(0);
                }
                SwingPageRenderer.this.listener.pageComplete(SwingPageRenderer.this.page);
            }
        });
    }

    private void setIcons() {
        this.backButton.setIcon(this.getImage("/resources/icons/back.png"));
        this.cancelButton.setIcon(this.getImage("/resources/icons/cancel.png"));
        this.nextButton.setIcon(this.getImage("/resources/icons/next.png"));
        this.finishButton.setIcon(this.getImage("/resources/icons/finish.png"));
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public InstallerContext getCtx() {
        return this.ctx;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public JLabel getImagePanel() {
        return this.imagePanel;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    static {
        try {
            titleFont = new Font(titleFont.getFamily(), 1, 14);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

