/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
package org.apache.jetspeed.portletcontainer.tags;

import java.io.IOException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portletcontainer.Constants;
import org.apache.regexp.*;

/**
 ** Supporting class for the <CODE>URIParameter</CODE> tag.
 ** Adds a parameter to the just created URI.
 ** Only to be used within <CODE>createURI</CODE> or <CODE>createReturnURI</CODE>.
 ** Tag parameter:
 ** <UL>
 ** <LI><CODE>name</CODE> (mandatory) - the name of the parameter to add
 ** <LI><CODE>value</CODE> (mandatory) - the value of the parameter to add
 ** </UL>
 **
 ** @see   CreateURITag
 ** @see   CreateReturnURITag
 **
 ** @author   <a href="mailto:h.schwarz@de.ibm.com">Hagen Schwarz</a>
 **/
public class URIParameterTag extends TagSupport {   

    /**
     * Processes the <CODE>URIParameter</CODE> tag. Uses the variable <CODE>portletURI</CODE>.
     * @return <CODE>SKIP_BODY</CODE>
     */
    public int doStartTag ()
    {
        PortletResponse portletResponse = (PortletResponse)pageContext.getRequest().getAttribute(Constants.PORTLET_RESPONSE);
        PortletURI portletURI = (PortletURI)pageContext.getAttribute("portletURI");   //get URI
       
        if (portletURI != null)   
            portletURI.addParameter(iName, iValue);   //modify URI
       
        pageContext.setAttribute ("portletURI", portletURI);   //set URI

        return SKIP_BODY;
    }


    private String iName;
    /**
    * The setter for the <CODE>name</CODE> parameter.
    * @param aName java.lang.String
    */
    public void setName(String aName)
    {
        iName = aName;
    }

    private String iValue;
    /**
    * The setter for the <CODE>value</CODE> parameter.
    * @param aValue java.lang.String
    */
    public void setValue(String aValue)
    {
        iValue = aValue;
    }

}