package org.apache.jetspeed.portlet.event;

import org.apache.jetspeed.portlet.PortletException;

/**
 * The <CODE>ActionListener</CODE> interface is an addition to the
 * <CODE>Portlet</CODE> interface. If an object wishes to receive action events
 * in the portlet, this interface has to be implemented additionally to the
 * <CODE>Portlet</CODE> interface.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see ActionEvent
 */
public interface ActionListener
{
    /**
     ** Notifies this listener that the action which
     ** the listener is watching for has been performed.
     **
     ** @param   event
     **          the action event
     **
     ** @exception   PortletException
     **              if the listener has trouble fulfilling the
     **              request
     **/

    public void actionPerformed (ActionEvent event) throws PortletException;
}