package org.apache.jetspeed.portletcontainer.util;

// jetspeed
import org.apache.jetspeed.portletcontainer.*;

// turbine
import org.apache.turbine.util.Log;

import com.ibm.wps.util.ObjectID;

// java
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

public class CookieConverter
{

    public static javax.servlet.http.Cookie decode(ObjectID namespace,
                                                   javax.servlet.http.Cookie cookie)
    {
        javax.servlet.http.Cookie newCookie = 
            new javax.servlet.http.Cookie(PortletNamespaceMapper.decode(namespace,
                                                                        cookie.getName()),
                                          cookie.getValue());
        newCookie.setVersion(cookie.getVersion());
        newCookie.setSecure(cookie.getSecure());
        if (cookie.getPath()!=null)     newCookie.setPath(cookie.getPath());
        newCookie.setMaxAge(cookie.getMaxAge());
        if (cookie.getDomain()!=null)   newCookie.setDomain(cookie.getDomain());
        if (cookie.getComment()!=null)  newCookie.setComment(cookie.getComment());
        
        return newCookie;
    }

    public static javax.servlet.http.Cookie encode(ObjectID namespace,
                                                   javax.servlet.http.Cookie cookie)
    {
        javax.servlet.http.Cookie newCookie = 
            new javax.servlet.http.Cookie(PortletNamespaceMapper.encode(namespace,
                                                                        cookie.getName()),
                                          cookie.getValue());
        newCookie.setVersion(cookie.getVersion());
        newCookie.setSecure(cookie.getSecure());
        if (cookie.getPath()!=null)     newCookie.setPath(cookie.getPath());
        newCookie.setMaxAge(cookie.getMaxAge());
        if (cookie.getDomain()!=null)   newCookie.setDomain(cookie.getDomain());
        if (cookie.getComment()!=null)  newCookie.setComment(cookie.getComment());

        return newCookie;
    }

}
