package org.apache.jetspeed.portletcontainer.event;

import org.apache.jetspeed.portlet.*;
import org.apache.jetspeed.portlet.event.*;
import org.apache.jetspeed.portletcontainer.*;
import org.apache.jetspeed.portletcontainer.util.*;
import org.apache.jetspeed.portletcontainer.om.applicationregistry.ConcreteApplicationEntry;
import org.apache.jetspeed.portletcontainer.om.portletregistry.*;
import org.apache.jetspeed.portletcontainer.invoker.PortletInvokerException;
import org.apache.jetspeed.portletcontainer.information.PortalInformationProvider;

// turbine
import org.apache.turbine.util.Log;

public class PortletApplicationSettingsAttributeEventImpl
extends EventImpl implements PortletApplicationSettingsAttributeEvent
{
    public static final int SETTING_ADDED = 1;
    public static final int SETTING_REPLACED = 2;
    public static final int SETTING_REMOVED = 3;

    private int type = -1;
    private ConcretePortletEntry concretePortlet = null;
    private PortletApplicationSettings applicationSettings = null;
    private PortalInformationProvider provider = null;
    private String attributeName = null;
    private String attributeValue = null;

    public PortletApplicationSettingsAttributeEventImpl( int type,
                                                         ConcretePortletEntry concretePortlet,
                                                         PortalInformationProvider provider,
                                                         String attributeName,
                                                         String attributeValue )
    {
        super( null );

        this.type = type;
        this.concretePortlet = concretePortlet;
        this.provider = provider;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }


    public PortletApplicationSettings getApplicationSettings()
    {
        if (this.applicationSettings!=null)
        {
            this.applicationSettings = new PortletApplicationSettingsImpl( concretePortlet,
                                                                           provider );
        }
        return this.applicationSettings;
    }

    public String getName()
    {
        return attributeName;
    }

    public String getValue()
    {
        return attributeValue;
    }

    // additonal methods

    public int getType()
    {
        return type;
    }

    public void prepare(EventEnvironment evtEnv) throws PortletException, PortletInvokerException
    {
        // do nothing
    }

}