package org.apache.jetspeed.portlet.event;

import java.lang.Object;
import java.lang.String;

import org.apache.jetspeed.portlet.*;

/**
 * This is the event class for notifications about changes to the attributes
 * of the settings of a concrete portlet application.
 * 
 * @author <A HREF="mailto:shesmer@apache.org">Stephan Hesmer</A>
 * @see PortletSettingsAttributesListener
 * @since Version 1.1
 */
public interface PortletApplicationSettingsAttributeEvent extends Event
{

    /**
     * Return the PortletApplicationSettings that changed.
     * 
     * @return The PortletApplicationSettings that sent the event.
     */
    public PortletApplicationSettings getApplicationSettings();

    /**
     * Return the name of the attribute that changed on the PortletApplicationSettings.
     * 
     * @return the name of the attribute
     */
    public String getName();

    /**
     * Returns the value of the attribute being added removed or replaced. If the
     * attribute was added, this is the value of the attribute. If the attrubute was
     * removed, this is the value of the removed attribute. If the attribute
     * was replaced, this is the old value of the attribute.
     * 
     * @return The value of the attribute
     */
    public String getValue();

}