/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.portals.applications.webcontent2.proxy.command;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.portals.applications.webcontent2.proxy.ProxyContext;
import org.apache.portals.applications.webcontent2.proxy.impl.SimpleProxyMapping;
import org.junit.Test;

public class AddCookiesToResponseCommandTest
{

    @Test
    public void testGetReverseCookiePath() throws Exception
    {
        AddCookiesToResponseCommand command = new AddCookiesToResponseCommand();

        ProxyContext proxyContext = new ProxyContext(null);

        SimpleProxyMapping mapping = new SimpleProxyMapping();
        mapping.setLocal("/apache/portals/");
        mapping.setRemote(URI.create("http://portals.apache.org/"));
        proxyContext.setResolvedMapping(mapping);

        proxyContext.setLocalPath("/apache/portals/docs/mission.html");
        proxyContext.setRemoteURI(URI.create("http://portals.apache.org/docs/mission.html"));

        BasicClientCookie cookie = new BasicClientCookie("MYSESSIONID", "1234567890");
        cookie.setPath("/");

        String reverseCookiePath = command.getReverseCookiePath(proxyContext, cookie);
        assertEquals("/apache/portals/", reverseCookiePath);

        cookie = new BasicClientCookie("MYSESSIONID", "1234567890");
        cookie.setPath("/docs/");

        reverseCookiePath = command.getReverseCookiePath(proxyContext, cookie);
        assertEquals("/apache/portals/docs/", reverseCookiePath);
    }
}
