/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"
	"strconv"
	"strings"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/s7/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type S7XmlParserHelper struct {
}

// Temporary imports to silent compiler warnings (TODO: migrate from static to emission based imports)
func init() {
	_ = strconv.ParseUint
	_ = strconv.ParseInt
	_ = strings.Join
	_ = utils.Dump
}

func (m S7XmlParserHelper) Parse(typeName string, xmlString string, parserArguments ...string) (any, error) {
	switch typeName {
	case "SzlId":
		return SzlIdParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageObjectAckType":
		return AlarmMessageObjectAckTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7Parameter":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		messageType := uint8(parsedUint0)
		return S7ParameterParseWithBuffer[S7Parameter](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), messageType)
	case "S7DataAlarmMessage":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 4)
		if err != nil {
			return nil, err
		}
		cpuFunctionType := uint8(parsedUint0)
		return S7DataAlarmMessageParseWithBuffer[S7DataAlarmMessage](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), cpuFunctionType)
	case "S7PayloadUserDataItem":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 4)
		if err != nil {
			return nil, err
		}
		cpuFunctionGroup := uint8(parsedUint0)
		parsedUint1, err := strconv.ParseUint(parserArguments[1], 10, 4)
		if err != nil {
			return nil, err
		}
		cpuFunctionType := uint8(parsedUint1)
		parsedUint2, err := strconv.ParseUint(parserArguments[2], 10, 8)
		if err != nil {
			return nil, err
		}
		cpuSubfunction := uint8(parsedUint2)
		return S7PayloadUserDataItemParseWithBuffer[S7PayloadUserDataItem](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), cpuFunctionGroup, cpuFunctionType, cpuSubfunction)
	case "AlarmMessageObjectPushType":
		return AlarmMessageObjectPushTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessagePushType":
		return AlarmMessagePushTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageAckObjectPushType":
		return AlarmMessageAckObjectPushTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7Payload":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		messageType := uint8(parsedUint0)
		// TODO: find a way to parse the sub types
		var parameter S7Parameter
		return S7PayloadParseWithBuffer[S7Payload](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), messageType, parameter)
	case "S7Address":
		return S7AddressParseWithBuffer[S7Address](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "DataItem":
		// TODO: find a way to parse the sub types
		var dataProtocolId string
		controllerType, _ := ControllerTypeByName(parserArguments[1])
		parsedInt2, err := strconv.ParseInt(parserArguments[2], 10, 32)
		if err != nil {
			return nil, err
		}
		stringLength := int32(parsedInt2)
		return DataItemParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), dataProtocolId, controllerType, stringLength)
	case "SubItem":
		return SubItemParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "CycServiceItemType":
		return CycServiceItemTypeParseWithBuffer[CycServiceItemType](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageAckPushType":
		return AlarmMessageAckPushTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7Message":
		return S7MessageParseWithBuffer[S7Message](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7VarPayloadStatusItem":
		return S7VarPayloadStatusItemParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "SzlDataTreeItem":
		return SzlDataTreeItemParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AssociatedQueryValueType":
		return AssociatedQueryValueTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "COTPPacket":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 16)
		if err != nil {
			return nil, err
		}
		cotpLen := uint16(parsedUint0)
		return COTPPacketParseWithBuffer[COTPPacket](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), cotpLen)
	case "DateAndTime":
		return DateAndTimeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "COTPParameter":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		rest := uint8(parsedUint0)
		return COTPParameterParseWithBuffer[COTPParameter](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), rest)
	case "State":
		return StateParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "TPKTPacket":
		return TPKTPacketParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "Alarm8MessageQueryType":
		return Alarm8MessageQueryTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageAckType":
		return AlarmMessageAckTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AssociatedValueType":
		return AssociatedValueTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7VarRequestParameterItem":
		return S7VarRequestParameterItemParseWithBuffer[S7VarRequestParameterItem](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7VarPayloadDataItem":
		return S7VarPayloadDataItemParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageQueryType":
		return AlarmMessageQueryTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageAckResponseType":
		return AlarmMessageAckResponseTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "AlarmMessageObjectQueryType":
		return AlarmMessageObjectQueryTypeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "S7ParameterUserDataItem":
		return S7ParameterUserDataItemParseWithBuffer[S7ParameterUserDataItem](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
