/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SortOrderType is an enum
type SortOrderType uint32

type ISortOrderType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	SortOrderType_sortOrderTypeAscending  SortOrderType = 0
	SortOrderType_sortOrderTypeDescending SortOrderType = 1
)

var SortOrderTypeValues []SortOrderType

func init() {
	_ = errors.New
	SortOrderTypeValues = []SortOrderType{
		SortOrderType_sortOrderTypeAscending,
		SortOrderType_sortOrderTypeDescending,
	}
}

func SortOrderTypeByValue(value uint32) (enum SortOrderType, ok bool) {
	switch value {
	case 0:
		return SortOrderType_sortOrderTypeAscending, true
	case 1:
		return SortOrderType_sortOrderTypeDescending, true
	}
	return 0, false
}

func SortOrderTypeByName(value string) (enum SortOrderType, ok bool) {
	switch value {
	case "sortOrderTypeAscending":
		return SortOrderType_sortOrderTypeAscending, true
	case "sortOrderTypeDescending":
		return SortOrderType_sortOrderTypeDescending, true
	}
	return 0, false
}

func SortOrderTypeKnows(value uint32) bool {
	for _, typeValue := range SortOrderTypeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastSortOrderType(structType any) SortOrderType {
	castFunc := func(typ any) SortOrderType {
		if sSortOrderType, ok := typ.(SortOrderType); ok {
			return sSortOrderType
		}
		return 0
	}
	return castFunc(structType)
}

func (m SortOrderType) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m SortOrderType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SortOrderTypeParse(ctx context.Context, theBytes []byte) (SortOrderType, error) {
	return SortOrderTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func SortOrderTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (SortOrderType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("SortOrderType", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading SortOrderType")
	}
	if enum, ok := SortOrderTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for SortOrderType")
		return SortOrderType(val), nil
	} else {
		return enum, nil
	}
}

func (e SortOrderType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e SortOrderType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("SortOrderType", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e SortOrderType) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e SortOrderType) PLC4XEnumName() string {
	switch e {
	case SortOrderType_sortOrderTypeAscending:
		return "sortOrderTypeAscending"
	case SortOrderType_sortOrderTypeDescending:
		return "sortOrderTypeDescending"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e SortOrderType) String() string {
	return e.PLC4XEnumName()
}
