/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipConnectionManagerCloseResponse extends CipService implements Message {

  // Accessors for discriminator values.
  public Byte getService() {
    return (byte) 0x4E;
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  public Boolean getConnected() {
    return false;
  }

  // Properties.
  protected final short status;
  protected final short additionalStatusWords;
  protected final int connectionSerialNumber;
  protected final int originatorVendorId;
  protected final long originatorSerialNumber;
  protected final short applicationReplySize;

  public CipConnectionManagerCloseResponse(
      short status,
      short additionalStatusWords,
      int connectionSerialNumber,
      int originatorVendorId,
      long originatorSerialNumber,
      short applicationReplySize) {
    super();
    this.status = status;
    this.additionalStatusWords = additionalStatusWords;
    this.connectionSerialNumber = connectionSerialNumber;
    this.originatorVendorId = originatorVendorId;
    this.originatorSerialNumber = originatorSerialNumber;
    this.applicationReplySize = applicationReplySize;
  }

  public short getStatus() {
    return status;
  }

  public short getAdditionalStatusWords() {
    return additionalStatusWords;
  }

  public int getConnectionSerialNumber() {
    return connectionSerialNumber;
  }

  public int getOriginatorVendorId() {
    return originatorVendorId;
  }

  public long getOriginatorSerialNumber() {
    return originatorSerialNumber;
  }

  public short getApplicationReplySize() {
    return applicationReplySize;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CipConnectionManagerCloseResponse");

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (status)
    writeSimpleField("status", status, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (additionalStatusWords)
    writeSimpleField(
        "additionalStatusWords", additionalStatusWords, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (connectionSerialNumber)
    writeSimpleField(
        "connectionSerialNumber", connectionSerialNumber, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (originatorVendorId)
    writeSimpleField("originatorVendorId", originatorVendorId, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (originatorSerialNumber)
    writeSimpleField(
        "originatorSerialNumber", originatorSerialNumber, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (applicationReplySize)
    writeSimpleField(
        "applicationReplySize", applicationReplySize, writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("CipConnectionManagerCloseResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipConnectionManagerCloseResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (status)
    lengthInBits += 8;

    // Simple field (additionalStatusWords)
    lengthInBits += 8;

    // Simple field (connectionSerialNumber)
    lengthInBits += 16;

    // Simple field (originatorVendorId)
    lengthInBits += 16;

    // Simple field (originatorSerialNumber)
    lengthInBits += 32;

    // Simple field (applicationReplySize)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static CipServiceBuilder staticParseCipServiceBuilder(
      ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
    readBuffer.pullContext("CipConnectionManagerCloseResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    short status = readSimpleField("status", readUnsignedShort(readBuffer, 8));

    short additionalStatusWords =
        readSimpleField("additionalStatusWords", readUnsignedShort(readBuffer, 8));

    int connectionSerialNumber =
        readSimpleField("connectionSerialNumber", readUnsignedInt(readBuffer, 16));

    int originatorVendorId = readSimpleField("originatorVendorId", readUnsignedInt(readBuffer, 16));

    long originatorSerialNumber =
        readSimpleField("originatorSerialNumber", readUnsignedLong(readBuffer, 32));

    short applicationReplySize =
        readSimpleField("applicationReplySize", readUnsignedShort(readBuffer, 8));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    readBuffer.closeContext("CipConnectionManagerCloseResponse");
    // Create the instance
    return new CipConnectionManagerCloseResponseBuilderImpl(
        status,
        additionalStatusWords,
        connectionSerialNumber,
        originatorVendorId,
        originatorSerialNumber,
        applicationReplySize);
  }

  public static class CipConnectionManagerCloseResponseBuilderImpl
      implements CipService.CipServiceBuilder {
    private final short status;
    private final short additionalStatusWords;
    private final int connectionSerialNumber;
    private final int originatorVendorId;
    private final long originatorSerialNumber;
    private final short applicationReplySize;

    public CipConnectionManagerCloseResponseBuilderImpl(
        short status,
        short additionalStatusWords,
        int connectionSerialNumber,
        int originatorVendorId,
        long originatorSerialNumber,
        short applicationReplySize) {
      this.status = status;
      this.additionalStatusWords = additionalStatusWords;
      this.connectionSerialNumber = connectionSerialNumber;
      this.originatorVendorId = originatorVendorId;
      this.originatorSerialNumber = originatorSerialNumber;
      this.applicationReplySize = applicationReplySize;
    }

    public CipConnectionManagerCloseResponse build() {
      CipConnectionManagerCloseResponse cipConnectionManagerCloseResponse =
          new CipConnectionManagerCloseResponse(
              status,
              additionalStatusWords,
              connectionSerialNumber,
              originatorVendorId,
              originatorSerialNumber,
              applicationReplySize);
      return cipConnectionManagerCloseResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipConnectionManagerCloseResponse)) {
      return false;
    }
    CipConnectionManagerCloseResponse that = (CipConnectionManagerCloseResponse) o;
    return (getStatus() == that.getStatus())
        && (getAdditionalStatusWords() == that.getAdditionalStatusWords())
        && (getConnectionSerialNumber() == that.getConnectionSerialNumber())
        && (getOriginatorVendorId() == that.getOriginatorVendorId())
        && (getOriginatorSerialNumber() == that.getOriginatorSerialNumber())
        && (getApplicationReplySize() == that.getApplicationReplySize())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStatus(),
        getAdditionalStatusWords(),
        getConnectionSerialNumber(),
        getOriginatorVendorId(),
        getOriginatorSerialNumber(),
        getApplicationReplySize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
