/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTimestamps is an enum
type OpcuaNodeIdServicesVariableTimestamps int32

type IOpcuaNodeIdServicesVariableTimestamps interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTimestamps_TimestampsToReturn_EnumStrings OpcuaNodeIdServicesVariableTimestamps = 7606
)

var OpcuaNodeIdServicesVariableTimestampsValues []OpcuaNodeIdServicesVariableTimestamps

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTimestampsValues = []OpcuaNodeIdServicesVariableTimestamps{
		OpcuaNodeIdServicesVariableTimestamps_TimestampsToReturn_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableTimestampsByValue(value int32) (enum OpcuaNodeIdServicesVariableTimestamps, ok bool) {
	switch value {
	case 7606:
		return OpcuaNodeIdServicesVariableTimestamps_TimestampsToReturn_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTimestampsByName(value string) (enum OpcuaNodeIdServicesVariableTimestamps, ok bool) {
	switch value {
	case "TimestampsToReturn_EnumStrings":
		return OpcuaNodeIdServicesVariableTimestamps_TimestampsToReturn_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTimestampsKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTimestampsValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTimestamps(structType any) OpcuaNodeIdServicesVariableTimestamps {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTimestamps {
		if sOpcuaNodeIdServicesVariableTimestamps, ok := typ.(OpcuaNodeIdServicesVariableTimestamps); ok {
			return sOpcuaNodeIdServicesVariableTimestamps
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTimestamps) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTimestamps) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTimestampsParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTimestamps, error) {
	return OpcuaNodeIdServicesVariableTimestampsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTimestampsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTimestamps, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTimestamps", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTimestamps")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTimestampsByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTimestamps")
		return OpcuaNodeIdServicesVariableTimestamps(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTimestamps) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTimestamps) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTimestamps", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableTimestamps) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTimestamps) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTimestamps_TimestampsToReturn_EnumStrings:
		return "TimestampsToReturn_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTimestamps) String() string {
	return e.PLC4XEnumName()
}
