/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMUpdateKeyUpdateControlFlags is the corresponding interface of NLMUpdateKeyUpdateControlFlags
type NLMUpdateKeyUpdateControlFlags interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetSet1KeyRevisionActivationTimeExpirationTimePresent returns Set1KeyRevisionActivationTimeExpirationTimePresent (property field)
	GetSet1KeyRevisionActivationTimeExpirationTimePresent() bool
	// GetSet1KeyCountKeyParametersPresent returns Set1KeyCountKeyParametersPresent (property field)
	GetSet1KeyCountKeyParametersPresent() bool
	// GetSet1ShouldBeCleared returns Set1ShouldBeCleared (property field)
	GetSet1ShouldBeCleared() bool
	// GetSet2KeyRevisionActivationTimeExpirationTimePresent returns Set2KeyRevisionActivationTimeExpirationTimePresent (property field)
	GetSet2KeyRevisionActivationTimeExpirationTimePresent() bool
	// GetSet2KeyCountKeyParametersPresent returns Set2KeyCountKeyParametersPresent (property field)
	GetSet2KeyCountKeyParametersPresent() bool
	// GetSet2ShouldBeCleared returns Set2ShouldBeCleared (property field)
	GetSet2ShouldBeCleared() bool
	// GetMoreMessagesToBeExpected returns MoreMessagesToBeExpected (property field)
	GetMoreMessagesToBeExpected() bool
	// GetRemoveAllKeys returns RemoveAllKeys (property field)
	GetRemoveAllKeys() bool
	// IsNLMUpdateKeyUpdateControlFlags is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMUpdateKeyUpdateControlFlags()
	// CreateBuilder creates a NLMUpdateKeyUpdateControlFlagsBuilder
	CreateNLMUpdateKeyUpdateControlFlagsBuilder() NLMUpdateKeyUpdateControlFlagsBuilder
}

// _NLMUpdateKeyUpdateControlFlags is the data-structure of this message
type _NLMUpdateKeyUpdateControlFlags struct {
	Set1KeyRevisionActivationTimeExpirationTimePresent bool
	Set1KeyCountKeyParametersPresent                   bool
	Set1ShouldBeCleared                                bool
	Set2KeyRevisionActivationTimeExpirationTimePresent bool
	Set2KeyCountKeyParametersPresent                   bool
	Set2ShouldBeCleared                                bool
	MoreMessagesToBeExpected                           bool
	RemoveAllKeys                                      bool
}

var _ NLMUpdateKeyUpdateControlFlags = (*_NLMUpdateKeyUpdateControlFlags)(nil)

// NewNLMUpdateKeyUpdateControlFlags factory function for _NLMUpdateKeyUpdateControlFlags
func NewNLMUpdateKeyUpdateControlFlags(set1KeyRevisionActivationTimeExpirationTimePresent bool, set1KeyCountKeyParametersPresent bool, set1ShouldBeCleared bool, set2KeyRevisionActivationTimeExpirationTimePresent bool, set2KeyCountKeyParametersPresent bool, set2ShouldBeCleared bool, moreMessagesToBeExpected bool, removeAllKeys bool) *_NLMUpdateKeyUpdateControlFlags {
	return &_NLMUpdateKeyUpdateControlFlags{Set1KeyRevisionActivationTimeExpirationTimePresent: set1KeyRevisionActivationTimeExpirationTimePresent, Set1KeyCountKeyParametersPresent: set1KeyCountKeyParametersPresent, Set1ShouldBeCleared: set1ShouldBeCleared, Set2KeyRevisionActivationTimeExpirationTimePresent: set2KeyRevisionActivationTimeExpirationTimePresent, Set2KeyCountKeyParametersPresent: set2KeyCountKeyParametersPresent, Set2ShouldBeCleared: set2ShouldBeCleared, MoreMessagesToBeExpected: moreMessagesToBeExpected, RemoveAllKeys: removeAllKeys}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMUpdateKeyUpdateControlFlagsBuilder is a builder for NLMUpdateKeyUpdateControlFlags
type NLMUpdateKeyUpdateControlFlagsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(set1KeyRevisionActivationTimeExpirationTimePresent bool, set1KeyCountKeyParametersPresent bool, set1ShouldBeCleared bool, set2KeyRevisionActivationTimeExpirationTimePresent bool, set2KeyCountKeyParametersPresent bool, set2ShouldBeCleared bool, moreMessagesToBeExpected bool, removeAllKeys bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithSet1KeyRevisionActivationTimeExpirationTimePresent adds Set1KeyRevisionActivationTimeExpirationTimePresent (property field)
	WithSet1KeyRevisionActivationTimeExpirationTimePresent(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithSet1KeyCountKeyParametersPresent adds Set1KeyCountKeyParametersPresent (property field)
	WithSet1KeyCountKeyParametersPresent(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithSet1ShouldBeCleared adds Set1ShouldBeCleared (property field)
	WithSet1ShouldBeCleared(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithSet2KeyRevisionActivationTimeExpirationTimePresent adds Set2KeyRevisionActivationTimeExpirationTimePresent (property field)
	WithSet2KeyRevisionActivationTimeExpirationTimePresent(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithSet2KeyCountKeyParametersPresent adds Set2KeyCountKeyParametersPresent (property field)
	WithSet2KeyCountKeyParametersPresent(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithSet2ShouldBeCleared adds Set2ShouldBeCleared (property field)
	WithSet2ShouldBeCleared(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithMoreMessagesToBeExpected adds MoreMessagesToBeExpected (property field)
	WithMoreMessagesToBeExpected(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// WithRemoveAllKeys adds RemoveAllKeys (property field)
	WithRemoveAllKeys(bool) NLMUpdateKeyUpdateControlFlagsBuilder
	// Build builds the NLMUpdateKeyUpdateControlFlags or returns an error if something is wrong
	Build() (NLMUpdateKeyUpdateControlFlags, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMUpdateKeyUpdateControlFlags
}

// NewNLMUpdateKeyUpdateControlFlagsBuilder() creates a NLMUpdateKeyUpdateControlFlagsBuilder
func NewNLMUpdateKeyUpdateControlFlagsBuilder() NLMUpdateKeyUpdateControlFlagsBuilder {
	return &_NLMUpdateKeyUpdateControlFlagsBuilder{_NLMUpdateKeyUpdateControlFlags: new(_NLMUpdateKeyUpdateControlFlags)}
}

type _NLMUpdateKeyUpdateControlFlagsBuilder struct {
	*_NLMUpdateKeyUpdateControlFlags

	collectedErr []error
}

var _ (NLMUpdateKeyUpdateControlFlagsBuilder) = (*_NLMUpdateKeyUpdateControlFlagsBuilder)(nil)

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithMandatoryFields(set1KeyRevisionActivationTimeExpirationTimePresent bool, set1KeyCountKeyParametersPresent bool, set1ShouldBeCleared bool, set2KeyRevisionActivationTimeExpirationTimePresent bool, set2KeyCountKeyParametersPresent bool, set2ShouldBeCleared bool, moreMessagesToBeExpected bool, removeAllKeys bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	return b.WithSet1KeyRevisionActivationTimeExpirationTimePresent(set1KeyRevisionActivationTimeExpirationTimePresent).WithSet1KeyCountKeyParametersPresent(set1KeyCountKeyParametersPresent).WithSet1ShouldBeCleared(set1ShouldBeCleared).WithSet2KeyRevisionActivationTimeExpirationTimePresent(set2KeyRevisionActivationTimeExpirationTimePresent).WithSet2KeyCountKeyParametersPresent(set2KeyCountKeyParametersPresent).WithSet2ShouldBeCleared(set2ShouldBeCleared).WithMoreMessagesToBeExpected(moreMessagesToBeExpected).WithRemoveAllKeys(removeAllKeys)
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithSet1KeyRevisionActivationTimeExpirationTimePresent(set1KeyRevisionActivationTimeExpirationTimePresent bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.Set1KeyRevisionActivationTimeExpirationTimePresent = set1KeyRevisionActivationTimeExpirationTimePresent
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithSet1KeyCountKeyParametersPresent(set1KeyCountKeyParametersPresent bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.Set1KeyCountKeyParametersPresent = set1KeyCountKeyParametersPresent
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithSet1ShouldBeCleared(set1ShouldBeCleared bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.Set1ShouldBeCleared = set1ShouldBeCleared
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithSet2KeyRevisionActivationTimeExpirationTimePresent(set2KeyRevisionActivationTimeExpirationTimePresent bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.Set2KeyRevisionActivationTimeExpirationTimePresent = set2KeyRevisionActivationTimeExpirationTimePresent
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithSet2KeyCountKeyParametersPresent(set2KeyCountKeyParametersPresent bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.Set2KeyCountKeyParametersPresent = set2KeyCountKeyParametersPresent
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithSet2ShouldBeCleared(set2ShouldBeCleared bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.Set2ShouldBeCleared = set2ShouldBeCleared
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithMoreMessagesToBeExpected(moreMessagesToBeExpected bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.MoreMessagesToBeExpected = moreMessagesToBeExpected
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) WithRemoveAllKeys(removeAllKeys bool) NLMUpdateKeyUpdateControlFlagsBuilder {
	b.RemoveAllKeys = removeAllKeys
	return b
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) Build() (NLMUpdateKeyUpdateControlFlags, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NLMUpdateKeyUpdateControlFlags.deepCopy(), nil
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) MustBuild() NLMUpdateKeyUpdateControlFlags {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMUpdateKeyUpdateControlFlagsBuilder) DeepCopy() any {
	_copy := b.CreateNLMUpdateKeyUpdateControlFlagsBuilder().(*_NLMUpdateKeyUpdateControlFlagsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNLMUpdateKeyUpdateControlFlagsBuilder creates a NLMUpdateKeyUpdateControlFlagsBuilder
func (b *_NLMUpdateKeyUpdateControlFlags) CreateNLMUpdateKeyUpdateControlFlagsBuilder() NLMUpdateKeyUpdateControlFlagsBuilder {
	if b == nil {
		return NewNLMUpdateKeyUpdateControlFlagsBuilder()
	}
	return &_NLMUpdateKeyUpdateControlFlagsBuilder{_NLMUpdateKeyUpdateControlFlags: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMUpdateKeyUpdateControlFlags) GetSet1KeyRevisionActivationTimeExpirationTimePresent() bool {
	return m.Set1KeyRevisionActivationTimeExpirationTimePresent
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetSet1KeyCountKeyParametersPresent() bool {
	return m.Set1KeyCountKeyParametersPresent
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetSet1ShouldBeCleared() bool {
	return m.Set1ShouldBeCleared
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetSet2KeyRevisionActivationTimeExpirationTimePresent() bool {
	return m.Set2KeyRevisionActivationTimeExpirationTimePresent
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetSet2KeyCountKeyParametersPresent() bool {
	return m.Set2KeyCountKeyParametersPresent
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetSet2ShouldBeCleared() bool {
	return m.Set2ShouldBeCleared
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetMoreMessagesToBeExpected() bool {
	return m.MoreMessagesToBeExpected
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetRemoveAllKeys() bool {
	return m.RemoveAllKeys
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMUpdateKeyUpdateControlFlags(structType any) NLMUpdateKeyUpdateControlFlags {
	if casted, ok := structType.(NLMUpdateKeyUpdateControlFlags); ok {
		return casted
	}
	if casted, ok := structType.(*NLMUpdateKeyUpdateControlFlags); ok {
		return *casted
	}
	return nil
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetTypeName() string {
	return "NLMUpdateKeyUpdateControlFlags"
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (set1KeyRevisionActivationTimeExpirationTimePresent)
	lengthInBits += 1

	// Simple field (set1KeyCountKeyParametersPresent)
	lengthInBits += 1

	// Simple field (set1ShouldBeCleared)
	lengthInBits += 1

	// Simple field (set2KeyRevisionActivationTimeExpirationTimePresent)
	lengthInBits += 1

	// Simple field (set2KeyCountKeyParametersPresent)
	lengthInBits += 1

	// Simple field (set2ShouldBeCleared)
	lengthInBits += 1

	// Simple field (moreMessagesToBeExpected)
	lengthInBits += 1

	// Simple field (removeAllKeys)
	lengthInBits += 1

	return lengthInBits
}

func (m *_NLMUpdateKeyUpdateControlFlags) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NLMUpdateKeyUpdateControlFlagsParse(ctx context.Context, theBytes []byte) (NLMUpdateKeyUpdateControlFlags, error) {
	return NLMUpdateKeyUpdateControlFlagsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func NLMUpdateKeyUpdateControlFlagsParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (NLMUpdateKeyUpdateControlFlags, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (NLMUpdateKeyUpdateControlFlags, error) {
		return NLMUpdateKeyUpdateControlFlagsParseWithBuffer(ctx, readBuffer)
	}
}

func NLMUpdateKeyUpdateControlFlagsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (NLMUpdateKeyUpdateControlFlags, error) {
	v, err := (&_NLMUpdateKeyUpdateControlFlags{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_NLMUpdateKeyUpdateControlFlags) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__nLMUpdateKeyUpdateControlFlags NLMUpdateKeyUpdateControlFlags, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMUpdateKeyUpdateControlFlags"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMUpdateKeyUpdateControlFlags")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	set1KeyRevisionActivationTimeExpirationTimePresent, err := ReadSimpleField(ctx, "set1KeyRevisionActivationTimeExpirationTimePresent", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1KeyRevisionActivationTimeExpirationTimePresent' field"))
	}
	m.Set1KeyRevisionActivationTimeExpirationTimePresent = set1KeyRevisionActivationTimeExpirationTimePresent

	set1KeyCountKeyParametersPresent, err := ReadSimpleField(ctx, "set1KeyCountKeyParametersPresent", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1KeyCountKeyParametersPresent' field"))
	}
	m.Set1KeyCountKeyParametersPresent = set1KeyCountKeyParametersPresent

	set1ShouldBeCleared, err := ReadSimpleField(ctx, "set1ShouldBeCleared", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set1ShouldBeCleared' field"))
	}
	m.Set1ShouldBeCleared = set1ShouldBeCleared

	set2KeyRevisionActivationTimeExpirationTimePresent, err := ReadSimpleField(ctx, "set2KeyRevisionActivationTimeExpirationTimePresent", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2KeyRevisionActivationTimeExpirationTimePresent' field"))
	}
	m.Set2KeyRevisionActivationTimeExpirationTimePresent = set2KeyRevisionActivationTimeExpirationTimePresent

	set2KeyCountKeyParametersPresent, err := ReadSimpleField(ctx, "set2KeyCountKeyParametersPresent", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2KeyCountKeyParametersPresent' field"))
	}
	m.Set2KeyCountKeyParametersPresent = set2KeyCountKeyParametersPresent

	set2ShouldBeCleared, err := ReadSimpleField(ctx, "set2ShouldBeCleared", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'set2ShouldBeCleared' field"))
	}
	m.Set2ShouldBeCleared = set2ShouldBeCleared

	moreMessagesToBeExpected, err := ReadSimpleField(ctx, "moreMessagesToBeExpected", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'moreMessagesToBeExpected' field"))
	}
	m.MoreMessagesToBeExpected = moreMessagesToBeExpected

	removeAllKeys, err := ReadSimpleField(ctx, "removeAllKeys", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'removeAllKeys' field"))
	}
	m.RemoveAllKeys = removeAllKeys

	if closeErr := readBuffer.CloseContext("NLMUpdateKeyUpdateControlFlags"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMUpdateKeyUpdateControlFlags")
	}

	return m, nil
}

func (m *_NLMUpdateKeyUpdateControlFlags) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMUpdateKeyUpdateControlFlags) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("NLMUpdateKeyUpdateControlFlags"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for NLMUpdateKeyUpdateControlFlags")
	}

	if err := WriteSimpleField[bool](ctx, "set1KeyRevisionActivationTimeExpirationTimePresent", m.GetSet1KeyRevisionActivationTimeExpirationTimePresent(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'set1KeyRevisionActivationTimeExpirationTimePresent' field")
	}

	if err := WriteSimpleField[bool](ctx, "set1KeyCountKeyParametersPresent", m.GetSet1KeyCountKeyParametersPresent(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'set1KeyCountKeyParametersPresent' field")
	}

	if err := WriteSimpleField[bool](ctx, "set1ShouldBeCleared", m.GetSet1ShouldBeCleared(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'set1ShouldBeCleared' field")
	}

	if err := WriteSimpleField[bool](ctx, "set2KeyRevisionActivationTimeExpirationTimePresent", m.GetSet2KeyRevisionActivationTimeExpirationTimePresent(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'set2KeyRevisionActivationTimeExpirationTimePresent' field")
	}

	if err := WriteSimpleField[bool](ctx, "set2KeyCountKeyParametersPresent", m.GetSet2KeyCountKeyParametersPresent(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'set2KeyCountKeyParametersPresent' field")
	}

	if err := WriteSimpleField[bool](ctx, "set2ShouldBeCleared", m.GetSet2ShouldBeCleared(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'set2ShouldBeCleared' field")
	}

	if err := WriteSimpleField[bool](ctx, "moreMessagesToBeExpected", m.GetMoreMessagesToBeExpected(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'moreMessagesToBeExpected' field")
	}

	if err := WriteSimpleField[bool](ctx, "removeAllKeys", m.GetRemoveAllKeys(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'removeAllKeys' field")
	}

	if popErr := writeBuffer.PopContext("NLMUpdateKeyUpdateControlFlags"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for NLMUpdateKeyUpdateControlFlags")
	}
	return nil
}

func (m *_NLMUpdateKeyUpdateControlFlags) IsNLMUpdateKeyUpdateControlFlags() {}

func (m *_NLMUpdateKeyUpdateControlFlags) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMUpdateKeyUpdateControlFlags) deepCopy() *_NLMUpdateKeyUpdateControlFlags {
	if m == nil {
		return nil
	}
	_NLMUpdateKeyUpdateControlFlagsCopy := &_NLMUpdateKeyUpdateControlFlags{
		m.Set1KeyRevisionActivationTimeExpirationTimePresent,
		m.Set1KeyCountKeyParametersPresent,
		m.Set1ShouldBeCleared,
		m.Set2KeyRevisionActivationTimeExpirationTimePresent,
		m.Set2KeyCountKeyParametersPresent,
		m.Set2ShouldBeCleared,
		m.MoreMessagesToBeExpected,
		m.RemoveAllKeys,
	}
	return _NLMUpdateKeyUpdateControlFlagsCopy
}

func (m *_NLMUpdateKeyUpdateControlFlags) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
