/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.basic;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openmeetings.db.entity.basic.Client;

public abstract class StreamDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected final ConcurrentHashMap.KeySetView<Client.Activity, Boolean> activities = ConcurrentHashMap.newKeySet();
    private final Client client;
    private final String uid;
    private final Client.StreamType type;
    private int width;
    private int height;

    protected StreamDesc(StreamDesc sd) {
        this.client = sd.client;
        this.uid = sd.uid;
        this.type = sd.type;
        this.width = sd.width;
        this.height = sd.height;
        this.activities.addAll((Collection<Client.Activity>)sd.activities);
    }

    protected StreamDesc(Client client, Client.StreamType type) {
        this.client = client;
        this.uid = UUID.randomUUID().toString();
        this.type = type;
    }

    protected abstract boolean allowed(Client.Activity var1);

    public boolean has(Client.Activity a) {
        return this.activities.contains((Object)a);
    }

    public void add(Client.Activity a) {
        if (this.allowed(a)) {
            this.activities.add(a);
        }
    }

    public StreamDesc remove(Client.Activity a) {
        this.activities.remove((Object)a);
        return this;
    }

    public List<Client.Activity> getActivities() {
        return List.copyOf(this.activities);
    }

    public Client getClient() {
        return this.client;
    }

    public String getSid() {
        return this.client.getSid();
    }

    public String getUid() {
        return this.uid;
    }

    public Client.StreamType getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public StreamDesc setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public StreamDesc setHeight(int height) {
        this.height = height;
        return this;
    }

    public String toString() {
        return String.format("Stream[uid=%s,type=%s,activities=%s]", new Object[]{this.uid, this.type, this.activities});
    }

    public JSONObject toJson() {
        return this.toJson(false);
    }

    public JSONObject toJson(boolean self) {
        JSONObject o = new JSONObject().put("uid", (Object)this.uid).put("type", (Object)this.type.name()).put("width", this.width).put("height", this.height).put("activities", (Object)new JSONArray(this.activities)).put("cuid", (Object)this.client.getUid());
        return this.client.addUserJson(this.client.addCamMic(self, o));
    }
}

