/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;

public enum DatabaseDialect {
    H2,
    POSTGRESQL,
    MYSQL,
    MICROSOFT_SQL_SERVER,
    ORACLE,
    OTHER;


    public static DatabaseDialect resolveDialect(DatabaseMetaData databaseMetaData) throws SQLException {
        String databaseProductName;
        switch (databaseProductName = databaseMetaData.getDatabaseProductName().toUpperCase(Locale.ROOT).trim()) {
            case "H2": {
                return H2;
            }
            case "POSTGRESQL": {
                return POSTGRESQL;
            }
            case "MYSQL": {
                return MYSQL;
            }
            case "MICROSOFT SQL SERVER": {
                return MICROSOFT_SQL_SERVER;
            }
            case "ORACLE": {
                return ORACLE;
            }
        }
        return OTHER;
    }
}

