/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.core.deserializer.batch.BatchBodyPart;
import org.apache.olingo.server.core.deserializer.batch.BatchLineReader;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;
import org.apache.olingo.server.core.deserializer.batch.BatchRequestTransformator;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BatchParser {
    private BatchOptions options;

    public List<BatchRequestPart> parseBatchRequest(InputStream content, String boundary, BatchOptions options) throws BatchDeserializerException {
        this.options = options;
        BatchRequestTransformator transformator = new BatchRequestTransformator(options.getRawBaseUri(), options.getRawServiceResolutionUri());
        return this.parse(content, boundary, transformator);
    }

    private List<BatchRequestPart> parse(InputStream in, String boundary, BatchRequestTransformator transformator) throws BatchDeserializerException {
        try {
            return this.parseBatch(in, boundary, transformator);
        }
        catch (IOException e) {
            throw new ODataRuntimeException((Exception)e);
        }
    }

    private List<BatchRequestPart> parseBatch(InputStream in, String boundary, BatchRequestTransformator transformator) throws IOException, BatchDeserializerException {
        LinkedList<BatchRequestPart> resultList = new LinkedList<BatchRequestPart>();
        List<List<Line>> bodyPartStrings = this.splitBodyParts(in, boundary);
        for (List<Line> bodyPartString : bodyPartStrings) {
            BatchBodyPart bodyPart = new BatchBodyPart(bodyPartString, boundary, this.options.isStrict()).parse();
            resultList.addAll(transformator.transform(bodyPart));
        }
        return resultList;
    }

    private List<List<Line>> splitBodyParts(InputStream in, String boundary) throws IOException, BatchDeserializerException {
        BatchLineReader reader = new BatchLineReader(in);
        List<Line> message = reader.toLineList();
        reader.close();
        return BatchParserCommon.splitMessageByBoundary(message, boundary);
    }
}

