/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;

public class EntitySetResponse
extends ServiceResponse {
    private final ODataSerializer serializer;
    private final EntityCollectionSerializerOptions options;
    private final ContentType responseContentType;

    private EntitySetResponse(ServiceMetadata metadata, ODataResponse response, ODataSerializer serializer, EntityCollectionSerializerOptions options, ContentType responseContentType, Map<String, String> preferences) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.options = options;
        this.responseContentType = responseContentType;
    }

    public static EntitySetResponse getInstance(ServiceRequest request, ContextURL contextURL, boolean referencesOnly, ODataResponse response) throws ContentNegotiatorException, SerializerException {
        EntityCollectionSerializerOptions options = request.getSerializerOptions(EntityCollectionSerializerOptions.class, contextURL, referencesOnly);
        return new EntitySetResponse(request.getServiceMetaData(), response, request.getSerializer(), options, request.getResponseContentType(), request.getPreferences());
    }

    public void writeReadEntitySet(EdmEntityType entityType, EntityCollection entitySet) throws SerializerException {
        assert (!this.isClosed());
        if (entitySet == null) {
            this.writeNotFound(true);
            return;
        }
        if (ContentTypeHelper.isODataMetadataFull((ContentType)this.responseContentType)) {
            this.buildOperations(entityType, entitySet);
        }
        this.response.setContent(this.serializer.entityCollection(this.metadata, entityType, (AbstractEntityCollection)entitySet, this.options).getContent());
        this.writeOK(this.responseContentType);
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataLibraryException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writeError(ODataServerError error) {
        try {
            this.writeHeader("Content-Type", this.responseContentType.toContentTypeString());
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }

    private void buildOperations(EdmEntityType entityType, EntityCollection entitySet) {
        EdmAction action = this.metadata.getEdm().getBoundActionWithBindingType(entityType.getFullQualifiedName(), Boolean.valueOf(true));
        if (action != null) {
            entitySet.getOperations().add(this.buildOperation(action, this.buildOperationTarget(this.options.getContextURL())));
        }
        if ((action = this.metadata.getEdm().getBoundActionWithBindingType(entityType.getFullQualifiedName(), Boolean.valueOf(false))) != null) {
            for (Entity entity : entitySet.getEntities()) {
                entity.getOperations().add(this.buildOperation(action, entity.getId().toASCIIString()));
            }
        }
        List functions = this.metadata.getEdm().getBoundFunctionsWithBindingType(entityType.getFullQualifiedName(), Boolean.valueOf(true));
        for (EdmFunction function : functions) {
            entitySet.getOperations().add(EntitySetResponse.buildOperation(function, this.buildOperationTarget(this.options.getContextURL())));
        }
        functions = this.metadata.getEdm().getBoundFunctionsWithBindingType(entityType.getFullQualifiedName(), Boolean.valueOf(false));
        for (Entity entity : entitySet.getEntities()) {
            for (EdmFunction function : functions) {
                entity.getOperations().add(EntitySetResponse.buildOperation(function, entity.getId().toASCIIString()));
            }
        }
    }

    private String buildOperationTarget(ContextURL contextURL) {
        StringBuilder result = new StringBuilder();
        if (contextURL.getServiceRoot() != null) {
            result.append(contextURL.getServiceRoot());
        }
        if (contextURL.getEntitySetOrSingletonOrType() != null) {
            if (result.length() != 0) {
                result.append("/");
            }
            result.append(Encoder.encode((String)contextURL.getEntitySetOrSingletonOrType()));
        }
        if (contextURL.getKeyPath() != null) {
            result.append('(').append(contextURL.getKeyPath()).append(')');
        }
        if (contextURL.getNavOrPropertyPath() != null) {
            result.append('/').append(contextURL.getNavOrPropertyPath());
        }
        return result.toString();
    }
}

