/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.client.api.communication.request.ODataBasicRequest;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamedRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.ODataFlushException;
import org.apache.olingo.ext.proxy.api.ODataResponseError;
import org.apache.olingo.ext.proxy.commons.AbstractPersistenceManager;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.PersistenceChanges;
import org.apache.olingo.ext.proxy.commons.TransactionItems;

public class NonTransactionalPersistenceManagerImpl
extends AbstractPersistenceManager {
    private static final long serialVersionUID = 5082907388513308752L;

    public NonTransactionalPersistenceManagerImpl(AbstractService<?> factory) {
        super(factory);
    }

    @Override
    protected void doFlush(PersistenceChanges changes, TransactionItems items) {
        HashMap<Integer, URI> responses = new HashMap<Integer, URI>();
        int index = 0;
        for (Map.Entry<ODataBatchableRequest, EntityInvocationHandler> entry : changes.getChanges().entrySet()) {
            ++index;
            ODataRequest request = (ODataRequest)ODataRequest.class.cast(entry.getKey());
            try {
                int slashIndex;
                Integer toBeReplaced;
                String uri = request.getURI().toASCIIString();
                if (uri.startsWith("$") && responses.containsKey(toBeReplaced = Integer.valueOf(uri.substring(1, (slashIndex = uri.indexOf(47)) < 0 ? uri.length() : slashIndex)))) {
                    uri = uri.replace("$" + toBeReplaced, ((URI)responses.get(toBeReplaced)).toASCIIString());
                    request.setURI(URI.create(uri));
                }
                ODataResponse response = ODataStreamedRequest.class.isAssignableFrom(request.getClass()) ? ((ODataStreamedRequest)request).payloadManager().getResponse() : ((ODataBasicRequest)request).execute();
                if (entry.getValue() != null && response instanceof ODataEntityCreateResponse && (response.getStatusCode() == 201 || response.getStatusCode() == 204)) {
                    if (response.getStatusCode() == 201) {
                        entry.getValue().setEntity(((ODataEntityCreateResponse)response).getBody());
                        responses.put(index, entry.getValue().getEntityURI());
                        LOG.debug("Upgrade created object '{}'", (Object)entry.getValue());
                        continue;
                    }
                    entry.getValue().applyChanges();
                    responses.put(index, null);
                    continue;
                }
                if (entry.getValue() != null && response instanceof ODataEntityUpdateResponse && (response.getStatusCode() == 200 || response.getStatusCode() == 204)) {
                    if (response.getStatusCode() == 200) {
                        entry.getValue().setEntity(((ODataEntityUpdateResponse)response).getBody());
                        responses.put(index, entry.getValue().getEntityURI());
                        LOG.debug("Upgrade updated object '{}'", (Object)entry.getValue());
                        continue;
                    }
                    entry.getValue().applyChanges();
                    responses.put(index, null);
                    continue;
                }
                responses.put(index, null);
            }
            catch (ODataRuntimeException e) {
                LOG.error("While performing {}", (Object)entry.getKey().getURI(), (Object)e);
                throw new ODataFlushException(0, Collections.singletonList(new ODataResponseError(e, index, request)));
            }
        }
    }
}

