/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.olingo.client.api.communication.request.retrieve.ODataValueRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractEntitySet;
import org.apache.olingo.ext.proxy.api.AbstractSingleton;
import org.apache.olingo.ext.proxy.api.EntityCollection;
import org.apache.olingo.ext.proxy.api.EntityType;
import org.apache.olingo.ext.proxy.api.Search;
import org.apache.olingo.ext.proxy.api.StructuredType;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.commons.AbstractEntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityCollectionInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntitySetIterator;
import org.apache.olingo.ext.proxy.commons.SearchImpl;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.context.EntityContext;
import org.apache.olingo.ext.proxy.context.EntityUUID;
import org.apache.olingo.ext.proxy.utils.ClassUtils;

public class EntitySetInvocationHandler<T extends EntityType<?>, KEY extends Serializable, EC extends EntityCollection<T, ?, ?>>
extends AbstractEntityCollectionInvocationHandler<T, EC>
implements AbstractEntitySet<T, KEY, EC> {
    private static final long serialVersionUID = 2629912294765040027L;

    public static EntitySetInvocationHandler getInstance(Class<?> ref, AbstractService<?> service) {
        return new EntitySetInvocationHandler(ref, service, EntitySetInvocationHandler.buildEntitySetURI(ref, service));
    }

    public static EntitySetInvocationHandler getInstance(Class<?> ref, AbstractService<?> service, URI uri) {
        return new EntitySetInvocationHandler(ref, service, service.getClient().newURIBuilder(uri.toASCIIString()));
    }

    protected EntitySetInvocationHandler(Class<?> ref, AbstractService<?> service, URIBuilder uri) {
        super(ref, service, uri);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("filter".equals(method.getName()) || "orderBy".equals(method.getName()) || "top".equals(method.getName()) || "skip".equals(method.getName()) || "expand".equals(method.getName()) || "select".equals(method.getName())) {
            this.invokeSelfMethod(method, args);
            return proxy;
        }
        if (this.isSelfMethod(method)) {
            return this.invokeSelfMethod(method, args);
        }
        throw new NoSuchMethodException(method.getName());
    }

    @Override
    public Long count() {
        ODataValueRequest req = this.getClient().getRetrieveRequestFactory().getValueRequest(this.getClient().newURIBuilder(this.uri.build().toASCIIString()).count().build());
        req.setFormat(ContentType.TEXT_PLAIN);
        return Long.valueOf(((ClientPrimitiveValue)((ODataRetrieveResponse)req.execute()).getBody()).asPrimitive().toString());
    }

    @Override
    public Boolean exists(KEY key) throws IllegalArgumentException {
        try {
            ((StructuredType)StructuredType.class.cast(this.getByKey(key))).load();
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not check existence of {}({})", new Object[]{this.uri, key, e});
            return false;
        }
    }

    @Override
    public T getByKey(KEY key) throws IllegalArgumentException {
        return (T)this.getByKey(key, this.itemRef);
    }

    @Override
    public <S extends T> S getByKey(KEY key, Class<S> typeRef) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        EntityUUID uuid = new EntityUUID(this.baseURI, typeRef, key);
        LOG.debug("Ask for '{}({})'", (Object)typeRef.getSimpleName(), key);
        EntityInvocationHandler handler = this.getContext().entityContext().getEntity(uuid);
        if (handler == null) {
            ClientEntity entity = this.getClient().getObjectFactory().newEntity(new FullQualifiedName(typeRef.getAnnotation(Namespace.class).value(), ClassUtils.getEntityTypeName(typeRef)));
            handler = EntityInvocationHandler.getInstance(key, entity, this.baseURI, typeRef, this.service);
        }
        if (this.isDeleted(handler)) {
            LOG.debug("Object '{}({})' has been deleted", (Object)typeRef.getSimpleName(), (Object)uuid);
            return null;
        }
        handler.clearQueryOptions();
        return (S)((EntityType)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{typeRef}, (InvocationHandler)handler));
    }

    public EC execute() {
        return (EC)this.execute(this.collItemRef);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> Future<SEC> executeAsync(final Class<SEC> collTypeRef) {
        return this.service.getClient().getConfiguration().getExecutor().submit(new Callable<SEC>(){

            @Override
            public SEC call() throws Exception {
                return EntitySetInvocationHandler.this.execute(collTypeRef);
            }
        });
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> SEC execute(Class<SEC> collTypeRef) {
        Class<?> ref = ClassUtils.extractTypeArg(collTypeRef, AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class);
        Class<?> oref = ClassUtils.extractTypeArg(this.collItemRef, AbstractEntitySet.class, AbstractSingleton.class, EntityCollection.class);
        if (!oref.equals(ref)) {
            this.uri.appendDerivedEntityTypeSegment(new FullQualifiedName(ClassUtils.getNamespace(ref), ClassUtils.getEntityTypeName(ref)).toString());
        }
        ArrayList<ClientAnnotation> anns = new ArrayList<ClientAnnotation>();
        Triple<List<?>, URI, List<ClientAnnotation>> entitySet = this.fetchPartial(this.uri.build(), ref);
        anns.addAll((Collection)entitySet.getRight());
        EntityCollectionInvocationHandler entityCollectionHandler = new EntityCollectionInvocationHandler(this.service, (List)entitySet.getLeft(), collTypeRef, this.baseURI, this.uri);
        entityCollectionHandler.setAnnotations(anns);
        entityCollectionHandler.nextPageURI = (URI)entitySet.getMiddle();
        return (SEC)((EntityCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collTypeRef}, entityCollectionHandler));
    }

    @Override
    public Search<T, EC> createSearch() {
        return new SearchImpl(this.getClient(), this.collItemRef, this.baseURI, this);
    }

    @Override
    public <S extends T, SEC extends EntityCollection<S, ?, ?>> Search<S, SEC> createSearch(Class<SEC> reference) {
        return new SearchImpl(this.getClient(), reference, this.baseURI, this);
    }

    public <S extends T, SEC extends EntityCollection<S, ?, ?>> SEC fetchWholeEntitySet(URIBuilder uriBuilder, Class<S> typeRef, Class<SEC> collTypeRef) {
        ArrayList res = new ArrayList();
        ArrayList<ClientAnnotation> anns = new ArrayList<ClientAnnotation>();
        URI nextURI = uriBuilder.build();
        while (nextURI != null) {
            Triple<List<S>, URI, List<ClientAnnotation>> entitySet = this.fetchPartial(nextURI, typeRef);
            res.addAll((List)entitySet.getLeft());
            nextURI = (URI)entitySet.getMiddle();
            anns.addAll((Collection)entitySet.getRight());
        }
        EntityCollectionInvocationHandler entityCollectionHandler = new EntityCollectionInvocationHandler(this.service, res, collTypeRef, this.targetEntitySetURI, uriBuilder);
        entityCollectionHandler.setAnnotations(anns);
        return (SEC)((EntityCollection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{collTypeRef}, entityCollectionHandler));
    }

    @Override
    public void delete(KEY key) throws IllegalArgumentException {
        EntityContext entityContext = this.getContext().entityContext();
        EntityInvocationHandler entity = entityContext.getEntity(new EntityUUID(this.baseURI, this.itemRef, key));
        if (entity == null) {
            T searched = this.getByKey(key);
            entity = (EntityInvocationHandler)Proxy.getInvocationHandler(searched);
            entityContext.attach(entity, AttachedEntityStatus.DELETED);
        } else {
            entityContext.setStatus(entity, AttachedEntityStatus.DELETED);
        }
    }

    @Override
    public <S extends T> void delete(S entity) {
        this.deleteEntity((EntityInvocationHandler)Proxy.getInvocationHandler(entity), this.baseURI);
    }

    @Override
    public <S extends T> void delete(Iterable<S> entities) {
        for (EntityType en : entities) {
            this.delete((S)en);
        }
    }

    public EntitySetIterator<T, KEY, EC> iterator() {
        return new EntitySetIterator(this.getClient().newURIBuilder(this.uri.build().toASCIIString()).build(), this);
    }
}

