/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlLabeledElement;

@JsonDeserialize(using=LabeledElementDeserializer.class)
class ClientCsdlLabeledElement
extends CsdlLabeledElement
implements Serializable {
    private static final long serialVersionUID = 4909387630253341824L;

    ClientCsdlLabeledElement() {
    }

    static class LabeledElementDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlLabeledElement> {
        LabeledElementDeserializer() {
        }

        @Override
        protected ClientCsdlLabeledElement doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlLabeledElement element = new ClientCsdlLabeledElement();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        element.setName(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        element.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    } else {
                        element.setValue((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                    }
                }
                jp.nextToken();
            }
            return element;
        }
    }
}

