/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.List;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoAll;
import org.apache.olingo.server.api.uri.UriInfoBatch;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoEntityId;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoMetadata;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriInfoService;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceCount;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceIt;
import org.apache.olingo.server.api.uri.UriResourceLambdaAll;
import org.apache.olingo.server.api.uri.UriResourceLambdaAny;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceRef;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.DeltaTokenOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.core.RequestURLVisitor;

public class RequestURLHierarchyVisitor
implements RequestURLVisitor {
    private UriInfo uriInfo;

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public void visit(UriInfo info) {
        this.uriInfo = info;
        UriInfoKind kind = info.getKind();
        switch (kind) {
            case all: {
                this.visit(info.asUriInfoAll());
                break;
            }
            case batch: {
                this.visit(info.asUriInfoBatch());
                break;
            }
            case crossjoin: {
                this.visit(info.asUriInfoCrossjoin());
                break;
            }
            case entityId: {
                this.visit(info.asUriInfoEntityId());
                break;
            }
            case metadata: {
                this.visit(info.asUriInfoMetadata());
                break;
            }
            case resource: {
                this.visit(info.asUriInfoResource());
                break;
            }
            case service: {
                this.visit(info.asUriInfoService());
            }
        }
    }

    @Override
    public void visit(UriInfoService info) {
    }

    @Override
    public void visit(UriInfoAll info) {
    }

    @Override
    public void visit(UriInfoBatch info) {
    }

    @Override
    public void visit(UriInfoCrossjoin info) {
        if (info.getFilterOption() != null) {
            this.visit(info.getFilterOption());
        }
        if (info.getCountOption() != null) {
            this.visit(info.getCountOption());
        }
        if (info.getOrderByOption() != null) {
            this.visit(info.getOrderByOption());
        }
        if (info.getSkipOption() != null) {
            this.visit(info.getSkipOption());
        }
        if (info.getTopOption() != null) {
            this.visit(info.getTopOption());
        }
        if (info.getExpandOption() != null) {
            this.visit(info.getExpandOption());
        }
        if (info.getSelectOption() != null) {
            this.visit(info.getSelectOption());
        }
        if (info.getFormatOption() != null) {
            this.visit(info.getFormatOption());
        }
        if (info.getSkipTokenOption() != null) {
            this.visit(info.getSkipTokenOption());
        }
    }

    @Override
    public void visit(UriInfoEntityId info) {
        this.visit(info.getSelectOption());
        if (info.getExpandOption() != null) {
            this.visit(info.getExpandOption());
        }
        if (info.getFormatOption() != null) {
            this.visit(info.getFormatOption());
        }
        if (info.getIdOption() != null) {
            this.visit(info.getIdOption(), info.getEntityTypeCast());
        }
    }

    @Override
    public void visit(UriInfoMetadata info) {
    }

    @Override
    public void visit(UriInfoResource info) {
        List parts = info.getUriResourceParts();
        for (UriResource resource : parts) {
            switch (resource.getKind()) {
                case action: {
                    this.visit((UriResourceAction)resource);
                    break;
                }
                case complexProperty: {
                    this.visit((UriResourceComplexProperty)resource);
                    break;
                }
                case count: {
                    this.visit((UriResourceCount)resource);
                    break;
                }
                case entitySet: {
                    this.visit((UriResourceEntitySet)resource);
                    break;
                }
                case function: {
                    this.visit((UriResourceFunction)resource);
                    break;
                }
                case it: {
                    this.visit((UriResourceIt)resource);
                    break;
                }
                case lambdaAll: {
                    this.visit((UriResourceLambdaAll)resource);
                    break;
                }
                case lambdaAny: {
                    this.visit((UriResourceLambdaAny)resource);
                    break;
                }
                case lambdaVariable: {
                    this.visit((UriResourceLambdaVariable)resource);
                    break;
                }
                case navigationProperty: {
                    this.visit((UriResourceNavigation)resource);
                    break;
                }
                case ref: {
                    this.visit((UriResourceRef)resource);
                    break;
                }
                case root: {
                    this.visit((UriResourceRoot)resource);
                    break;
                }
                case primitiveProperty: {
                    this.visit((UriResourcePrimitiveProperty)resource);
                    break;
                }
                case singleton: {
                    this.visit((UriResourceSingleton)resource);
                    break;
                }
                case value: {
                    this.visit((UriResourceValue)resource);
                }
            }
        }
        if (info.getApplyOption() != null) {
            this.visit(info.getApplyOption());
        }
        if (info.getSearchOption() != null) {
            this.visit(info.getSearchOption());
        }
        if (info.getFilterOption() != null) {
            this.visit(info.getFilterOption());
        }
        if (info.getCountOption() != null) {
            this.visit(info.getCountOption());
        }
        this.visit(info.getOrderByOption());
        if (info.getSkipOption() != null) {
            this.visit(info.getSkipOption());
        }
        if (info.getTopOption() != null) {
            this.visit(info.getTopOption());
        }
        if (info.getExpandOption() != null) {
            this.visit(info.getExpandOption());
        }
        this.visit(info.getSelectOption());
        if (info.getFormatOption() != null) {
            this.visit(info.getFormatOption());
        }
        if (info.getIdOption() != null) {
            this.visit(info.getIdOption(), null);
        }
        if (info.getSkipTokenOption() != null) {
            this.visit(info.getSkipTokenOption());
        }
        if (info.getDeltaTokenOption() != null) {
            this.visit(info.getDeltaTokenOption());
        }
    }

    @Override
    public void visit(ApplyOption option) {
    }

    @Override
    public void visit(ExpandOption option) {
    }

    @Override
    public void visit(FilterOption info) {
    }

    @Override
    public void visit(FormatOption info) {
    }

    @Override
    public void visit(IdOption info, EdmEntityType type) {
    }

    @Override
    public void visit(CountOption info) {
    }

    @Override
    public void visit(OrderByOption option) {
    }

    @Override
    public void visit(SearchOption option) {
    }

    @Override
    public void visit(SelectOption option) {
    }

    @Override
    public void visit(SkipOption option) {
    }

    @Override
    public void visit(SkipTokenOption option) {
    }

    @Override
    public void visit(TopOption option) {
    }

    @Override
    public void visit(UriResourceCount option) {
    }

    @Override
    public void visit(UriResourceRef info) {
    }

    @Override
    public void visit(DeltaTokenOption option) {
    }

    @Override
    public void visit(UriResourceRoot info) {
    }

    @Override
    public void visit(UriResourceValue info) {
    }

    @Override
    public void visit(UriResourceAction info) {
    }

    @Override
    public void visit(UriResourceEntitySet info) {
    }

    @Override
    public void visit(UriResourceFunction info) {
    }

    @Override
    public void visit(UriResourceIt info) {
    }

    @Override
    public void visit(UriResourceLambdaAll info) {
    }

    @Override
    public void visit(UriResourceLambdaAny info) {
    }

    @Override
    public void visit(UriResourceLambdaVariable info) {
    }

    @Override
    public void visit(UriResourceNavigation info) {
    }

    @Override
    public void visit(UriResourceSingleton info) {
    }

    @Override
    public void visit(UriResourceComplexProperty info) {
    }

    @Override
    public void visit(UriResourcePrimitiveProperty info) {
    }
}

