/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.core.edm.EdmParameterImpl;
import org.apache.olingo.commons.core.edm.EdmReturnTypeImpl;
import org.apache.olingo.commons.core.edm.EdmTypeImpl;

public abstract class AbstractEdmOperation
extends EdmTypeImpl
implements EdmOperation {
    private final CsdlOperation operation;
    private Map<String, EdmParameter> parameters;
    private List<String> parameterNames;
    private EdmReturnType returnType;

    protected AbstractEdmOperation(Edm edm, FullQualifiedName name, CsdlOperation operation, EdmTypeKind kind) {
        super(edm, name, kind, (CsdlAnnotatable)operation);
        this.operation = operation;
    }

    public EdmParameter getParameter(String name) {
        if (this.parameters == null) {
            this.createParameters();
        }
        return this.parameters.get(name);
    }

    public List<String> getParameterNames() {
        if (this.parameterNames == null) {
            this.createParameters();
        }
        return Collections.unmodifiableList(this.parameterNames);
    }

    private void createParameters() {
        if (this.parameters == null) {
            LinkedHashMap<String, EdmParameter> parametersLocal = new LinkedHashMap<String, EdmParameter>();
            List providerParameters = this.operation.getParameters();
            if (providerParameters != null) {
                ArrayList<String> parameterNamesLocal = new ArrayList<String>(providerParameters.size());
                for (CsdlParameter parameter : providerParameters) {
                    parametersLocal.put(parameter.getName(), new EdmParameterImpl(this.edm, parameter));
                    parameterNamesLocal.add(parameter.getName());
                }
                this.parameters = parametersLocal;
                this.parameterNames = parameterNamesLocal;
            } else {
                this.parameterNames = Collections.emptyList();
            }
        }
    }

    public EdmEntitySet getReturnedEntitySet(EdmEntitySet bindingParameterEntitySet) {
        EdmEntitySet returnedEntitySet = null;
        if (bindingParameterEntitySet != null && this.operation.getEntitySetPath() != null) {
            EdmBindingTarget relatedBindingTarget = bindingParameterEntitySet.getRelatedBindingTarget(this.operation.getEntitySetPath());
            if (relatedBindingTarget == null) {
                throw new EdmException("Cannot find entity set with path: " + this.operation.getEntitySetPath());
            }
            if (relatedBindingTarget instanceof EdmEntitySet) {
                returnedEntitySet = (EdmEntitySet)relatedBindingTarget;
            } else {
                throw new EdmException("BindingTarget with name: " + relatedBindingTarget.getName() + " must be an entity set");
            }
        }
        return returnedEntitySet;
    }

    public EdmReturnType getReturnType() {
        if (this.returnType == null && this.operation.getReturnType() != null) {
            this.returnType = new EdmReturnTypeImpl(this.edm, this.operation.getReturnType());
        }
        return this.returnType;
    }

    public boolean isBound() {
        return this.operation.isBound();
    }

    public FullQualifiedName getBindingParameterTypeFqn() {
        if (this.isBound()) {
            CsdlParameter bindingParameter = (CsdlParameter)this.operation.getParameters().get(0);
            return bindingParameter.getTypeFQN();
        }
        return null;
    }

    public Boolean isBindingParameterTypeCollection() {
        if (this.isBound()) {
            CsdlParameter bindingParameter = (CsdlParameter)this.operation.getParameters().get(0);
            return bindingParameter.isCollection();
        }
        return null;
    }

    public String getEntitySetPath() {
        return this.operation.getEntitySetPath();
    }
}

